/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.integration.daytrader.AccountDataBean;
import org.apache.openjpa.integration.daytrader.QuoteDataBean;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity(name="holdingejb")
@Table(name="holdingejb")
@NamedQueries(value={@NamedQuery(name="holdingejb.findByPurchaseprice", query="SELECT h FROM holdingejb h WHERE h.purchasePrice = :purchaseprice"), @NamedQuery(name="holdingejb.findByHoldingid", query="SELECT h FROM holdingejb h WHERE h.holdingID = :holdingid"), @NamedQuery(name="holdingejb.findByQuantity", query="SELECT h FROM holdingejb h WHERE h.quantity = :quantity"), @NamedQuery(name="holdingejb.findByPurchasedate", query="SELECT h FROM holdingejb h WHERE h.purchaseDate = :purchasedate"), @NamedQuery(name="holdingejb.holdingsByUserID", query="SELECT h FROM holdingejb h where h.account.profile.userID = :userID")})
public class HoldingDataBean
implements Serializable,
PersistenceCapable {
    private static final long serialVersionUID = 4779293652434823280L;
    @TableGenerator(name="holdingIdGen", table="KEYGENEJB", pkColumnName="KEYNAME", valueColumnName="KEYVAL", pkColumnValue="holding", allocationSize=1000)
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="holdingIdGen")
    @Column(name="HOLDINGID", nullable=false)
    private Integer holdingID;
    @Column(name="QUANTITY", nullable=false)
    private double quantity;
    @Column(name="PURCHASEPRICE")
    private BigDecimal purchasePrice;
    @Column(name="PURCHASEDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date purchaseDate;
    @Transient
    private String quoteID;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ACCOUNT_ACCOUNTID")
    private AccountDataBean account;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="QUOTE_SYMBOL")
    private QuoteDataBean quote;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean;
    private transient Object pcDetachedState;

    public HoldingDataBean() {
    }

    public HoldingDataBean(Integer holdingID, double quantity, BigDecimal purchasePrice, Date purchaseDate, String quoteID) {
        this.setHoldingID(holdingID);
        this.setQuantity(quantity);
        this.setPurchasePrice(purchasePrice);
        this.setPurchaseDate(purchaseDate);
        this.setQuoteID(quoteID);
    }

    public HoldingDataBean(double quantity, BigDecimal purchasePrice, Date purchaseDate, AccountDataBean account, QuoteDataBean quote) {
        this.setQuantity(quantity);
        this.setPurchasePrice(purchasePrice);
        this.setPurchaseDate(purchaseDate);
        this.setAccount(account);
        this.setQuote(quote);
    }

    public static HoldingDataBean getRandomInstance() {
        return new HoldingDataBean(new Integer(TradeConfig.rndInt(100000)), TradeConfig.rndQuantity(), TradeConfig.rndBigDecimal(1000.0f), new Date(TradeConfig.rndInt(Integer.MAX_VALUE)), TradeConfig.rndSymbol());
    }

    public String toString() {
        return "\n\tHolding Data for holding: " + this.getHoldingID() + "\n\t\t      quantity:" + this.getQuantity() + "\n\t\t purchasePrice:" + this.getPurchasePrice() + "\n\t\t  purchaseDate:" + this.getPurchaseDate() + "\n\t\t       quoteID:" + this.getQuoteID();
    }

    public String toHTML() {
        return "<BR>Holding Data for holding: " + this.getHoldingID() + "</B>" + "<LI>      quantity:" + this.getQuantity() + "</LI>" + "<LI> purchasePrice:" + this.getPurchasePrice() + "</LI>" + "<LI>  purchaseDate:" + this.getPurchaseDate() + "</LI>" + "<LI>       quoteID:" + this.getQuoteID() + "</LI>";
    }

    public void print() {
    }

    public Integer getHoldingID() {
        return HoldingDataBean.pcGetholdingID(this);
    }

    public void setHoldingID(Integer holdingID) {
        HoldingDataBean.pcSetholdingID(this, holdingID);
    }

    public double getQuantity() {
        return HoldingDataBean.pcGetquantity(this);
    }

    public void setQuantity(double quantity) {
        HoldingDataBean.pcSetquantity(this, quantity);
    }

    public BigDecimal getPurchasePrice() {
        return HoldingDataBean.pcGetpurchasePrice(this);
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        HoldingDataBean.pcSetpurchasePrice(this, purchasePrice);
    }

    public Date getPurchaseDate() {
        return HoldingDataBean.pcGetpurchaseDate(this);
    }

    public void setPurchaseDate(Date purchaseDate) {
        HoldingDataBean.pcSetpurchaseDate(this, purchaseDate);
    }

    public String getQuoteID() {
        if (HoldingDataBean.pcGetquote(this) != null) {
            return HoldingDataBean.pcGetquote(this).getSymbol();
        }
        return this.quoteID;
    }

    public void setQuoteID(String quoteID) {
        this.quoteID = quoteID;
    }

    public AccountDataBean getAccount() {
        return HoldingDataBean.pcGetaccount(this);
    }

    public void setAccount(AccountDataBean account) {
        HoldingDataBean.pcSetaccount(this, account);
    }

    public QuoteDataBean getQuote() {
        return HoldingDataBean.pcGetquote(this);
    }

    public void setQuote(QuoteDataBean quote) {
        HoldingDataBean.pcSetquote(this, quote);
    }

    public int hashCode() {
        int hash = 0;
        return hash += HoldingDataBean.pcGetholdingID(this) != null ? HoldingDataBean.pcGetholdingID(this).hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HoldingDataBean)) {
            return false;
        }
        HoldingDataBean other = (HoldingDataBean)object;
        return HoldingDataBean.pcGetholdingID(this) == HoldingDataBean.pcGetholdingID(other) || HoldingDataBean.pcGetholdingID(this) != null && HoldingDataBean.pcGetholdingID(this).equals(HoldingDataBean.pcGetholdingID(other));
    }

    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        pcFieldNames = new String[]{"account", "holdingID", "purchaseDate", "purchasePrice", "quantity", "quote"};
        Class[] classArray = new Class[6];
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean : (class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean = HoldingDataBean.class$("org.apache.openjpa.integration.daytrader.AccountDataBean"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = HoldingDataBean.class$("java.lang.Integer"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = HoldingDataBean.class$("java.util.Date"));
        classArray[2] = clazz3;
        Class clazz4 = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = HoldingDataBean.class$("java.math.BigDecimal"));
        classArray[3] = clazz4;
        classArray[4] = Double.TYPE;
        Class clazz5 = class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean : (class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean = HoldingDataBean.class$("org.apache.openjpa.integration.daytrader.QuoteDataBean"));
        classArray[5] = clazz5;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 26, 26, 26, 26, 26};
        Class clazz6 = class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean : (class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean = HoldingDataBean.class$("org.apache.openjpa.integration.daytrader.HoldingDataBean"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"holdingejb", (PersistenceCapable)new HoldingDataBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.account = null;
        this.holdingID = null;
        this.purchaseDate = null;
        this.purchasePrice = null;
        this.quantity = 0.0;
        this.quote = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        HoldingDataBean holdingDataBean = new HoldingDataBean();
        if (bl) {
            holdingDataBean.pcClearFields();
        }
        holdingDataBean.pcStateManager = stateManager;
        holdingDataBean.pcCopyKeyFieldsFromObjectId(object);
        return holdingDataBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        HoldingDataBean holdingDataBean = new HoldingDataBean();
        if (bl) {
            holdingDataBean.pcClearFields();
        }
        holdingDataBean.pcStateManager = stateManager;
        return holdingDataBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 6;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.account = (AccountDataBean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.holdingID = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.purchaseDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.purchasePrice = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.quantity = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.quote = (QuoteDataBean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.account);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.holdingID);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.purchaseDate);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.purchasePrice);
                return;
            }
            case 4: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.quantity);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.quote);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(HoldingDataBean holdingDataBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.account = holdingDataBean.account;
                return;
            }
            case 1: {
                this.holdingID = holdingDataBean.holdingID;
                return;
            }
            case 2: {
                this.purchaseDate = holdingDataBean.purchaseDate;
                return;
            }
            case 3: {
                this.purchasePrice = holdingDataBean.purchasePrice;
                return;
            }
            case 4: {
                this.quantity = holdingDataBean.quantity;
                return;
            }
            case 5: {
                this.quote = holdingDataBean.quote;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        HoldingDataBean holdingDataBean = (HoldingDataBean)object;
        if (holdingDataBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(holdingDataBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeObjectField(1 + pcInheritedFieldCount, (Object)new Integer(intId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.holdingID = new Integer(intId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean : (class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean = HoldingDataBean.class$("org.apache.openjpa.integration.daytrader.HoldingDataBean"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean : (class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean = HoldingDataBean.class$("org.apache.openjpa.integration.daytrader.HoldingDataBean"));
        return new IntId(clazz, this.holdingID);
    }

    private static final AccountDataBean pcGetaccount(HoldingDataBean holdingDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            return holdingDataBean.account;
        }
        int n = pcInheritedFieldCount + 0;
        holdingDataBean.pcStateManager.accessingField(n);
        return holdingDataBean.account;
    }

    private static final void pcSetaccount(HoldingDataBean holdingDataBean, AccountDataBean accountDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            holdingDataBean.account = accountDataBean;
            return;
        }
        holdingDataBean.pcStateManager.settingObjectField((PersistenceCapable)holdingDataBean, pcInheritedFieldCount + 0, (Object)holdingDataBean.account, (Object)accountDataBean, 0);
    }

    private static final Integer pcGetholdingID(HoldingDataBean holdingDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            return holdingDataBean.holdingID;
        }
        int n = pcInheritedFieldCount + 1;
        holdingDataBean.pcStateManager.accessingField(n);
        return holdingDataBean.holdingID;
    }

    private static final void pcSetholdingID(HoldingDataBean holdingDataBean, Integer n) {
        if (holdingDataBean.pcStateManager == null) {
            holdingDataBean.holdingID = n;
            return;
        }
        holdingDataBean.pcStateManager.settingObjectField((PersistenceCapable)holdingDataBean, pcInheritedFieldCount + 1, (Object)holdingDataBean.holdingID, (Object)n, 0);
    }

    private static final Date pcGetpurchaseDate(HoldingDataBean holdingDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            return holdingDataBean.purchaseDate;
        }
        int n = pcInheritedFieldCount + 2;
        holdingDataBean.pcStateManager.accessingField(n);
        return holdingDataBean.purchaseDate;
    }

    private static final void pcSetpurchaseDate(HoldingDataBean holdingDataBean, Date date) {
        if (holdingDataBean.pcStateManager == null) {
            holdingDataBean.purchaseDate = date;
            return;
        }
        holdingDataBean.pcStateManager.settingObjectField((PersistenceCapable)holdingDataBean, pcInheritedFieldCount + 2, (Object)holdingDataBean.purchaseDate, (Object)date, 0);
    }

    private static final BigDecimal pcGetpurchasePrice(HoldingDataBean holdingDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            return holdingDataBean.purchasePrice;
        }
        int n = pcInheritedFieldCount + 3;
        holdingDataBean.pcStateManager.accessingField(n);
        return holdingDataBean.purchasePrice;
    }

    private static final void pcSetpurchasePrice(HoldingDataBean holdingDataBean, BigDecimal bigDecimal) {
        if (holdingDataBean.pcStateManager == null) {
            holdingDataBean.purchasePrice = bigDecimal;
            return;
        }
        holdingDataBean.pcStateManager.settingObjectField((PersistenceCapable)holdingDataBean, pcInheritedFieldCount + 3, (Object)holdingDataBean.purchasePrice, (Object)bigDecimal, 0);
    }

    private static final double pcGetquantity(HoldingDataBean holdingDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            return holdingDataBean.quantity;
        }
        int n = pcInheritedFieldCount + 4;
        holdingDataBean.pcStateManager.accessingField(n);
        return holdingDataBean.quantity;
    }

    private static final void pcSetquantity(HoldingDataBean holdingDataBean, double d) {
        if (holdingDataBean.pcStateManager == null) {
            holdingDataBean.quantity = d;
            return;
        }
        holdingDataBean.pcStateManager.settingDoubleField((PersistenceCapable)holdingDataBean, pcInheritedFieldCount + 4, holdingDataBean.quantity, d, 0);
    }

    private static final QuoteDataBean pcGetquote(HoldingDataBean holdingDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            return holdingDataBean.quote;
        }
        int n = pcInheritedFieldCount + 5;
        holdingDataBean.pcStateManager.accessingField(n);
        return holdingDataBean.quote;
    }

    private static final void pcSetquote(HoldingDataBean holdingDataBean, QuoteDataBean quoteDataBean) {
        if (holdingDataBean.pcStateManager == null) {
            holdingDataBean.quote = quoteDataBean;
            return;
        }
        holdingDataBean.pcStateManager.settingObjectField((PersistenceCapable)holdingDataBean, pcInheritedFieldCount + 5, (Object)holdingDataBean.quote, (Object)quoteDataBean, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.holdingID != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

