/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.integration.daytrader.AccountProfileDataBean;
import org.apache.openjpa.integration.daytrader.HoldingDataBean;
import org.apache.openjpa.integration.daytrader.OrderDataBean;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity(name="accountejb")
@Table(name="accountejb")
@NamedQueries(value={@NamedQuery(name="accountejb.findByCreationdate", query="SELECT a FROM accountejb a WHERE a.creationDate = :creationdate"), @NamedQuery(name="accountejb.findByOpenbalance", query="SELECT a FROM accountejb a WHERE a.openBalance = :openbalance"), @NamedQuery(name="accountejb.findByLogoutcount", query="SELECT a FROM accountejb a WHERE a.logoutCount = :logoutcount"), @NamedQuery(name="accountejb.findByBalance", query="SELECT a FROM accountejb a WHERE a.balance = :balance"), @NamedQuery(name="accountejb.findByAccountid", query="SELECT a FROM accountejb a WHERE a.accountID = :accountid"), @NamedQuery(name="accountejb.findByAccountid_eager", query="SELECT a FROM accountejb a LEFT JOIN FETCH a.profile WHERE a.accountID = :accountid"), @NamedQuery(name="accountejb.findByAccountid_eagerholdings", query="SELECT a FROM accountejb a LEFT JOIN FETCH a.holdings WHERE a.accountID = :accountid"), @NamedQuery(name="accountejb.findByLastlogin", query="SELECT a FROM accountejb a WHERE a.lastLogin = :lastlogin"), @NamedQuery(name="accountejb.findByLogincount", query="SELECT a FROM accountejb a WHERE a.loginCount = :logincount")})
public class AccountDataBean
implements Serializable,
PersistenceCapable {
    private static final long serialVersionUID = -7478907635822129745L;
    @TableGenerator(name="accountIdGen", table="KEYGENEJB", pkColumnName="KEYNAME", valueColumnName="KEYVAL", pkColumnValue="account", allocationSize=1000)
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="accountIdGen")
    @Column(name="ACCOUNTID", nullable=false)
    private Integer accountID;
    @Column(name="LOGINCOUNT", nullable=false)
    private int loginCount;
    @Column(name="LOGOUTCOUNT", nullable=false)
    private int logoutCount;
    @Column(name="LASTLOGIN")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLogin;
    @Column(name="CREATIONDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="BALANCE")
    private BigDecimal balance;
    @Column(name="OPENBALANCE")
    private BigDecimal openBalance;
    @OneToMany(mappedBy="account", fetch=FetchType.LAZY)
    private Collection<OrderDataBean> orders;
    @OneToMany(mappedBy="account", fetch=FetchType.LAZY)
    private Collection<HoldingDataBean> holdings;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROFILE_USERID")
    private AccountProfileDataBean profile;
    @Transient
    private String profileID;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$AccountProfileDataBean;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean;
    private transient Object pcDetachedState;

    public AccountDataBean() {
    }

    public AccountDataBean(Integer accountID, int loginCount, int logoutCount, Date lastLogin, Date creationDate, BigDecimal balance, BigDecimal openBalance, String profileID) {
        this.setAccountID(accountID);
        this.setLoginCount(loginCount);
        this.setLogoutCount(logoutCount);
        this.setLastLogin(lastLogin);
        this.setCreationDate(creationDate);
        this.setBalance(balance);
        this.setOpenBalance(openBalance);
        this.setProfileID(profileID);
    }

    public AccountDataBean(int loginCount, int logoutCount, Date lastLogin, Date creationDate, BigDecimal balance, BigDecimal openBalance, String profileID) {
        this.setLoginCount(loginCount);
        this.setLogoutCount(logoutCount);
        this.setLastLogin(lastLogin);
        this.setCreationDate(creationDate);
        this.setBalance(balance);
        this.setOpenBalance(openBalance);
        this.setProfileID(profileID);
    }

    public static AccountDataBean getRandomInstance() {
        return new AccountDataBean(new Integer(TradeConfig.rndInt(100000)), TradeConfig.rndInt(10000), TradeConfig.rndInt(10000), new Date(), new Date(TradeConfig.rndInt(Integer.MAX_VALUE)), TradeConfig.rndBigDecimal(1000000.0f), TradeConfig.rndBigDecimal(1000000.0f), TradeConfig.rndUserID());
    }

    public String toString() {
        return "\n\tAccount Data for account: " + this.getAccountID() + "\n\t\t   loginCount:" + this.getLoginCount() + "\n\t\t  logoutCount:" + this.getLogoutCount() + "\n\t\t    lastLogin:" + this.getLastLogin() + "\n\t\t creationDate:" + this.getCreationDate() + "\n\t\t      balance:" + this.getBalance() + "\n\t\t  openBalance:" + this.getOpenBalance() + "\n\t\t    profileID:" + this.getProfileID();
    }

    public String toHTML() {
        return "<BR>Account Data for account: <B>" + this.getAccountID() + "</B>" + "<LI>   loginCount:" + this.getLoginCount() + "</LI>" + "<LI>  logoutCount:" + this.getLogoutCount() + "</LI>" + "<LI>    lastLogin:" + this.getLastLogin() + "</LI>" + "<LI> creationDate:" + this.getCreationDate() + "</LI>" + "<LI>      balance:" + this.getBalance() + "</LI>" + "<LI>  openBalance:" + this.getOpenBalance() + "</LI>" + "<LI>    profileID:" + this.getProfileID() + "</LI>";
    }

    public void print() {
    }

    public Integer getAccountID() {
        return AccountDataBean.pcGetaccountID(this);
    }

    public void setAccountID(Integer accountID) {
        AccountDataBean.pcSetaccountID(this, accountID);
    }

    public int getLoginCount() {
        return AccountDataBean.pcGetloginCount(this);
    }

    public void setLoginCount(int loginCount) {
        AccountDataBean.pcSetloginCount(this, loginCount);
    }

    public int getLogoutCount() {
        return AccountDataBean.pcGetlogoutCount(this);
    }

    public void setLogoutCount(int logoutCount) {
        AccountDataBean.pcSetlogoutCount(this, logoutCount);
    }

    public Date getLastLogin() {
        return AccountDataBean.pcGetlastLogin(this);
    }

    public void setLastLogin(Date lastLogin) {
        AccountDataBean.pcSetlastLogin(this, lastLogin);
    }

    public Date getCreationDate() {
        return AccountDataBean.pcGetcreationDate(this);
    }

    public void setCreationDate(Date creationDate) {
        AccountDataBean.pcSetcreationDate(this, creationDate);
    }

    public BigDecimal getBalance() {
        return AccountDataBean.pcGetbalance(this);
    }

    public void setBalance(BigDecimal balance) {
        AccountDataBean.pcSetbalance(this, balance);
    }

    public BigDecimal getOpenBalance() {
        return AccountDataBean.pcGetopenBalance(this);
    }

    public void setOpenBalance(BigDecimal openBalance) {
        AccountDataBean.pcSetopenBalance(this, openBalance);
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public Collection<OrderDataBean> getOrders() {
        return AccountDataBean.pcGetorders(this);
    }

    public void setOrders(Collection<OrderDataBean> orders) {
        AccountDataBean.pcSetorders(this, orders);
    }

    public Collection<HoldingDataBean> getHoldings() {
        return AccountDataBean.pcGetholdings(this);
    }

    public void setHoldings(Collection<HoldingDataBean> holdings) {
        AccountDataBean.pcSetholdings(this, holdings);
    }

    public AccountProfileDataBean getProfile() {
        return AccountDataBean.pcGetprofile(this);
    }

    public void setProfile(AccountProfileDataBean profile) {
        AccountDataBean.pcSetprofile(this, profile);
    }

    public void login(String password) {
        AccountProfileDataBean profile = this.getProfile();
        if (profile == null || !profile.getPassword().equals(password)) {
            String error = "AccountBean:Login failure for account: " + this.getAccountID() + (profile == null ? "null AccountProfile" : "\n\tIncorrect password-->" + profile.getUserID() + ":" + profile.getPassword());
            throw new RuntimeException(error);
        }
        this.setLastLogin(new Timestamp(System.currentTimeMillis()));
        this.setLoginCount(this.getLoginCount() + 1);
    }

    public void logout() {
        this.setLogoutCount(this.getLogoutCount() + 1);
    }

    public int hashCode() {
        int hash = 0;
        return hash += AccountDataBean.pcGetaccountID(this) != null ? AccountDataBean.pcGetaccountID(this).hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountDataBean)) {
            return false;
        }
        AccountDataBean other = (AccountDataBean)object;
        return AccountDataBean.pcGetaccountID(this) == AccountDataBean.pcGetaccountID(other) || AccountDataBean.pcGetaccountID(this) != null && AccountDataBean.pcGetaccountID(this).equals(AccountDataBean.pcGetaccountID(other));
    }

    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        pcFieldNames = new String[]{"accountID", "balance", "creationDate", "holdings", "lastLogin", "loginCount", "logoutCount", "openBalance", "orders", "profile"};
        Class[] classArray = new Class[10];
        Class clazz = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = AccountDataBean.class$("java.lang.Integer"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = AccountDataBean.class$("java.math.BigDecimal"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AccountDataBean.class$("java.util.Date"));
        classArray[2] = clazz3;
        Class clazz4 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = AccountDataBean.class$("java.util.Collection"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AccountDataBean.class$("java.util.Date"));
        classArray[5] = Integer.TYPE;
        classArray[6] = Integer.TYPE;
        classArray[7] = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = AccountDataBean.class$("java.math.BigDecimal"));
        classArray[8] = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = AccountDataBean.class$("java.util.Collection"));
        Class clazz5 = class$Lorg$apache$openjpa$integration$daytrader$AccountProfileDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$AccountProfileDataBean : (class$Lorg$apache$openjpa$integration$daytrader$AccountProfileDataBean = AccountDataBean.class$("org.apache.openjpa.integration.daytrader.AccountProfileDataBean"));
        classArray[9] = clazz5;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 5, 26, 26, 26, 26, 5, 21};
        Class clazz6 = class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean : (class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean = AccountDataBean.class$("org.apache.openjpa.integration.daytrader.AccountDataBean"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"accountejb", (PersistenceCapable)new AccountDataBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.accountID = null;
        this.balance = null;
        this.creationDate = null;
        this.holdings = null;
        this.lastLogin = null;
        this.loginCount = 0;
        this.logoutCount = 0;
        this.openBalance = null;
        this.orders = null;
        this.profile = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        AccountDataBean accountDataBean = new AccountDataBean();
        if (bl) {
            accountDataBean.pcClearFields();
        }
        accountDataBean.pcStateManager = stateManager;
        accountDataBean.pcCopyKeyFieldsFromObjectId(object);
        return accountDataBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        AccountDataBean accountDataBean = new AccountDataBean();
        if (bl) {
            accountDataBean.pcClearFields();
        }
        accountDataBean.pcStateManager = stateManager;
        return accountDataBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 10;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountID = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.balance = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.creationDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.holdings = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.lastLogin = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.loginCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.logoutCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.openBalance = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.orders = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.profile = (AccountProfileDataBean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountID);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.balance);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.creationDate);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.holdings);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastLogin);
                return;
            }
            case 5: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.loginCount);
                return;
            }
            case 6: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.logoutCount);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.openBalance);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.orders);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.profile);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AccountDataBean accountDataBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountID = accountDataBean.accountID;
                return;
            }
            case 1: {
                this.balance = accountDataBean.balance;
                return;
            }
            case 2: {
                this.creationDate = accountDataBean.creationDate;
                return;
            }
            case 3: {
                this.holdings = accountDataBean.holdings;
                return;
            }
            case 4: {
                this.lastLogin = accountDataBean.lastLogin;
                return;
            }
            case 5: {
                this.loginCount = accountDataBean.loginCount;
                return;
            }
            case 6: {
                this.logoutCount = accountDataBean.logoutCount;
                return;
            }
            case 7: {
                this.openBalance = accountDataBean.openBalance;
                return;
            }
            case 8: {
                this.orders = accountDataBean.orders;
                return;
            }
            case 9: {
                this.profile = accountDataBean.profile;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AccountDataBean accountDataBean = (AccountDataBean)object;
        if (accountDataBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(accountDataBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeObjectField(0 + pcInheritedFieldCount, (Object)new Integer(intId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.accountID = new Integer(intId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean : (class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean = AccountDataBean.class$("org.apache.openjpa.integration.daytrader.AccountDataBean"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean : (class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean = AccountDataBean.class$("org.apache.openjpa.integration.daytrader.AccountDataBean"));
        return new IntId(clazz, this.accountID);
    }

    private static final Integer pcGetaccountID(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.accountID;
        }
        int n = pcInheritedFieldCount + 0;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.accountID;
    }

    private static final void pcSetaccountID(AccountDataBean accountDataBean, Integer n) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.accountID = n;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 0, (Object)accountDataBean.accountID, (Object)n, 0);
    }

    private static final BigDecimal pcGetbalance(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.balance;
        }
        int n = pcInheritedFieldCount + 1;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.balance;
    }

    private static final void pcSetbalance(AccountDataBean accountDataBean, BigDecimal bigDecimal) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.balance = bigDecimal;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 1, (Object)accountDataBean.balance, (Object)bigDecimal, 0);
    }

    private static final Date pcGetcreationDate(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.creationDate;
        }
        int n = pcInheritedFieldCount + 2;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.creationDate;
    }

    private static final void pcSetcreationDate(AccountDataBean accountDataBean, Date date) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.creationDate = date;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 2, (Object)accountDataBean.creationDate, (Object)date, 0);
    }

    private static final Collection pcGetholdings(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.holdings;
        }
        int n = pcInheritedFieldCount + 3;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.holdings;
    }

    private static final void pcSetholdings(AccountDataBean accountDataBean, Collection collection) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.holdings = collection;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 3, accountDataBean.holdings, (Object)collection, 0);
    }

    private static final Date pcGetlastLogin(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.lastLogin;
        }
        int n = pcInheritedFieldCount + 4;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.lastLogin;
    }

    private static final void pcSetlastLogin(AccountDataBean accountDataBean, Date date) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.lastLogin = date;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 4, (Object)accountDataBean.lastLogin, (Object)date, 0);
    }

    private static final int pcGetloginCount(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.loginCount;
        }
        int n = pcInheritedFieldCount + 5;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.loginCount;
    }

    private static final void pcSetloginCount(AccountDataBean accountDataBean, int n) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.loginCount = n;
            return;
        }
        accountDataBean.pcStateManager.settingIntField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 5, accountDataBean.loginCount, n, 0);
    }

    private static final int pcGetlogoutCount(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.logoutCount;
        }
        int n = pcInheritedFieldCount + 6;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.logoutCount;
    }

    private static final void pcSetlogoutCount(AccountDataBean accountDataBean, int n) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.logoutCount = n;
            return;
        }
        accountDataBean.pcStateManager.settingIntField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 6, accountDataBean.logoutCount, n, 0);
    }

    private static final BigDecimal pcGetopenBalance(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.openBalance;
        }
        int n = pcInheritedFieldCount + 7;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.openBalance;
    }

    private static final void pcSetopenBalance(AccountDataBean accountDataBean, BigDecimal bigDecimal) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.openBalance = bigDecimal;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 7, (Object)accountDataBean.openBalance, (Object)bigDecimal, 0);
    }

    private static final Collection pcGetorders(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.orders;
        }
        int n = pcInheritedFieldCount + 8;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.orders;
    }

    private static final void pcSetorders(AccountDataBean accountDataBean, Collection collection) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.orders = collection;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 8, accountDataBean.orders, (Object)collection, 0);
    }

    private static final AccountProfileDataBean pcGetprofile(AccountDataBean accountDataBean) {
        if (accountDataBean.pcStateManager == null) {
            return accountDataBean.profile;
        }
        int n = pcInheritedFieldCount + 9;
        accountDataBean.pcStateManager.accessingField(n);
        return accountDataBean.profile;
    }

    private static final void pcSetprofile(AccountDataBean accountDataBean, AccountProfileDataBean accountProfileDataBean) {
        if (accountDataBean.pcStateManager == null) {
            accountDataBean.profile = accountProfileDataBean;
            return;
        }
        accountDataBean.pcStateManager.settingObjectField((PersistenceCapable)accountDataBean, pcInheritedFieldCount + 9, (Object)accountDataBean.profile, (Object)accountProfileDataBean, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.accountID != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

