/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.example.gallery.constraint;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.openjpa.example.gallery.ImageType;
import org.apache.openjpa.example.gallery.constraint.ImageContent;

public class ImageContentValidator
implements ConstraintValidator<ImageContent, byte[]> {
    private List<ImageType> allowedTypes = null;

    public void initialize(ImageContent constraint) {
        this.allowedTypes = Arrays.asList(constraint.value());
    }

    public boolean isValid(byte[] value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        if (this.allowedTypes.contains((Object)ImageType.GIF)) {
            String gifHeader = new String(value, 0, 6);
            if (value.length >= 6 && (gifHeader.equalsIgnoreCase("GIF87a") || gifHeader.equalsIgnoreCase("GIF89a"))) {
                return true;
            }
        }
        return this.allowedTypes.contains((Object)ImageType.JPEG) && value.length >= 4 && value[0] == 255 && value[1] == 216 && value[value.length - 2] == 255 && value[value.length - 1] == 217;
    }
}

