/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.example.gallery;

import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import junit.framework.TestCase;
import org.apache.openjpa.example.gallery.ImageType;
import org.apache.openjpa.example.gallery.model.Image;
import org.apache.openjpa.example.gallery.model.Location;

public class TestJPAValidation
extends TestCase {
    public void testValidation() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"BeanValidation");
        EntityManager em = emf.createEntityManager();
        Location loc = new Location();
        loc.setCity("Rochester");
        loc.setState("MN");
        loc.setZipCode("55901");
        loc.setCountry("USA");
        Image img = new Image();
        img.setType(ImageType.JPEG);
        img.setFileName("Winter_01.gif");
        TestJPAValidation.loadImage(img);
        img.setLocation(loc);
        try {
            em.getTransaction().begin();
            System.out.println("Persisting an entity with non-matching extension and type");
            em.persist((Object)img);
            TestJPAValidation.fail();
        }
        catch (ConstraintViolationException cve) {
            em.getTransaction().rollback();
            TestJPAValidation.handleConstraintViolation(cve);
            em.getTransaction().begin();
            System.out.println("Fixing the file type and re-attempting the persist.");
            img.setType(ImageType.GIF);
            em.persist((Object)img);
            em.getTransaction().commit();
            System.out.println("Persist was successful");
        }
        try {
            em.getTransaction().begin();
            System.out.println("Modifying file name to use an extension that does not");
            System.out.println("match the file type.  This will cause a CVE.");
            img.setFileName("Winter_01.jpg");
            em.getTransaction().commit();
            TestJPAValidation.fail();
        }
        catch (ConstraintViolationException cve) {
            System.out.println("Update failed as expected");
            TestJPAValidation.handleConstraintViolation(cve);
        }
        img = (Image)em.merge((Object)img);
        em.getTransaction().begin();
        try {
            System.out.println("Setting the type to an invalid type.  This will cause a");
            System.out.println("validation exception upon removal");
            img.setType(null);
            em.remove((Object)img);
            TestJPAValidation.fail();
        }
        catch (ConstraintViolationException cve) {
            em.getTransaction().rollback();
            System.out.println("Remove failed as expected");
            TestJPAValidation.handleConstraintViolation(cve);
        }
        em.close();
        emf.close();
        System.out.println("Done");
    }

    private static void handleConstraintViolation(ConstraintViolationException cve) {
        Set cvs = cve.getConstraintViolations();
        for (ConstraintViolation cv : cvs) {
            System.out.println("------------------------------------------------");
            System.out.println("Violation: " + cv.getMessage());
            System.out.println("Entity: " + cv.getRootBeanClass().getSimpleName());
            if (cv.getLeafBean() != null && cv.getRootBean() != cv.getLeafBean()) {
                System.out.println("Embeddable: " + cv.getLeafBean().getClass().getSimpleName());
            }
            System.out.println("Attribute: " + cv.getPropertyPath());
            System.out.println("Invalid value: " + cv.getInvalidValue());
            System.out.println("------------------------------------------------");
        }
    }

    private static void loadImage(Image img) {
        img.setData(new byte[]{71, 73, 70, 56, 57, 97});
    }
}

