/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.example.gallery.constraint;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.openjpa.example.gallery.ImageType;
import org.apache.openjpa.example.gallery.constraint.ImageConstraint;
import org.apache.openjpa.example.gallery.model.Image;

public class ImageValidator
implements ConstraintValidator<ImageConstraint, Image> {
    private List<ImageType> allowedTypes = null;

    public void initialize(ImageConstraint constraint) {
        this.allowedTypes = Arrays.asList(constraint.value());
    }

    public boolean isValid(Image value, ConstraintValidatorContext context) {
        String gifHeader;
        if (value == null) {
            return true;
        }
        byte[] data = value.getData();
        String fileName = value.getFileName();
        ImageType type = value.getType();
        if (this.allowedTypes.contains((Object)ImageType.GIF) && type == ImageType.GIF && fileName.endsWith(".gif") && data != null && data.length >= 6 && ((gifHeader = new String(data, 0, 6)).equalsIgnoreCase("GIF87a") || gifHeader.equalsIgnoreCase("GIF89a"))) {
            return true;
        }
        return this.allowedTypes.contains((Object)ImageType.JPEG) && value.getType() == ImageType.JPEG && (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) && data.length >= 4 && data[0] == 255 && data[1] == 216 && data[data.length - 2] == 255 && data[data.length - 1] == 217;
    }
}

