/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.context.WebContextsService;

public class WebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    private final String contextKey = this.getClass().getName() + "@" + this.hashCode();
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansListener.class);
    protected FailOverService failoverService;
    protected ContainerLifecycle lifeCycle = null;
    protected WebBeansContext webBeansContext;

    public WebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
        }
        Object oldContext = event.getServletRequest().getAttribute(this.contextKey);
        try {
            ELContextStore elStore;
            HttpServletRequest httpRequest;
            HttpSession session;
            ServletRequest request;
            if (this.failoverService != null && this.failoverService.isSupportFailOver() && (request = event.getServletRequest()) instanceof HttpServletRequest && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
                this.failoverService.sessionIsIdle(session);
            }
            if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
                elStore.destroyELContextStore();
            }
            if (this.lifeCycle != null) {
                this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)event);
            }
            this.cleanupRequestThreadLocals();
        }
        finally {
            ThreadSingletonServiceImpl.enter((WebBeansContext)((WebBeansContext)oldContext));
        }
    }

    private void cleanupRequestThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        WebContextsService.removeThreadLocals();
    }

    public void requestInitialized(ServletRequestEvent event) {
        WebBeansContext oldContext = ThreadSingletonServiceImpl.enter((WebBeansContext)this.webBeansContext);
        event.getServletRequest().setAttribute(this.contextKey, (Object)oldContext);
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a new request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
            }
            this.webBeansContext.getContextsService().startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.error("ERROR_0019", new Object[]{event.getServletRequest()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            this.webBeansContext.getContextsService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.webBeansContext.getContextsService().endContext(SessionScoped.class, (Object)event.getSession());
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.failoverService != null && this.failoverService.isSupportPassivation()) {
            HttpSession session = event.getSession();
            this.failoverService.sessionWillPassivate(session);
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (this.failoverService.isSupportFailOver() || this.failoverService.isSupportPassivation()) {
            HttpSession session = event.getSession();
            this.failoverService.restoreBeans(session);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            OpenEJBLifecycle.initializeServletContext((ServletContext)servletContextEvent.getServletContext(), (WebBeansContext)this.webBeansContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

