/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.loader.Loader;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.server.ejbd.EjbServer;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;
import org.apache.tomee.catalina.DeploymentExceptionManager;
import org.apache.tomee.catalina.OpenEJBNamingContextListener;
import org.apache.tomee.catalina.TomcatThreadContextListener;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.catalina.WebDeploymentListeners;
import org.apache.tomee.installer.Installer;
import org.apache.tomee.installer.Paths;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatLoader
implements Loader {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, TomcatLoader.class);
    private EjbServer ejbServer;
    private ServiceManager manager;
    private List<ServerService> services = new ArrayList<ServerService>();

    public void init(Properties properties) throws Exception {
        this.initDefaults(properties);
        SystemInstance.init((Properties)properties);
        this.initialize(properties);
    }

    public void initDefaults(Properties properties) {
        this.setIfNull(properties, "openejb.deployments.classpath", "true");
        this.setIfNull(properties, "openejb.deployments.classpath.filter.systemapps", "false");
        this.setIfNull(properties, "openejb.provider.default", "org.apache.tomee");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties properties) throws Exception {
        Installer installer;
        Paths paths;
        OptionsLog.install();
        String openejbWarDir = properties.getProperty("openejb.war");
        if (openejbWarDir != null && (paths = new Paths(new File(openejbWarDir))).verify() && (installer = new Installer(paths)).getStatus() != Installer.Status.INSTALLED) {
            installer.installConfigFiles();
        }
        if (OpenEJB.isInitialized()) {
            this.ejbServer = (EjbServer)SystemInstance.get().getComponent(EjbServer.class);
            return;
        }
        FileInputStream fin = null;
        try {
            File conf = SystemInstance.get().getBase().getDirectory("conf");
            File file = new File(conf, "system.properties");
            if (file.exists()) {
                System.out.println("Processing conf/system.properties: " + file.toString());
                Properties systemProperties = new Properties();
                fin = new FileInputStream(file);
                BufferedInputStream in = new BufferedInputStream(fin);
                systemProperties.load(in);
                System.getProperties().putAll((Map<?, ?>)systemProperties);
                SystemInstance.get().getProperties().putAll((Map<?, ?>)systemProperties);
            }
        }
        catch (IOException e) {
            System.out.println("Processing conf/system.properties failed: " + e.getMessage());
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        System.setProperty("openejb.home", SystemInstance.get().getHome().getDirectory().getAbsolutePath());
        System.setProperty("openejb.base", SystemInstance.get().getBase().getDirectory().getAbsolutePath());
        ThreadContext.addThreadContextListener((ThreadContextListener)new TomcatThreadContextListener());
        TomcatWebAppBuilder tomcatWebAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        if (tomcatWebAppBuilder == null) {
            tomcatWebAppBuilder = new TomcatWebAppBuilder();
            tomcatWebAppBuilder.start();
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)tomcatWebAppBuilder);
        }
        SystemInstance.get().setComponent(DeploymentExceptionManager.class, (Object)new DeploymentExceptionManager());
        SystemInstance.get().setComponent(WebDeploymentListeners.class, (Object)new WebDeploymentListeners());
        this.optionalService(properties, "org.apache.tomee.webservices.TomeeJaxRsService");
        this.optionalService(properties, "org.apache.tomee.webservices.TomeeJaxWsService");
        this.ejbServer = new EjbServer();
        SystemInstance.get().setComponent(EjbServer.class, (Object)this.ejbServer);
        OpenEJB.init((Properties)properties, (ApplicationServer)new ServerFederation());
        Properties ejbServerProps = new Properties();
        ejbServerProps.putAll((Map<?, ?>)properties);
        ejbServerProps.setProperty("openejb.ejbd.uri", "http://127.0.0.1:8080/openejb/ejb");
        this.ejbServer.init(ejbServerProps);
        StandardServer standardServer = TomcatHelper.getServer();
        OpenEJBNamingContextListener namingContextListener = new OpenEJBNamingContextListener(standardServer);
        if (standardServer.getGlobalNamingContext() != null) {
            namingContextListener.start();
        }
        standardServer.addLifecycleListener((LifecycleListener)namingContextListener);
        this.processRunningApplications(tomcatWebAppBuilder, standardServer);
        if (Boolean.getBoolean("openejb.servicemanager.enabled")) {
            this.manager = ServiceManager.getManager();
            this.manager.init();
            this.manager.start(false);
        } else {
            try {
                ServerService cxfService = (ServerService)Class.forName("org.apache.openejb.server.cxf.CxfService").newInstance();
                cxfService.start();
                this.services.add(cxfService);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (Exception e) {
                Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, this.getClass());
                logger.error("Webservices failed to start", (Throwable)e);
            }
            try {
                ServerService restService = (ServerService)Class.forName("org.apache.openejb.server.cxf.rs.CxfRSService").newInstance();
                restService.start();
                this.services.add(restService);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (Exception e) {
                logger.error("REST failed to start", (Throwable)e);
            }
        }
        standardServer.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                String type = event.getType();
                if ("after_stop".equals(type)) {
                    TomcatLoader.this.destroy();
                }
            }
        });
    }

    private void optionalService(Properties properties, String className) {
        try {
            org.apache.openejb.spi.Service service = (org.apache.openejb.spi.Service)this.getClass().getClassLoader().loadClass(className).newInstance();
            service.init(properties);
        }
        catch (ClassNotFoundException e) {
            logger.info("Optional service not installed: " + className);
        }
        catch (Exception e) {
            logger.error("Failed to start: " + className, (Throwable)e);
        }
    }

    private void setIfNull(Properties properties, String key, String value) {
        if (!properties.containsKey(key)) {
            properties.setProperty(key, value);
        }
    }

    public void destroy() {
        for (ServerService s : this.services) {
            try {
                s.stop();
            }
            catch (ServiceException serviceException) {}
        }
        if (this.manager != null) {
            try {
                this.manager.stop();
            }
            catch (ServiceException e) {
                // empty catch block
            }
            this.manager = null;
        }
        if (this.ejbServer != null) {
            try {
                this.ejbServer.stop();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            this.ejbServer = null;
        }
        OpenEJB.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRunningApplications(TomcatWebAppBuilder tomcatWebAppBuilder, StandardServer standardServer) {
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            Engine engine = (Engine)service.getContainer();
            for (Container engineChild : engine.findChildren()) {
                if (!(engineChild instanceof Host)) continue;
                Host host = (Host)engineChild;
                for (Container hostChild : host.findChildren()) {
                    if (!(hostChild instanceof StandardContext)) continue;
                    StandardContext standardContext = (StandardContext)hostChild;
                    int state = TomcatHelper.getContextState((StandardContext)standardContext);
                    if (state == 0) {
                        tomcatWebAppBuilder.init(standardContext);
                        continue;
                    }
                    if (state != 1) continue;
                    standardContext.addParameter("openejb.start.late", "true");
                    ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(standardContext.getLoader().getClassLoader());
                    try {
                        tomcatWebAppBuilder.init(standardContext);
                        tomcatWebAppBuilder.beforeStart(standardContext);
                        tomcatWebAppBuilder.start(standardContext);
                        tomcatWebAppBuilder.afterStart(standardContext);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldCL);
                    }
                    standardContext.removeParameter("openejb.start.late");
                }
            }
        }
    }
}

