/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Container;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.RpcContainerWrapper;

public class TomcatJndiSupport
extends RpcContainerWrapper {
    private final Method bindContext;
    private final Method bindThread;
    private final Method unbindThread;
    public static Map<Object, Context> contexts = new HashMap<Object, Context>();

    public TomcatJndiSupport(RpcContainer container) throws OpenEJBException {
        super(container);
        BeanContext[] beanContexts;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> contextBindings = classLoader.loadClass("org.apache.naming.ContextBindings");
            this.bindContext = contextBindings.getMethod("bindContext", Object.class, Context.class, Object.class);
            this.bindThread = contextBindings.getMethod("bindThread", Object.class, Object.class);
            this.unbindThread = contextBindings.getMethod("unbindThread", Object.class, Object.class);
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("Unable to setup Tomcat JNDI support.  Support requires the org.apache.naming.ContextBindings class to be available.");
        }
        catch (NoSuchMethodException e) {
            throw new OpenEJBException("Unable to setup Tomcat JNDI support.  Method of org.apache.naming.ContextBindings was not found:" + e.getMessage());
        }
        for (BeanContext beanContext : beanContexts = container.getBeanContexts()) {
            this.setupDeployment(beanContext);
        }
    }

    public void init(Object containerId, HashMap deployments, Properties properties) throws OpenEJBException {
    }

    public void deploy(BeanContext beanContext) throws OpenEJBException {
        super.deploy(beanContext);
        this.setupDeployment(beanContext);
    }

    private void setupDeployment(BeanContext deployment) {
        deployment.setContainer((Container)this);
        Object deploymentID = deployment.getDeploymentID();
        Context jndiEnc = deployment.getJndiEnc();
        this.bindContext(deploymentID, jndiEnc);
        contexts.put(deploymentID, jndiEnc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        try {
            this.bindThread(deployID);
            Object object = super.invoke(deployID, callMethod, args, primKey, securityIdentity);
            return object;
        }
        finally {
            this.unbindThread(deployID);
        }
    }

    public void bindContext(Object name, Context context) {
        try {
            this.bindContext.invoke(null, name, context, name);
        }
        catch (Throwable e) {
            throw this.convertToRuntimeException(e, "bindContext");
        }
    }

    public void bindThread(Object name) {
        try {
            this.bindThread.invoke(null, name, name);
        }
        catch (Throwable e) {
            throw this.convertToRuntimeException(e, "bindThread");
        }
    }

    public void unbindThread(Object name) {
        try {
            this.unbindThread.invoke(null, name, name);
        }
        catch (Throwable e) {
            throw this.convertToRuntimeException(e, "unbindThread");
        }
    }

    private RuntimeException convertToRuntimeException(Throwable e, String methodName) {
        if (e instanceof InvocationTargetException) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                return (RuntimeException)cause;
            }
            e = cause;
        }
        return new RuntimeException("ContextBindings." + methodName, e);
    }
}

