/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openejb.assembler.classic.AppInfo;

public class DeploymentExceptionManager {
    private static final int MAX_SIZE = Integer.getInteger("tomee.deployement-exception-max-size", 10);
    private final Map<AppInfo, Exception> deploymentException = new LinkedHashMap<AppInfo, Exception>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<AppInfo, Exception> eldest) {
            return this.size() > MAX_SIZE;
        }
    };

    public synchronized boolean hasDelpoyementFailed(AppInfo appInfo) {
        return this.deploymentException.containsKey(appInfo);
    }

    public synchronized Exception getDelpoyementException(AppInfo appInfo) {
        return this.deploymentException.get(appInfo);
    }

    public synchronized Exception saveDelpoyementException(AppInfo appInfo, Exception exception) {
        return this.deploymentException.put(appInfo, exception);
    }

    public synchronized void clearDelpoyementException(AppInfo info) {
        this.deploymentException.remove(info);
    }

    public Exception getFirstException() {
        if (this.deploymentException.isEmpty()) {
            return null;
        }
        return this.deploymentException.values().iterator().next();
    }
}

