/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;

public class LazyStopWebappClassLoader
extends WebappClassLoader {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, (String)LazyStopWebappClassLoader.class.getName());
    private static final ThreadLocal<ClassLoaderConfigurer> INIT_CONFIGURER = new ThreadLocal();
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();
    public static final String TOMEE_WEBAPP_FIRST = "tomee.webapp-first";
    public static final String CLASS_EXTENSION = ".class";
    private boolean restarting;
    private final boolean forceStopPhase = Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.webappclassloader.force-stop-phase", "false"));
    private ClassLoaderConfigurer configurer;
    private final boolean isEar;
    private final ClassLoader containerClassLoader;
    private volatile boolean originalDelegate;
    private final int hashCode;
    private Collection<File> additionalRepos;
    private final Map<String, Boolean> filterTempCache = new HashMap<String, Boolean>();

    public LazyStopWebappClassLoader() {
        this.j2seClassLoader = LazyStopWebappClassLoader.getSystemClassLoader();
        this.hashCode = this.construct();
        this.containerClassLoader = ParentClassLoaderFinder.Helper.get();
        this.isEar = this.getParent() != this.containerClassLoader;
        this.originalDelegate = this.getDelegate();
    }

    public LazyStopWebappClassLoader(ClassLoader parent) {
        super(parent);
        this.j2seClassLoader = LazyStopWebappClassLoader.getSystemClassLoader();
        this.hashCode = this.construct();
        this.setJavaseClassLoader(LazyStopWebappClassLoader.getSystemClassLoader());
        this.containerClassLoader = ParentClassLoaderFinder.Helper.get();
        this.isEar = this.getParent() != this.containerClassLoader;
        this.originalDelegate = this.getDelegate();
    }

    private int construct() {
        this.setDelegate(LazyStopWebappClassLoader.isDelegate());
        this.configurer = INIT_CONFIGURER.get();
        return super.hashCode();
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
        this.originalDelegate = delegate;
    }

    public void stop() throws LifecycleException {
        if (this.forceStopPhase && this.restarting) {
            this.internalStop();
        }
    }

    public Collection<File> getAdditionalRepos() {
        this.initAdditionalRepos();
        return this.additionalRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if ("org.apache.openejb.hibernate.OpenEJBJtaPlatform".equals(name) || "org.apache.openejb.jpa.integration.hibernate.PrefixNamingStrategy".equals(name) || "org.apache.openejb.jpa.integration.eclipselink.PrefixSessionCustomizer".equals(name) || "org.apache.openejb.eclipselink.JTATransactionController".equals(name) || "org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name)) {
            LazyStopWebappClassLoader lazyStopWebappClassLoader = this;
            synchronized (lazyStopWebappClassLoader) {
                Class clazz;
                ClassLoader old = this.getJavaseClassLoader();
                this.j2seClassLoader = NoClassClassLoader.INSTANCE;
                this.delegate = false;
                try {
                    clazz = super.loadClass(name, resolve);
                }
                catch (Throwable throwable) {
                    this.setJavaseClassLoader(old);
                    this.setDelegate(this.originalDelegate);
                    throw throwable;
                }
                this.setJavaseClassLoader(old);
                this.setDelegate(this.originalDelegate);
                return clazz;
            }
        }
        if (URLClassLoaderFirst.shouldDelegateToTheContainer((ClassLoader)((Object)this), (String)name)) {
            try {
                return OpenEJB.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LazyStopWebappClassLoader old = this;
                synchronized (old) {
                    return super.loadClass(name, resolve);
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                LazyStopWebappClassLoader old = this;
                synchronized (old) {
                    return super.loadClass(name, resolve);
                }
            }
        }
        if (name.startsWith("javax.faces.") || name.startsWith("org.apache.webbeans.jsf.")) {
            LazyStopWebappClassLoader lazyStopWebappClassLoader = this;
            synchronized (lazyStopWebappClassLoader) {
                Class old;
                this.delegate = false;
                try {
                    old = super.loadClass(name, resolve);
                    this.setDelegate(this.originalDelegate);
                }
                catch (Throwable throwable) {
                    this.setDelegate(this.originalDelegate);
                    throw throwable;
                }
                return old;
            }
        }
        LazyStopWebappClassLoader lazyStopWebappClassLoader = this;
        synchronized (lazyStopWebappClassLoader) {
            if (this.isEar) {
                boolean filter = this.filter(name);
                this.filterTempCache.put(name, filter);
                if (!filter) {
                    if (URLClassLoaderFirst.class.isInstance(this.getParent())) {
                        URLClassLoaderFirst urlClassLoaderFirst = (URLClassLoaderFirst)URLClassLoaderFirst.class.cast(this.getParent());
                        Class c = urlClassLoaderFirst.findAlreadyLoadedClass(name);
                        if (c != null) {
                            return c;
                        }
                        c = urlClassLoaderFirst.loadInternal(name, resolve);
                        if (c != null) {
                            return c;
                        }
                    }
                    return this.loadWithDelegate(this.getResource(name.replace('.', '/') + CLASS_EXTENSION) == null, resolve, name);
                }
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadWithDelegate(boolean delegate, boolean resolve, String name) throws ClassNotFoundException {
        this.setDelegate(delegate);
        try {
            Class clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            this.filterTempCache.remove(name);
            this.setDelegate(this.originalDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filter(String name) {
        if ("org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name)) {
            return false;
        }
        if (this.isEar) {
            LazyStopWebappClassLoader lazyStopWebappClassLoader = this;
            synchronized (lazyStopWebappClassLoader) {
                Boolean cache = this.filterTempCache.get(name);
                if (cache != null) {
                    return cache;
                }
            }
        }
        return URLClassLoaderFirst.shouldSkip((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalStop() throws LifecycleException {
        if (this.isStarted()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this));
            try {
                super.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    public void restarting() {
        this.restarting = true;
    }

    public void restarted() {
        this.restarting = false;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public synchronized void initAdditionalRepos() {
        if (this.additionalRepos != null) {
            return;
        }
        if (CONTEXT.get() != null) {
            String externalRepositories;
            this.additionalRepos = new LinkedList<File>();
            String root = CONTEXT.get().getServletContext().getRealPath("/");
            if (root != null && (externalRepositories = SystemInstance.get().getProperty("tomee." + new File(root).getName() + ".externalRepositories")) != null) {
                this.setSearchExternalFirst(true);
                for (String additional : externalRepositories.split(",")) {
                    String trim = additional.trim();
                    if (trim.isEmpty()) continue;
                    File file = new File(trim);
                    this.additionalRepos.add(file);
                }
            }
        }
    }

    public void start() throws LifecycleException {
        super.start();
        this.initAdditionalRepos();
        if (this.additionalRepos != null) {
            for (File f : this.additionalRepos) {
                try {
                    super.addRepository(f.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        if (this.configurer != null) {
            URL[] enrichment;
            for (URL url : enrichment = this.configurer.additionalURLs()) {
                super.addURL(url);
            }
        }
        for (URL url : ((WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)).enrichment((ClassLoader)((Object)this))) {
            super.addURL(url);
        }
    }

    public void addURL(URL url) {
        if (this.configurer == null || this.configurer.accept(url)) {
            super.addURL(url);
        }
    }

    protected boolean validateJarFile(File file) throws IOException {
        return super.validateJarFile(file) && TomEEClassLoaderEnricher.validateJarFile(file) && this.jarIsAccepted(file);
    }

    private boolean jarIsAccepted(File file) {
        if (this.configurer == null) {
            return true;
        }
        try {
            if (!this.configurer.accept(file.toURI().toURL())) {
                LOGGER.warning("jar '" + file.getAbsolutePath() + "' is excluded: " + file.getName() + ". It will be ignored.");
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isDelegate() {
        return !SystemInstance.get().getOptions().get(TOMEE_WEBAPP_FIRST, true);
    }

    public InputStream getResourceAsStream(String name) {
        if (!this.isStarted()) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.isStarted()) {
            return null;
        }
        if ("META-INF/services/javax.servlet.ServletContainerInitializer".equals(name)) {
            ArrayList list = new ArrayList(Collections.list(super.getResources(name)));
            Iterator it = list.iterator();
            while (it.hasNext()) {
                URL next = (URL)it.next();
                File file = Files.toFile((URL)next);
                if (file.isFile() || !NewLoaderLogic.skip((URL)next)) continue;
                it.remove();
            }
            return Collections.enumeration(list);
        }
        return URLClassLoaderFirst.filterResources((String)name, (Enumeration)super.getResources(name));
    }

    public boolean equals(Object other) {
        return other != null && ClassLoader.class.isInstance(other) && this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "LazyStop" + super.toString();
    }

    public static void initContext(ClassLoaderConfigurer configurer) {
        INIT_CONFIGURER.set(configurer);
    }

    public static void initContext(Context ctx) {
        CONTEXT.set(ctx);
    }

    public static void cleanContext() {
        INIT_CONFIGURER.remove();
        CONTEXT.remove();
    }

    private static class NoClassClassLoader
    extends ClassLoader {
        private static final NoClassClassLoader INSTANCE = new NoClassClassLoader();

        private NoClassClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }
    }
}

