/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.core.Application;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationListener;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.realm.DataSourceRealm;
import org.apache.catalina.startup.ContextConfig;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLConnection;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ParamValueInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.OpenEJBNamingResource;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.catalina.realm.TomEEDataSourceRealm;
import org.apache.tomee.common.ResourceFactory;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.xbean.finder.IAnnotationFinder;

public class OpenEJBContextConfig
extends ContextConfig {
    private static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB, OpenEJBContextConfig.class);
    private static final String MYFACES_TOMEEM_CONTAINER_INITIALIZER = "org.apache.tomee.myfaces.TomEEMyFacesContainerInitializer";
    private static final String TOMEE_MYFACES_CONTEXT_LISTENER = "org.apache.tomee.myfaces.TomEEMyFacesContextListener";
    private static final String ADJUST_DATASOURCE_JNDI_NAMES = SystemInstance.get().getProperty("tomee.resources.adjust-web-xml-jndi-name", "true");
    private static final File BASE = SystemInstance.get().getBase().getDirectory();
    private TomcatWebAppBuilder.StandardContextInfo info;
    private IAnnotationFinder finder = null;
    private ClassLoader tempLoader = null;
    private boolean webInfClassesAnnotationsProcessed = false;

    public OpenEJBContextConfig(TomcatWebAppBuilder.StandardContextInfo standardContextInfo) {
        logger.debug("OpenEJBContextConfig({0})", new Object[]{standardContextInfo.toString()});
        this.info = standardContextInfo;
    }

    public void finder(IAnnotationFinder finder, ClassLoader tmpLoader) {
        this.finder = finder;
        this.tempLoader = tmpLoader;
    }

    public void configureStart() {
        super.configureStart();
        this.adjustDataSourceNameIfNecessary();
        this.addAddedJAXWsServices();
        this.cleanUpRestServlets();
    }

    private void addAddedJAXWsServices() {
        WebAppInfo webAppInfo = this.info.get();
        AppInfo appInfo = this.info.app();
        if (webAppInfo == null || appInfo == null || "false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxws.add-missing-servlets", "true"))) {
            return;
        }
        try {
            OpenEJBContextConfig.class.getClassLoader().loadClass("org.apache.openejb.server.webservices.WsServlet");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (NoClassDefFoundError e) {
            return;
        }
        block3: for (ServletInfo servlet : webAppInfo.servlets) {
            if (!servlet.mappings.iterator().hasNext()) continue;
            for (ParamValueInfo pv : servlet.initParams) {
                if (!"openejb-internal".equals(pv.name) || !"true".equals(pv.value)) continue;
                if (this.context.findChild(servlet.servletName) != null) continue block3;
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName(servlet.servletName);
                wrapper.setServletClass("org.apache.openejb.server.webservices.WsServlet");
                this.context.addChild((Container)wrapper);
                this.context.addServletMapping((String)servlet.mappings.iterator().next(), wrapper.getName());
                continue block3;
            }
        }
    }

    private void cleanUpRestServlets() {
        WebAppInfo webAppInfo = this.info.get();
        AppInfo appInfo = this.info.app();
        if (webAppInfo == null || appInfo == null || "false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxrs.on", "true"))) {
            return;
        }
        Container[] children = this.context.findChildren();
        HashMap<String, Container> mappedChildren = new HashMap<String, Container>();
        if (children != null) {
            for (Container c : children) {
                if (!(c instanceof StandardWrapper)) continue;
                StandardWrapper wrapper = (StandardWrapper)c;
                String appSpec = wrapper.getInitParameter("javax.ws.rs.Application");
                if (appSpec != null) {
                    mappedChildren.put(appSpec, c);
                    continue;
                }
                String app = wrapper.getInitParameter(Application.class.getName());
                if (app != null) {
                    mappedChildren.put(app, c);
                    continue;
                }
                if (wrapper.getServletClass() != null) continue;
                try {
                    if (!Application.class.isAssignableFrom(this.context.getLoader().getClassLoader().loadClass(wrapper.getServletName()))) continue;
                    this.context.removeChild(c);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (String clazz : webAppInfo.restApplications) {
                Container child = (Container)mappedChildren.get(clazz);
                try {
                    String servletClass;
                    if (child == null || !"org.apache.openejb.server.rest.OpenEJBRestServlet".equals(servletClass = ((StandardWrapper)StandardWrapper.class.cast(child)).getServletClass()) && HttpServlet.class.isAssignableFrom(this.info.loader().loadClass(servletClass))) continue;
                    this.context.removeChild(child);
                }
                catch (NoClassDefFoundError e) {
                    this.context.removeChild(child);
                }
                catch (ClassNotFoundException e) {
                    this.context.removeChild(child);
                }
            }
        }
    }

    protected void processContextConfig(Digester digester, URL contextXml) {
        try {
            super.processContextConfig(digester, this.replaceKnownRealmsByTomEEOnes(contextXml));
        }
        catch (MalformedURLException e) {
            super.processContextConfig(digester, contextXml);
        }
    }

    private URL replaceKnownRealmsByTomEEOnes(final URL contextXml) throws MalformedURLException {
        return new URL(contextXml.getProtocol(), contextXml.getHost(), contextXml.getPort(), contextXml.getFile(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                final URLConnection c = contextXml.openConnection();
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                        c.connect();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IO.copy((InputStream)c.getInputStream(), (OutputStream)baos);
                        return new ByteArrayInputStream(new String(baos.toByteArray()).replace(DataSourceRealm.class.getName(), TomEEDataSourceRealm.class.getName()).getBytes());
                    }

                    @Override
                    public String toString() {
                        return c.toString();
                    }
                };
            }
        });
    }

    protected void contextConfig(Digester digester) {
        NamingResources resources = this.context != null ? this.context.getNamingResources() : null;
        if (resources instanceof OpenEJBNamingResource) {
            ((OpenEJBNamingResource)resources).setTomcatResource(true);
        }
        super.contextConfig(digester);
        if (resources instanceof OpenEJBNamingResource) {
            ((OpenEJBNamingResource)resources).setTomcatResource(false);
        }
    }

    private void adjustDataSourceNameIfNecessary() {
        if (this.context == null || "false".equalsIgnoreCase(ADJUST_DATASOURCE_JNDI_NAMES)) {
            return;
        }
        NamingResources resources = this.context.getNamingResources();
        if (resources == null) {
            return;
        }
        ContextResource[] foundResources = resources.findResources();
        String[] ids = null;
        if (foundResources != null) {
            for (ContextResource resource : foundResources) {
                if (!"javax.sql.DataSource".equals(resource.getType())) continue;
                String jndiName = (String)resource.getProperty("mappedName");
                if (jndiName == null) {
                    jndiName = resource.getName();
                }
                if (jndiName == null) continue;
                if (ids == null) {
                    Properties props = new Properties();
                    OpenEjbConfiguration runningConfig = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
                    ArrayList<String> resourceIds = new ArrayList<String>();
                    if (runningConfig != null) {
                        for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                            if (!ConfigurationFactory.isResourceType((String)resourceInfo.service, (List)resourceInfo.types, (String)"javax.sql.DataSource") || !ServiceUtils.implies((Properties)props, (Properties)resourceInfo.properties)) continue;
                            resourceIds.add(resourceInfo.id);
                        }
                    }
                    ids = resourceIds.toArray(new String[resourceIds.size()]);
                }
                String mostMatchingId = null;
                for (void var13_17 : ids) {
                    if (var13_17.equals(jndiName)) {
                        mostMatchingId = jndiName;
                        break;
                    }
                    if (jndiName.endsWith("/" + (String)var13_17) && mostMatchingId == null) {
                        mostMatchingId = var13_17;
                        continue;
                    }
                    if (!var13_17.endsWith("/" + jndiName) || mostMatchingId != null) continue;
                    mostMatchingId = "openejb/Resource/" + (String)var13_17;
                }
                if (mostMatchingId == null) continue;
                resource.setProperty("mappedName", (Object)("java:" + mostMatchingId));
                resource.setProperty("resourceid", (Object)("java:" + mostMatchingId));
                resource.setProperty("factory", (Object)ResourceFactory.class.getName());
            }
        }
    }

    protected WebXml createWebXml() {
        StandardContext standardContext;
        String prefix = "";
        if (this.context instanceof StandardContext && (prefix = (standardContext = (StandardContext)this.context).getEncodedPath()).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        return new OpenEJBWebXml(prefix);
    }

    protected void webConfig() {
        TomcatHelper.configureJarScanner((Context)this.context);
        super.webConfig();
        if (IgnoredStandardContext.class.isInstance(this.context)) {
            return;
        }
        try {
            this.context.getLoader().getClassLoader().loadClass("com.sun.faces.context.SessionMap");
            return;
        }
        catch (Throwable ignored) {
            try {
                Class<?> myfacesInitializer = Class.forName(MYFACES_TOMEEM_CONTAINER_INITIALIZER, true, this.context.getLoader().getClassLoader());
                ServletContainerInitializer instance = (ServletContainerInitializer)myfacesInitializer.newInstance();
                this.context.addServletContainerInitializer(instance, this.getJsfClasses(this.context));
                this.context.addApplicationListener(new ApplicationListener(TOMEE_MYFACES_CONTEXT_LISTENER, false));
            }
            catch (Exception ignored2) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return;
        }
    }

    private Set<Class<?>> getJsfClasses(Context context) {
        WebAppBuilder builder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        ClassLoader cl = context.getLoader().getClassLoader();
        Map scanned = (Map)builder.getJsfClasses().get(cl);
        if (scanned == null || scanned.isEmpty()) {
            return null;
        }
        HashSet classes = new HashSet();
        for (Set entry : scanned.values()) {
            for (String name : entry) {
                try {
                    classes.add(cl.loadClass(name));
                }
                catch (ClassNotFoundException ignored) {
                    logger.warning("class '" + name + "' was found but can't be loaded as a JSF class");
                }
            }
        }
        return classes;
    }

    protected void processServletContainerInitializers(ServletContext ctx) {
        this.webInfClassesAnnotationsProcessed = false;
        try {
            super.processServletContainerInitializers(ctx);
            if (this.typeInitializerMap.size() > 0 && this.finder != null) {
                ClassLoader loader = this.context.getLoader().getClassLoader();
                for (Map.Entry entry : this.typeInitializerMap.entrySet()) {
                    Class annotation = (Class)entry.getKey();
                    for (ServletContainerInitializer sci : (Set)entry.getValue()) {
                        if (annotation.isAnnotation()) {
                            try {
                                Class reloadedAnnotation = (Class)Class.class.cast(this.tempLoader.loadClass(annotation.getName()));
                                this.addClassesWithRightLoader(loader, sci, this.finder.findAnnotatedClasses(reloadedAnnotation));
                            }
                            catch (Throwable th) {}
                            continue;
                        }
                        try {
                            Class<?> reloadedClass = this.tempLoader.loadClass(annotation.getName());
                            List implementations = annotation.isInterface() ? (List)List.class.cast(this.finder.findImplementations(reloadedClass)) : (List)List.class.cast(this.finder.findSubclasses(reloadedClass));
                            this.addClassesWithRightLoader(loader, sci, implementations);
                        }
                        catch (Throwable th) {}
                    }
                }
            }
            this.finder = null;
            this.tempLoader = null;
        }
        catch (RuntimeException e) {
            this.webInfClassesAnnotationsProcessed = false;
            throw e;
        }
    }

    protected void processAnnotations(Set<WebXml> fragments, boolean handlesTypesOnly) {
        this.webInfClassesAnnotationsProcessed = false;
        super.processAnnotations(fragments, handlesTypesOnly);
    }

    protected void processAnnotationsFile(File file, WebXml fragment, boolean handlesTypesOnly) {
        try {
            if (NewLoaderLogic.skip((URL)file.toURI().toURL())) {
                return;
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo == null) {
            super.processAnnotationsFile(file, fragment, handlesTypesOnly);
            return;
        }
        this.internalProcessAnnotations(file, webAppInfo, fragment);
    }

    protected void processAnnotationsUrl(URL currentUrl, WebXml fragment, boolean handlesTypeOnly) {
        File currentUrlAsFile;
        if (NewLoaderLogic.skip((URL)currentUrl)) {
            return;
        }
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo == null) {
            super.processAnnotationsUrl(currentUrl, fragment, handlesTypeOnly);
            return;
        }
        try {
            currentUrlAsFile = URLs.toFile((URL)currentUrl);
        }
        catch (IllegalArgumentException iae) {
            if ("jndi".equals(currentUrl.getProtocol())) {
                String file = currentUrl.getFile();
                try {
                    URLConnection connection = currentUrl.openConnection();
                    if (connection instanceof DirContextURLConnection) {
                        DirContextURLStreamHandler handler = (DirContextURLStreamHandler)DirContextURLStreamHandler.class.cast(Reflections.get((Object)currentUrl, (String)"handler"));
                        ProxyDirContext dirContext = (ProxyDirContext)ProxyDirContext.class.cast(Reflections.get((Object)handler, (String)"context"));
                        String host = (String)String.class.cast(Reflections.get((Object)dirContext, (String)"hostName"));
                        String contextPath = (String)String.class.cast(Reflections.get((Object)dirContext, (String)"contextPath"));
                        Object context = Reflections.get((Object)dirContext, (String)"dirContext");
                        if (!BaseDirContext.class.isInstance(context)) {
                            throw new OpenEJBRuntimeException("Context not supported: " + context);
                        }
                        file = file.replace("/" + host + contextPath, ((BaseDirContext)BaseDirContext.class.cast(context)).getDocBase());
                    } else {
                        throw new OpenEJBRuntimeException("can't find webapp [" + webAppInfo.contextRoot + "], connection is not a DirContextURLConnection " + connection);
                    }
                    currentUrlAsFile = new File(file);
                }
                catch (Exception ex) {
                    throw new OpenEJBRuntimeException("can't find webapp [" + webAppInfo.contextRoot + "]", (Throwable)ex);
                }
            }
            throw new OpenEJBRuntimeException("protocol not supported '" + currentUrl.getProtocol() + "'");
        }
        this.internalProcessAnnotations(currentUrlAsFile, webAppInfo, fragment);
    }

    private void internalProcessAnnotations(File currentUrlAsFile, WebAppInfo webAppInfo, WebXml fragment) {
        for (ClassListInfo webAnnotated : webAppInfo.webAnnotatedClasses) {
            try {
                if (!this.isIncludedIn(webAnnotated.name, currentUrlAsFile)) continue;
                this.internalProcessAnnotationsStream(webAnnotated.list, fragment, false);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void addClassesWithRightLoader(ClassLoader loader, ServletContainerInitializer sci, List<Class<?>> implementations) throws ClassNotFoundException {
        Set classes = (Set)this.initializerClassMap.get(sci);
        for (Class<?> c : implementations) {
            classes.add(loader.loadClass(c.getName()));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalProcessAnnotationsStream(Collection<String> urls, WebXml fragment, boolean handlesTypeOnly) {
        Iterator<String> i$ = urls.iterator();
        while (i$.hasNext()) {
            String url = i$.next();
            InputStream is = null;
            try {
                is = new URL(url).openStream();
                this.processAnnotationsStream(is, fragment, handlesTypeOnly);
            }
            catch (MalformedURLException e) {
                try {
                    throw new IllegalArgumentException(e);
                    catch (IOException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close((Closeable)is);
        }
        return;
    }

    protected void processAnnotationWebServlet(String className, AnnotationEntry ae, WebXml fragment) {
        try {
            super.processAnnotationWebServlet(className, ae, fragment);
        }
        catch (IllegalArgumentException iae) {
            String[] urlPatterns = null;
            for (ElementValuePair elementValuePair : ae.getElementValuePairs()) {
                String name = elementValuePair.getNameString();
                if (!"value".equals(name) && !"urlPatterns".equals(name)) continue;
                urlPatterns = this.processAnnotationsStringArray(elementValuePair.getValue());
                break;
            }
            if (urlPatterns != null) {
                for (ElementValuePair elementValuePair : urlPatterns) {
                    if (!fragment.getServletMappings().containsKey(elementValuePair)) continue;
                    logger.warning(iae.getMessage(), (Throwable)iae);
                    return;
                }
            }
            throw iae;
        }
    }

    private boolean isIncludedIn(String filePath, File classAsFile) throws MalformedURLException {
        File file = URLs.toFile((URL)new URL(filePath));
        File current = classAsFile;
        boolean webInf = false;
        while (current != null && current.exists()) {
            if (current.equals(file)) {
                File parent = current.getParentFile();
                if ("classes".equals(current.getName()) && parent != null && "WEB-INF".equals(parent.getName())) {
                    if (this.webInfClassesAnnotationsProcessed) {
                        return false;
                    }
                    this.webInfClassesAnnotationsProcessed = true;
                    return true;
                }
                return true;
            }
            if (current.getName().equals("WEB-INF")) {
                webInf = true;
            }
            if (!BASE.equals(current = current.getParentFile())) continue;
            return false;
        }
        return (classAsFile == null || !classAsFile.getName().endsWith(".jar") || !file.getName().endsWith(".jar")) && !webInf;
    }

    public class OpenEJBWebXml
    extends WebXml {
        public static final String OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY = "openejb.web.xml.major";
        private String prefix;

        public OpenEJBWebXml(String prefix) {
            this.prefix = prefix;
        }

        public int getMajorVersion() {
            return SystemInstance.get().getOptions().get(this.prefix + "." + OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, SystemInstance.get().getOptions().get(OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, super.getMajorVersion()));
        }
    }
}

