/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.ClassLoaderComparator;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;

public class TomEEWebappLoader
extends WebappLoader {
    private ClassLoader appClassLoader;
    private TomEEClassLoader tomEEClassLoader;
    private String appPath;

    public TomEEWebappLoader(String appId, ClassLoader classLoader) {
        this.appPath = appId;
        this.appClassLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.tomEEClassLoader;
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        WebappClassLoader webappCl = (WebappClassLoader)super.getClassLoader();
        this.tomEEClassLoader = new TomEEClassLoader(this.appPath, this.appClassLoader, webappCl);
        try {
            DirContextURLStreamHandler.bind((ClassLoader)this.tomEEClassLoader, (DirContext)this.getContainer().getResources());
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            throw new LifecycleException("start: ", t);
        }
    }

    protected void stopInternal() throws LifecycleException {
        ClassLoader parent;
        this.setState(LifecycleState.STOPPING);
        if (this.getContainer() instanceof Context) {
            ServletContext servletContext = ((Context)this.getContainer()).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if ((parent = this.tomEEClassLoader.webapp.getParent()) instanceof WebappClassLoader && !((WebappClassLoader)parent).isStarted()) {
            this.tomEEClassLoader.webapp.setDelegate(false);
        }
        if (this.tomEEClassLoader.webapp.isStarted()) {
            this.tomEEClassLoader.webapp.stop();
        }
        if (this.appClassLoader instanceof WebappClassLoader && ((WebappClassLoader)this.appClassLoader).isStarted()) {
            ((WebappClassLoader)this.appClassLoader).stop();
        }
        DirContextURLStreamHandler.unbind((ClassLoader)this.tomEEClassLoader);
        try {
            StandardContext ctx = (StandardContext)this.getContainer();
            String contextName = ctx.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(MBeanUtils.getDomain((Container)ctx) + ":type=WebappClassLoader,context=" + contextName + ",host=" + ctx.getParent().getName());
            Registry.getRegistry(null, null).unregisterComponent(cloname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tomEEClassLoader = null;
    }

    public static class TomEEClassLoader
    extends URLClassLoader
    implements ClassLoaderComparator {
        private ClassLoader app;
        private WebappClassLoader webapp;
        private String appPath;

        public TomEEClassLoader(String appId, ClassLoader appCl, WebappClassLoader webappCl) {
            super(TomEEClassLoader.enrichedUrls(webappCl.getURLs(), (ClassLoader)webappCl), (ClassLoader)webappCl);
            this.appPath = appId;
            this.app = appCl;
            this.webapp = webappCl;
        }

        private static URL[] enrichedUrls(URL[] urLs, ClassLoader cl) {
            int i;
            ArrayList<Integer> skipped = new ArrayList<Integer>();
            for (int i2 = 0; i2 < urLs.length; ++i2) {
                File file;
                try {
                    file = URLs.toFile((URL)urLs[i2]);
                }
                catch (IllegalStateException ise) {
                    continue;
                }
                try {
                    if (TomEEClassLoaderEnricher.validateJarFile(file)) continue;
                    skipped.add(i2);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            URL[] additional = ((WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)).enrichment(cl);
            HashSet<URL> returnedUrls = new HashSet<URL>();
            for (i = 0; i < urLs.length; ++i) {
                if (skipped.contains(i)) continue;
                returnedUrls.add(urLs[i]);
            }
            for (i = 0; i < additional.length; ++i) {
                returnedUrls.add(additional[i]);
            }
            return returnedUrls.toArray(new URL[returnedUrls.size()]);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayEnumeration result;
            HashMap<String, URL> urls = new HashMap<String, URL>();
            if (this.webapp.isStarted() || this.webapp.getParent() == null) {
                this.add(urls, this.app.getResources(name));
                this.add(urls, this.webapp.getResources(name));
                result = new ArrayEnumeration(this.clear(urls.values()));
            } else {
                result = this.app.getResources(name);
            }
            if (TomEEClassLoaderEnricher.isSlf4jQuery(name)) {
                return TomEEClassLoaderEnricher.filterSlf4jImpl(result);
            }
            return result;
        }

        private List<URL> clear(Iterable<URL> urls) {
            ArrayList<URL> clean = new ArrayList<URL>();
            for (URL url : urls) {
                String urlStr = url.toExternalForm();
                URL jarUrl = null;
                if (urlStr.contains("!")) {
                    try {
                        jarUrl = new URL(urlStr.substring(0, urlStr.lastIndexOf(33)) + "!/");
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (jarUrl != null) {
                    URL cachedFile = ClassLoaderUtil.getUrlKeyCached((String)this.appPath, (File)URLs.toFile(jarUrl));
                    if (cachedFile != null) {
                        URL resource = null;
                        try {
                            resource = new URL("jar:file:" + cachedFile.getFile() + urlStr.substring(urlStr.lastIndexOf(33)));
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                        if (resource == null || clean.contains(resource)) continue;
                        clean.add(resource);
                        continue;
                    }
                    clean.add(url);
                    continue;
                }
                if (clean.contains(url)) continue;
                clean.add(url);
            }
            return clean;
        }

        private void add(Map<String, URL> urls, Enumeration<URL> enumUrls) {
            try {
                while (enumUrls.hasMoreElements()) {
                    URL url = enumUrls.nextElement();
                    urls.put(url.toExternalForm(), url);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public boolean equals(Object other) {
            return other == this || this.app.equals(other);
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public boolean isSame(ClassLoader classLoader) {
            return classLoader == this || this.webapp != null && this.webapp.equals(classLoader);
        }
    }
}

