/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.installer.Paths;

public final class TomEEClassLoaderEnricher
implements WebAppEnricher {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, TomEEClassLoaderEnricher.class);
    public static final String TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_SKIP = "tomee.webapp.classloader.enrichment.skip";
    public static final String TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_CLASSES = "tomee.webapp.classloader.enrichment.classes";
    public static final String TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_PREFIXES = "tomee.webapp.classloader.enrichment.prefixes";
    private static final String[] DEFAULT_CLASSES_WHICH_CAN_BE_LOADED_FROM_APP_ONLY = new String[]{"org.apache.webbeans.jsf.OwbApplicationFactory"};
    private static final String[] JAR_TO_ADD_CLASS_HELPERS;
    private static final String[] DEFAULT_PREFIXES_TO_ADD;
    private static final String[] PREFIXES_TO_ADD;
    private static final String[] FORBIDDEN_CLASSES;
    public static final String SLF4J_STATIC_LOGGER_BINDER_CLASS = "org/slf4j/impl/StaticLoggerBinder.class";

    public URL[] enrichment(ClassLoader appCl) {
        HashSet<URL> urls = new HashSet<URL>();
        ClassLoader cl = TomEEClassLoaderEnricher.class.getClassLoader();
        if (cl != appCl && appCl != null) {
            for (String name : JAR_TO_ADD_CLASS_HELPERS) {
                try {
                    URL url;
                    Class<?> clazz = cl.loadClass(name);
                    if (!clazz.getClassLoader().equals(OpenEJB.class.getClassLoader())) continue;
                    boolean add = false;
                    for (Class<?> itf : clazz.getInterfaces()) {
                        try {
                            Class<?> tcclLoaded = appCl.loadClass(itf.getName());
                            if (tcclLoaded.getClassLoader().equals(cl)) continue;
                            add = true;
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    for (Class<?> current = clazz.getSuperclass(); current != null && !Object.class.equals(current); current = current.getSuperclass()) {
                        try {
                            Class<?> tcclLoaded = appCl.loadClass(current.getName());
                            if (tcclLoaded.getClassLoader().equals(cl)) continue;
                            add = true;
                            break;
                        }
                        catch (Exception cnfe) {
                            // empty catch block
                        }
                    }
                    if (!add || (url = JarLocation.jarLocation(clazz).toURI().toURL()) == null) continue;
                    urls.add(url);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        Paths paths = new Paths(new File(System.getProperty("openejb.home")));
        for (String prefix : PREFIXES_TO_ADD) {
            File file = paths.findTomEELibJar(prefix);
            if (file == null) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        urls.addAll(Arrays.asList(((ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class)).applicationEnrichment()));
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateJarFile(File file) throws IOException {
        ClassLoader parent = TomEEClassLoaderEnricher.class.getClassLoader();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            for (String name : FORBIDDEN_CLASSES) {
                String entry;
                JarEntry jarEntry;
                boolean found = false;
                for (int i = 0; i < 2; ++i) {
                    try {
                        try {
                            parent.loadClass(name);
                            found = true;
                            break;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    catch (LinkageError le) {
                        // empty catch block
                    }
                }
                if (!found || (jarEntry = jarFile.getJarEntry(entry = name.replace('.', '/') + ".class")) == null) continue;
                LOGGER.warning("jar '" + file.getAbsolutePath() + "' contains offending class: " + name + ". It will be ignored.");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static boolean isSlf4jQuery(String name) {
        return SLF4J_STATIC_LOGGER_BINDER_CLASS.equals(name);
    }

    public static Enumeration<URL> filterSlf4jImpl(Enumeration<URL> result) {
        URL url;
        ArrayList<URL> values = Collections.list(result);
        if (values.size() > 1 && (url = TomEEClassLoaderEnricher.class.getResource("/org/slf4j/impl/StaticLoggerBinder.class")) != null) {
            values.remove(url);
        }
        return Collections.enumeration(values);
    }

    static {
        DEFAULT_PREFIXES_TO_ADD = new String[]{"tomee-mojarra", "openejb-jpa-integration"};
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        if (!SystemInstance.get().getOptions().get(TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_SKIP, false)) {
            String additionalEnrichments = SystemInstance.get().getOptions().get(TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_CLASSES, "");
            classes.addAll(Arrays.asList(DEFAULT_CLASSES_WHICH_CAN_BE_LOADED_FROM_APP_ONLY));
            if (additionalEnrichments != null && !additionalEnrichments.isEmpty()) {
                for (String name : additionalEnrichments.split(",")) {
                    classes.add(name.trim());
                }
            }
            String additionalPrefixes = SystemInstance.get().getOptions().get(TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_PREFIXES, "");
            prefixes.addAll(Arrays.asList(DEFAULT_PREFIXES_TO_ADD));
            if (additionalPrefixes != null && !additionalPrefixes.isEmpty()) {
                for (String name : additionalPrefixes.split(",")) {
                    prefixes.add(name.trim());
                }
            }
        }
        JAR_TO_ADD_CLASS_HELPERS = classes.toArray(new String[classes.size()]);
        PREFIXES_TO_ADD = prefixes.toArray(new String[prefixes.size()]);
        FORBIDDEN_CLASSES = new String[]{"javax.persistence.Entity", "javax.transaction.Transaction", "javax.jws.WebService", "javax.validation.Validation", "javax.jms.Queue", "javax.enterprise.context.ApplicationScoped", "javax.inject.Inject", "javax.ejb.EJB", "javax.annotation.PostConstruct"};
    }
}

