/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.tomee.catalina.TomEERealm;
import org.apache.tomee.catalina.TomcatSecurityService;

public class OpenEJBSecurityListener
implements AsyncListener {
    private TomcatSecurityService securityService;
    private Object oldState = null;
    private Request request;

    public OpenEJBSecurityListener(TomcatSecurityService service, Request req) {
        this.securityService = service;
        this.request = req;
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this.exit();
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        this.exit();
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        this.enter();
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        this.exit();
    }

    public void enter() {
        if (this.securityService != null && this.request.getWrapper() != null) {
            Realm realm = this.request.getContext().getRealm();
            if (realm instanceof TomEERealm) {
                ((TomEERealm)realm).enter(this.request);
            }
            this.oldState = this.securityService.enterWebApp(this.request.getWrapper().getRealm(), this.request.getPrincipal(), this.request.getWrapper().getRunAs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (this.securityService != null) {
            try {
                this.securityService.exitWebApp(this.oldState);
            }
            finally {
                Realm realm = this.request.getContext().getRealm();
                if (realm instanceof TomEERealm) {
                    ((TomEERealm)realm).exit();
                }
            }
        }
    }
}

