/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextConfig;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.xml.sax.InputSource;

public class OpenEJBContextConfig
extends ContextConfig {
    private static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB, OpenEJBContextConfig.class);
    private static final String MYFACES_TOMEEM_CONTAINER_INITIALIZER = "org.apache.tomee.myfaces.TomEEMyFacesContainerInitializer";
    private static final String TOMEE_MYFACES_CONTEXT_LISTENER = "org.apache.tomee.myfaces.TomEEMyFacesContextListener";
    private static final String CLASSES = "classes";
    private static final String WEB_INF = "WEB-INF";
    private TomcatWebAppBuilder.StandardContextInfo info;

    public OpenEJBContextConfig(TomcatWebAppBuilder.StandardContextInfo standardContextInfo) {
        logger.debug("OpenEJBContextConfig({0})", new Object[]{standardContextInfo.toString()});
        this.info = standardContextInfo;
    }

    protected WebXml createWebXml() {
        StandardContext standardContext;
        String prefix = "";
        if (this.context instanceof StandardContext && (prefix = (standardContext = (StandardContext)this.context).getEncodedPath()).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        return new OpenEJBWebXml(prefix);
    }

    protected void webConfig() {
        super.webConfig();
        try {
            Class<?> myfacesInitializer = Class.forName(MYFACES_TOMEEM_CONTAINER_INITIALIZER, true, this.context.getLoader().getClassLoader());
            ServletContainerInitializer instance = (ServletContainerInitializer)myfacesInitializer.newInstance();
            this.context.addServletContainerInitializer(instance, this.getJsfClasses(this.context));
            this.context.addApplicationListener(TOMEE_MYFACES_CONTEXT_LISTENER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Set<Class<?>> getJsfClasses(Context context) {
        WebAppBuilder builder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        ClassLoader cl = context.getLoader().getClassLoader();
        Map scanned = (Map)builder.getJsfClasses().get(cl);
        if (scanned == null || scanned.isEmpty()) {
            return null;
        }
        HashSet classes = new HashSet();
        for (Set entry : scanned.values()) {
            for (String name : entry) {
                try {
                    classes.add(cl.loadClass(name));
                }
                catch (ClassNotFoundException ignored) {
                    logger.warning("class '" + name + "' was found but can't be loaded as a JSF class");
                }
            }
        }
        return classes;
    }

    protected void parseWebXml(InputSource source, WebXml dest, boolean fragment) {
        super.parseWebXml(source, dest, fragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsFile(File file, WebXml fragment, boolean handlesTypesOnly) {
        logger.debug("processAnnotationsFile {0}", new Object[]{file.getAbsolutePath()});
        try {
            WebAppInfo webAppInfo = this.info.get();
            if (webAppInfo == null) {
                logger.warning("WebAppInfo not found. " + this.info);
                super.processAnnotationsFile(file, fragment, handlesTypesOnly);
                return;
            }
            logger.debug("Optimized Scan of File {0}", new Object[]{file.getAbsolutePath()});
            URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            for (String webAnnotatedClassName : webAppInfo.webAnnotatedClasses) {
                String includedPackage = OpenEJBContextConfig.getSubPackage(file);
                if (includedPackage == null || !webAnnotatedClassName.startsWith(includedPackage)) continue;
                String classFile = webAnnotatedClassName.substring(includedPackage.length()).replace('.', '/') + ".class";
                URL classUrl = loader.getResource(classFile);
                if (classUrl == null) {
                    logger.debug("Not present " + webAnnotatedClassName);
                    continue;
                }
                logger.debug("Found {0}", new Object[]{webAnnotatedClassName});
                InputStream inputStream = classUrl.openStream();
                try {
                    this.processAnnotationsStream(inputStream, fragment, handlesTypesOnly);
                    logger.debug("Succeeded {0}", new Object[]{webAnnotatedClassName});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("OpenEJBContextConfig.processAnnotationsFile: failed.", (Throwable)e);
        }
    }

    private static String getSubPackage(File file) {
        File current = file.getParentFile();
        if (current == null) {
            return "";
        }
        File previous = file;
        while (current.getParentFile() != null) {
            if (CLASSES.equals(previous.getName()) && WEB_INF.equals(current.getName())) {
                String path = file.getAbsolutePath().replaceFirst(previous.getAbsolutePath(), "");
                if (path.startsWith(File.separator)) {
                    path = path.substring(File.separator.length());
                }
                if (path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty()) {
                    return path;
                }
                return path + ".";
            }
            previous = current;
            current = current.getParentFile();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsUrl(URL url, WebXml fragment, boolean handlesTypeOnly) {
        logger.debug("processAnnotationsUrl " + url);
        if (SystemInstance.get().getOptions().get("tomee.tomcat.scan", false)) {
            super.processAnnotationsUrl(url, fragment, handlesTypeOnly);
            return;
        }
        try {
            WebAppInfo webAppInfo = this.info.get();
            if (webAppInfo == null) {
                logger.warning("WebAppInfo not found. " + this.info);
                super.processAnnotationsUrl(url, fragment, handlesTypeOnly);
                return;
            }
            logger.debug("Optimized Scan of URL " + url);
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            for (String webAnnotatedClassName : webAppInfo.webAnnotatedClasses) {
                String classFile = webAnnotatedClassName.replace('.', '/') + ".class";
                URL classUrl = loader.getResource(classFile);
                if (classUrl == null) {
                    logger.debug("Not present " + webAnnotatedClassName);
                    continue;
                }
                logger.debug("Found " + webAnnotatedClassName);
                InputStream inputStream = classUrl.openStream();
                try {
                    this.processAnnotationsStream(inputStream, fragment, handlesTypeOnly);
                    logger.debug("Succeeded " + webAnnotatedClassName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("OpenEJBContextConfig.processAnnotationsUrl: failed.", (Throwable)e);
        }
    }

    public class OpenEJBWebXml
    extends WebXml {
        public static final String OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY = "openejb.web.xml.major";
        private String prefix;

        public OpenEJBWebXml(String prefix) {
            this.prefix = prefix;
        }

        public int getMajorVersion() {
            return SystemInstance.get().getOptions().get(this.prefix + "." + OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, SystemInstance.get().getOptions().get(OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, super.getMajorVersion()));
        }
    }
}

