/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;
import org.apache.tomee.catalina.TomcatContextUtil;

public class LazyStopWebappClassLoader
extends WebappClassLoader {
    public static final String TOMEE_WEBAPP_FIRST = "tomee.webapp-first";
    private boolean restarting = false;
    private volatile Context relatedContext;

    public LazyStopWebappClassLoader() {
        this.setDelegate(LazyStopWebappClassLoader.isDelegate());
    }

    public LazyStopWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void stop() throws LifecycleException {
        if (this.restarting || TomcatContextUtil.isReloading(this.relatedContext)) {
            this.internalStop();
        }
    }

    public void internalStop() throws LifecycleException {
        if (this.isStarted()) {
            super.stop();
        }
    }

    public void restarting() {
        this.restarting = true;
    }

    public void restarted() {
        this.restarting = false;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public void start() throws LifecycleException {
        super.start();
        for (URL url : ((WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)).enrichment((ClassLoader)((Object)this))) {
            this.addURL(url);
        }
    }

    protected boolean validateJarFile(File file) throws IOException {
        if (!super.validateJarFile(file)) {
            return false;
        }
        return TomEEClassLoaderEnricher.validateJarFile(file);
    }

    public void setRelatedContext(Context standardContext) {
        this.relatedContext = standardContext;
    }

    public static boolean isDelegate() {
        return !SystemInstance.get().getOptions().get(TOMEE_WEBAPP_FIRST, true);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration urls = super.getResources(name);
        if (TomEEClassLoaderEnricher.isSlf4jQuery(name)) {
            return TomEEClassLoaderEnricher.filterSlf4jImpl(urls);
        }
        return urls;
    }
}

