/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.tomee.catalina.ContextListener;
import org.apache.tomee.catalina.cluster.TomEEClusterListener;
import org.apache.tomee.loader.TomcatHelper;

public class GlobalListenerSupport
implements PropertyChangeListener,
LifecycleListener {
    public static final String INIT_EVENT = "init";
    public static final String DESTROY_EVENT = "destroy";
    private final StandardServer standardServer;
    private final ContextListener contextListener;

    public GlobalListenerSupport(StandardServer standardServer, ContextListener contextListener) {
        if (standardServer == null) {
            throw new NullPointerException("standardServer is null");
        }
        if (contextListener == null) {
            throw new NullPointerException("contextListener is null");
        }
        this.standardServer = standardServer;
        this.contextListener = contextListener;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Object source = event.getSource();
        if (source instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)source;
            String type = event.getType();
            if (INIT_EVENT.equals(type) || "before_init".equals(type)) {
                this.contextListener.init(standardContext);
            } else if ("before_start".equals(type)) {
                this.contextListener.beforeStart(standardContext);
            } else if ("start".equals(type)) {
                if (TomcatHelper.isTomcat7()) {
                    standardContext.addParameter("openejb.start.late", "true");
                }
                this.contextListener.start(standardContext);
            } else if ("after_start".equals(type)) {
                this.contextListener.afterStart(standardContext);
                if (TomcatHelper.isTomcat7()) {
                    standardContext.removeParameter("openejb.start.late");
                }
            } else if ("before_stop".equals(type)) {
                this.contextListener.beforeStop(standardContext);
            } else if ("stop".equals(type)) {
                this.contextListener.stop(standardContext);
            } else if ("after_stop".equals(type)) {
                this.contextListener.afterStop(standardContext);
            } else if (DESTROY_EVENT.equals(type) || "after_destroy".equals(type)) {
                this.contextListener.destroy(standardContext);
            } else if ("configure_start".equals(type)) {
                this.contextListener.configureStart(standardContext);
            }
        } else if (source instanceof StandardHost) {
            StandardHost standardHost = (StandardHost)source;
            String type = event.getType();
            if ("periodic".equals(type)) {
                this.contextListener.checkHost(standardHost);
            }
        } else if (source instanceof StandardServer) {
            StandardServer standardServer = (StandardServer)source;
            String type = event.getType();
            if ("before_stop".equals(type)) {
                TomcatHelper.setStopping((boolean)true);
                TomEEClusterListener.stop();
            }
            if ("after_stop".equals(type)) {
                this.contextListener.afterStop(standardServer);
            }
        }
    }

    public void start() {
        this.standardServer.addPropertyChangeListener((PropertyChangeListener)this);
        this.standardServer.addLifecycleListener((LifecycleListener)this);
        for (Service service : this.standardServer.findServices()) {
            this.serviceAdded(service);
        }
    }

    public void stop() {
        this.standardServer.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private void serviceAdded(Service service) {
        Container container = service.getContainer();
        if (container instanceof StandardEngine) {
            StandardEngine engine = (StandardEngine)container;
            this.engineAdded(engine);
        }
    }

    private void serviceRemoved(Service service) {
        Container container = service.getContainer();
        if (container instanceof StandardEngine) {
            StandardEngine engine = (StandardEngine)container;
            this.engineRemoved(engine);
        }
    }

    private void engineAdded(StandardEngine engine) {
        this.addContextListener((ContainerBase)engine);
        for (Container child : engine.findChildren()) {
            if (!(child instanceof StandardHost)) continue;
            StandardHost host = (StandardHost)child;
            this.hostAdded(host);
        }
    }

    private void engineRemoved(StandardEngine engine) {
        for (Container child : engine.findChildren()) {
            if (!(child instanceof StandardHost)) continue;
            StandardHost host = (StandardHost)child;
            this.hostRemoved(host);
        }
    }

    private void hostAdded(StandardHost host) {
        this.addContextListener((ContainerBase)host);
        host.addLifecycleListener((LifecycleListener)this);
        for (Container child : host.findChildren()) {
            if (!(child instanceof StandardContext)) continue;
            StandardContext context = (StandardContext)child;
            this.contextAdded(context);
        }
    }

    private void hostRemoved(StandardHost host) {
        for (Container child : host.findChildren()) {
            if (!(child instanceof StandardContext)) continue;
            StandardContext context = (StandardContext)child;
            this.contextRemoved(context);
        }
    }

    private void contextAdded(StandardContext context) {
        this.forceFirstLifecycleListener(context);
    }

    private void forceFirstLifecycleListener(StandardContext context) {
        LifecycleListener[] listeners = context.findLifecycleListeners();
        if (listeners.length > 0 && listeners[0] == this) {
            return;
        }
        for (LifecycleListener listener : listeners) {
            context.removeLifecycleListener(listener);
        }
        context.addLifecycleListener((LifecycleListener)this);
        for (LifecycleListener listener : listeners) {
            if (listener == this) continue;
            context.addLifecycleListener(listener);
        }
    }

    private void contextRemoved(StandardContext context) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("service".equals(event.getPropertyName())) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (oldValue == null && newValue instanceof Service) {
                this.serviceAdded((Service)newValue);
            }
            if (oldValue instanceof Service && newValue == null) {
                this.serviceRemoved((Service)oldValue);
            }
        }
        if ("children".equals(event.getPropertyName())) {
            Object source = event.getSource();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (source instanceof StandardEngine) {
                if (oldValue == null && newValue instanceof StandardHost) {
                    this.hostAdded((StandardHost)newValue);
                }
                if (oldValue instanceof StandardHost && newValue == null) {
                    this.hostRemoved((StandardHost)oldValue);
                }
            }
            if (source instanceof StandardHost) {
                if (oldValue == null && newValue instanceof StandardContext) {
                    this.contextAdded((StandardContext)newValue);
                }
                if (oldValue instanceof StandardContext && newValue == null) {
                    this.contextRemoved((StandardContext)oldValue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContextListener(ContainerBase containerBase) {
        boolean accessible = false;
        Field field = null;
        try {
            field = ContainerBase.class.getDeclaredField("children");
            accessible = field.isAccessible();
            field.setAccessible(true);
            Map children = (Map)field.get(containerBase);
            if (children instanceof MoniterableHashMap) {
                return;
            }
            children = new MoniterableHashMap(children, containerBase, "children", this);
            field.set(containerBase, children);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (field != null && !accessible) {
                field.setAccessible(false);
            }
        }
    }

    public static class MoniterableHashMap
    extends HashMap<Object, Object> {
        private final Object source;
        private final String propertyName;
        private final PropertyChangeListener listener;

        public MoniterableHashMap(Map<Object, Object> m, Object source, String propertyName, PropertyChangeListener listener) {
            super(m);
            this.source = source;
            this.propertyName = propertyName;
            this.listener = listener;
        }

        @Override
        public Object put(Object key, Object value) {
            Object oldValue = super.put(key, value);
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, this.propertyName, null, value);
            this.listener.propertyChange(event);
            return oldValue;
        }

        @Override
        public Object remove(Object key) {
            Object value = super.remove(key);
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, this.propertyName, value, null);
            this.listener.propertyChange(event);
            return value;
        }
    }
}

