/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.policy;

import java.util.List;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.Person;

public class UserDistributionPolicy
implements DistributionPolicy {
    public String distribute(Object pc, List<String> slices, Object context) {
        this.assertValidSlices(slices);
        if (pc instanceof PObject) {
            return this.distribute((PObject)pc);
        }
        if (pc instanceof Person) {
            return this.distribute((Person)pc);
        }
        throw new RuntimeException("No policy for " + pc.getClass());
    }

    void assertValidSlices(List<String> slices) {
        if (slices.contains("One") && slices.contains("Two")) {
            return;
        }
        throw new RuntimeException("This policy assumes two slices named One and Two. But configured slices are " + slices);
    }

    String distribute(PObject pc) {
        return pc.getId() % 2L == 0L ? "One" : "Two";
    }

    String distribute(Person pc) {
        return pc.getName().startsWith("A") ? "One" : "Two";
    }
}

