/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.Address;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.Person;
import org.apache.openjpa.slice.SliceTestCase;

public class TestXA
extends SliceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class, Person.class, Address.class, CLEAR_TABLES);
    }

    public void testEmptyCommit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.getTransaction().commit();
    }

    public void testEmptyRollback() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.getTransaction().rollback();
    }

    public void testPersistIndependentObjects() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int before = this.count(PObject.class);
        int N = 2;
        em.getTransaction().begin();
        for (int i = 0; i < N; ++i) {
            em.persist((Object)new PObject());
        }
        em.getTransaction().commit();
        em.clear();
        int after = this.count(PObject.class);
        TestXA.assertEquals((int)(before + N), (int)after);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "XA";
    }
}

