/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.Car;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.Manufacturer;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.SliceTestCase;

public class TestTransaction
extends SliceTestCase {
    private static final Random rng = new Random(System.currentTimeMillis());
    Manufacturer[] manufacturers;

    @Override
    protected String getPersistenceUnitName() {
        return System.getProperty("unit", "car");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, Car.class, Manufacturer.class, "openjpa.slice.DistributionPolicy", CarDistributorPolicy.class.getName());
        DistributedConfiguration conf = (DistributedConfiguration)this.emf.getConfiguration();
        List slices = conf.getSlices((Slice.Status[])null);
        TestTransaction.assertFalse((boolean)slices.isEmpty());
        this.manufacturers = this.persistManufacturers(slices);
    }

    public void testCommitsAreAtomic() {
        int nCarStart = this.count(Car.class);
        this.persistCars(false);
        int nCarStage1 = this.count(Car.class);
        TestTransaction.assertEquals((int)(nCarStart + this.manufacturers.length), (int)nCarStage1);
        for (int i = 0; i < 10; ++i) {
            this.persistCars(true);
            int nCarStage2 = this.count(Car.class);
            TestTransaction.assertEquals((int)nCarStage1, (int)nCarStage2);
        }
    }

    Manufacturer getManufacturer(EntityManager em, Slice slice) {
        Manufacturer m = (Manufacturer)em.find(Manufacturer.class, (Object)slice.getName());
        if (m == null) {
            m = new Manufacturer();
            m.setName(slice.getName());
            em.persist((Object)m);
        }
        return m;
    }

    Manufacturer[] persistManufacturers(List<Slice> slices) {
        Manufacturer[] manufacturers = new Manufacturer[slices.size()];
        int i = 0;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (Slice slice : slices) {
            manufacturers[i++] = this.getManufacturer((EntityManager)em, slice);
        }
        em.getTransaction().commit();
        return manufacturers;
    }

    void persistCars(boolean introduceError) {
        block4: {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            int i = introduceError ? rng.nextInt(this.manufacturers.length) : -1;
            for (int j = 0; j < this.manufacturers.length; ++j) {
                Manufacturer maker = (Manufacturer)em.find(Manufacturer.class, (Object)this.manufacturers[j].getName());
                Car car = this.newCar(maker);
                em.persist((Object)car);
                if (i != j) continue;
                car.setVin(null);
            }
            try {
                em.getTransaction().commit();
                if (introduceError) {
                    TestTransaction.fail((String)("Expected " + RollbackException.class.getName()));
                }
            }
            catch (RollbackException e) {
                if (introduceError) break block4;
                TestTransaction.fail((String)("Expected " + RollbackException.class.getName()));
            }
        }
    }

    Car newCar(Manufacturer maker) {
        Car car = new Car();
        car.setVin(maker.getName().charAt(0) + this.randomString(6));
        car.setMaker(maker);
        return car;
    }

    String randomString(int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append(rng.nextInt(10));
        }
        return s.toString();
    }

    public static class CarDistributorPolicy
    implements DistributionPolicy {
        public String distribute(Object pc, List<String> slices, Object context) {
            if (pc instanceof Manufacturer) {
                return ((Manufacturer)pc).getName();
            }
            if (pc instanceof Car) {
                if (((Car)pc).getMaker() == null) {
                    throw new RuntimeException("New " + pc + " must have a non-null Manufacturer");
                }
                return this.distribute(((Car)pc).getMaker(), slices, context);
            }
            throw new RuntimeException("No policy for " + pc.getClass().getName());
        }
    }
}

