/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.Set;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.ReplicatedChild;
import org.apache.openjpa.slice.ReplicatedParent;
import org.apache.openjpa.slice.SingleEMFTestCase;
import org.apache.openjpa.slice.SlicePersistence;

public class TestReplication
extends SingleEMFTestCase {
    private static int CHILD_COUNT = 3;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES);
        this.createData();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "replication";
    }

    void createData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ReplicatedParent parent = new ReplicatedParent();
        parent.setName("parent");
        for (int i = 0; i < CHILD_COUNT; ++i) {
            ReplicatedChild child = new ReplicatedChild();
            child.setName("child-" + i);
            parent.addChild(child);
        }
        em.persist((Object)parent);
        em.getTransaction().commit();
        em.clear();
    }

    public void testPersistInReplicatedSlices() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String jpql = "select p from ReplicatedParent p where p.name=:name";
        ReplicatedParent pOne = (ReplicatedParent)em.createQuery(jpql).setParameter("name", (Object)"parent").setHint("openjpa.hint.slice.Target", (Object)"One").getSingleResult();
        TestReplication.assertNotNull((Object)pOne);
        TestReplication.assertEquals((String)"[One, Two]", (String)SlicePersistence.getSlice((Object)pOne));
        ReplicatedParent pTwo = (ReplicatedParent)em.createQuery(jpql).setParameter("name", (Object)"parent").setHint("openjpa.hint.slice.Target", (Object)"Two").getSingleResult();
        TestReplication.assertNotNull((Object)pTwo);
        TestReplication.assertEquals((String)"[One, Two]", (String)SlicePersistence.getSlice((Object)pTwo));
        jpql = "select p from ReplicatedChild p where p.name=:name";
        ReplicatedChild cOne = (ReplicatedChild)em.createQuery(jpql).setParameter("name", (Object)"child-0").setHint("openjpa.hint.slice.Target", (Object)"One").getSingleResult();
        TestReplication.assertNotNull((Object)cOne);
        ReplicatedChild cTwo = (ReplicatedChild)em.createQuery(jpql).setParameter("name", (Object)"child-0").setHint("openjpa.hint.slice.Target", (Object)"Two").getSingleResult();
        TestReplication.assertNotNull((Object)cTwo);
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "select p from ReplicatedParent p where p.name=:name";
        ReplicatedParent parent = (ReplicatedParent)em.createQuery(jpql).setParameter("name", (Object)"parent").setHint("openjpa.hint.slice.Target", (Object)"One").getSingleResult();
        TestReplication.assertNotNull((Object)parent);
        Set<ReplicatedChild> children = parent.getChildren();
        TestReplication.assertNotNull(children);
        TestReplication.assertEquals((int)CHILD_COUNT, (int)children.size());
    }

    public void testAggregateQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "select count(p) from ReplicatedParent p";
        long pCount = (Long)em.createQuery(jpql).getSingleResult();
        TestReplication.assertEquals((long)1L, (long)pCount);
        jpql = "select count(p) from ReplicatedChild p";
        long cCount = (Long)em.createQuery(jpql).getSingleResult();
        TestReplication.assertEquals((long)CHILD_COUNT, (long)cCount);
    }
}

