/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.Address;
import org.apache.openjpa.slice.Car;
import org.apache.openjpa.slice.Country;
import org.apache.openjpa.slice.Manufacturer;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.Person;
import org.apache.openjpa.slice.SlicePersistence;
import org.apache.openjpa.slice.SliceTestCase;

public class TestQueryTargetPolicy
extends SliceTestCase {
    private int POBJECT_COUNT = 2;
    private int VALUE_MIN = 100;
    public static final String QueryPersonByName = "select p from Person p where p.name=:name";
    public static final String QueryPersonByNameSwap = "select q from Person q where q.name=:name";

    @Override
    protected String getPersistenceUnitName() {
        return "ordering";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class, Person.class, Address.class, Country.class, Car.class, Manufacturer.class, "openjpa.slice.QueryTargetPolicy", "org.apache.openjpa.slice.policy.SampleQueryTargetPolicy", CLEAR_TABLES);
        int count = this.count(PObject.class);
        if (count == 0) {
            this.create(this.POBJECT_COUNT);
        }
    }

    void create(int N) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < this.POBJECT_COUNT; ++i) {
            PObject pc = new PObject();
            pc.setValue(this.VALUE_MIN + i);
            em.persist((Object)pc);
            String slice = SlicePersistence.getSlice((Object)pc);
            String expected = pc.getValue() % 2 == 0 ? "Even" : "Odd";
            TestQueryTargetPolicy.assertEquals((String)expected, (String)slice);
        }
        Person p1 = new Person();
        Person p2 = new Person();
        Address a1 = new Address();
        Address a2 = new Address();
        p1.setName("Even");
        p2.setName("Odd");
        a1.setCity("San Francisco");
        a2.setCity("Rome");
        p1.setAddress(a1);
        p2.setAddress(a2);
        em.persist((Object)p1);
        em.persist((Object)p2);
        TestQueryTargetPolicy.assertEquals((String)"Even", (String)SlicePersistence.getSlice((Object)p1));
        TestQueryTargetPolicy.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)p2));
        em.getTransaction().commit();
    }

    public void testTargetSingleSlice() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query q1 = em.createQuery(QueryPersonByName);
        List result1 = q1.setParameter("name", (Object)"Even").getResultList();
        String[] targets1 = TestQueryTargetPolicy.getTargetSlices(q1);
        this.assertArrayEquals(new String[]{"Even"}, targets1);
        TestQueryTargetPolicy.assertFalse((boolean)result1.isEmpty());
        Query q2 = em.createQuery(QueryPersonByNameSwap);
        List result2 = q2.setParameter("name", (Object)"Even").getResultList();
        String[] targets2 = TestQueryTargetPolicy.getTargetSlices(q2);
        this.assertArrayEquals(new String[]{"Odd"}, targets2);
        TestQueryTargetPolicy.assertTrue((boolean)result2.isEmpty());
    }

    <T> void assertArrayEquals(T[] a, T[] b) {
        TestQueryTargetPolicy.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            TestQueryTargetPolicy.assertEquals(a[i], b[i]);
        }
    }

    public static String[] getTargetSlices(Query q) {
        Object targets = ((org.apache.openjpa.kernel.Query)q.unwrap(org.apache.openjpa.kernel.Query.class)).getFetchConfiguration().getHint("openjpa.hint.slice.Target");
        if (targets == null) {
            return null;
        }
        if (targets instanceof String) {
            return new String[]{targets.toString()};
        }
        if (targets instanceof String[]) {
            return (String[])targets;
        }
        return null;
    }
}

