/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.Address;
import org.apache.openjpa.slice.Country;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.Person;
import org.apache.openjpa.slice.SlicePersistence;
import org.apache.openjpa.slice.SliceTestCase;

public class TestQueryMultiThreaded
extends SliceTestCase {
    private int POBJECT_COUNT = 25;
    private int VALUE_MIN = 100;
    private int VALUE_MAX = this.VALUE_MIN + this.POBJECT_COUNT - 1;
    private static int THREADS = 5;
    private static int MAX_TIMEOUT = 300;
    private ExecutorService group;
    private Future[] futures;

    @Override
    protected String getPersistenceUnitName() {
        return "ordering";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class, Person.class, Address.class, Country.class, CLEAR_TABLES, "openjpa.Multithreaded", "true");
        int count = this.count(PObject.class);
        if (count == 0) {
            this.create(this.POBJECT_COUNT);
        }
        this.group = new ThreadPoolExecutor(THREADS, THREADS, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
        this.futures = new Future[THREADS];
    }

    @Override
    public void tearDown() throws Exception {
        this.group.shutdown();
        super.tearDown();
    }

    void create(int N) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < this.POBJECT_COUNT; ++i) {
            PObject pc = new PObject();
            pc.setValue(this.VALUE_MIN + i);
            em.persist((Object)pc);
            String slice = SlicePersistence.getSlice((Object)pc);
            String expected = pc.getValue() % 2 == 0 ? "Even" : "Odd";
            TestQueryMultiThreaded.assertEquals((String)expected, (String)slice);
        }
        Person p1 = new Person();
        Person p2 = new Person();
        Address a1 = new Address();
        Address a2 = new Address();
        p1.setName("Even");
        p2.setName("Odd");
        a1.setCity("San Francisco");
        a2.setCity("Rome");
        p1.setAddress(a1);
        p2.setAddress(a2);
        em.persist((Object)p1);
        em.persist((Object)p2);
        TestQueryMultiThreaded.assertEquals((String)"Even", (String)SlicePersistence.getSlice((Object)p1));
        TestQueryMultiThreaded.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)p2));
        em.getTransaction().commit();
    }

    public void testQueryResultIsOrderedAcrossSlice() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final Query query = em.createQuery("SELECT p.value,p FROM PObject p ORDER BY p.value ASC");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    List result = query.getResultList();
                    Integer old = Integer.MIN_VALUE;
                    for (Object row : result) {
                        Object[] line = (Object[])row;
                        int value = (Integer)line[0];
                        PObject pc = (PObject)line[1];
                        Assert.assertTrue((value >= old ? 1 : 0) != 0);
                        old = value;
                        Assert.assertEquals((int)value, (int)pc.getValue());
                    }
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testAggregateQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final Query countQ = em.createQuery("SELECT COUNT(p) FROM PObject p");
        final Query maxQ = em.createQuery("SELECT MAX(p.value) FROM PObject p");
        final Query minQ = em.createQuery("SELECT MIN(p.value) FROM PObject p");
        final Query sumQ = em.createQuery("SELECT SUM(p.value) FROM PObject p");
        final Query minmaxQ = em.createQuery("SELECT MIN(p.value),MAX(p.value) FROM PObject p");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    Object count = countQ.getSingleResult();
                    Object max = maxQ.getSingleResult();
                    Object min = minQ.getSingleResult();
                    Object sum = sumQ.getSingleResult();
                    Object minmax = minmaxQ.getSingleResult();
                    Object min1 = ((Object[])minmax)[0];
                    Object max1 = ((Object[])minmax)[1];
                    Assert.assertEquals((int)TestQueryMultiThreaded.this.POBJECT_COUNT, (int)((Number)count).intValue());
                    Assert.assertEquals((int)TestQueryMultiThreaded.this.VALUE_MAX, (int)((Number)max).intValue());
                    Assert.assertEquals((int)TestQueryMultiThreaded.this.VALUE_MIN, (int)((Number)min).intValue());
                    Assert.assertEquals((int)((TestQueryMultiThreaded.this.VALUE_MIN + TestQueryMultiThreaded.this.VALUE_MAX) * TestQueryMultiThreaded.this.POBJECT_COUNT), (int)(2 * ((Number)sum).intValue()));
                    Assert.assertEquals((Object)min, (Object)min1);
                    Assert.assertEquals((Object)max, (Object)max1);
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testAggregateQueryWithMissingValueFromSlice() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final Query maxQ = em.createQuery("SELECT MAX(p.value) FROM PObject p WHERE MOD(p.value,2)=0");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    Object max = maxQ.getSingleResult();
                    Assert.assertEquals((int)TestQueryMultiThreaded.this.VALUE_MAX, (int)((Number)max).intValue());
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testSetMaxResult() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int limit = 3;
        em.getTransaction().begin();
        final Query q = em.createQuery("SELECT p.value,p FROM PObject p ORDER BY p.value ASC");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    List result = q.setMaxResults(3).getResultList();
                    boolean i = false;
                    for (Object row : result) {
                        Object[] line = (Object[])row;
                        int value = (Integer)line[0];
                        PObject pc = (PObject)line[1];
                    }
                    Assert.assertEquals((int)3, (int)result.size());
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testHeavyLoad() {
        Thread[] threads = new Thread[800];
        for (int i = 0; i < 800; ++i) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    OpenJPAEntityManagerSPI em = TestQueryMultiThreaded.this.emf.createEntityManager();
                    em.getTransaction().begin();
                    for (int j = 0; j < 10; ++j) {
                        PObject pc = new PObject();
                        pc.setValue((int)System.currentTimeMillis() % 10);
                        em.persist((Object)pc);
                    }
                    em.getTransaction().commit();
                }
            };
            threads[i] = new Thread(r);
            threads[i].start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                TestQueryMultiThreaded.fail();
            }
        }
    }

    public void testHint() {
        final ArrayList<String> targets = new ArrayList<String>();
        targets.add("Even");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final Query query = em.createQuery("SELECT p FROM PObject p");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    query.setHint("openjpa.hint.slice.Target", (Object)"Even");
                    List result = query.getResultList();
                    for (Object pc : result) {
                        String slice = SlicePersistence.getSlice(pc);
                        Assert.assertTrue((boolean)targets.contains(slice));
                    }
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testInMemoryOrderBy() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final Query query = em.createQuery("SELECT p FROM PObject p ORDER BY p.value");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    List result = query.getResultList();
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testQueryParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final Query query = em.createQuery("SELECT p FROM PObject p WHERE p.value > :v");
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    query.setParameter("v", (Object)200);
                    List result = query.getResultList();
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    public void testQueryParameterEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        final TypedQuery addressQ = em.createQuery("select a from Address a where a.city = :city", Address.class);
        final TypedQuery personQ = em.createQuery("SELECT p FROM Person p WHERE p.address = :a", Person.class);
        for (int i = 0; i < THREADS; ++i) {
            this.futures[i] = this.group.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    Address a = (Address)addressQ.setParameter("city", (Object)"Rome").getSingleResult();
                    Assert.assertNotNull((Object)a);
                    Assert.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)a));
                    List result = personQ.setParameter("a", (Object)a).getResultList();
                    Assert.assertEquals((int)1, (int)result.size());
                    Person p = (Person)result.get(0);
                    Assert.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)p));
                    Assert.assertEquals((String)"Rome", (String)p.getAddress().getCity());
                    return null;
                }
            });
        }
        this.waitForTermination();
        em.getTransaction().rollback();
    }

    void waitForTermination() {
        try {
            for (Future f : this.futures) {
                try {
                    f.get(MAX_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (TimeoutException te) {
                    TestQueryMultiThreaded.fail((String)("Failed " + te + "\r\n" + this.getStackDump(te)));
                }
                catch (ExecutionException e) {
                    TestQueryMultiThreaded.fail((String)("Failed \r\n" + this.getStackDump(e.getCause())));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String getStackDump(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

