/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.Address;
import org.apache.openjpa.slice.Car;
import org.apache.openjpa.slice.Country;
import org.apache.openjpa.slice.Manufacturer;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.Person;
import org.apache.openjpa.slice.SlicePersistence;
import org.apache.openjpa.slice.SliceTestCase;

public class TestQuery
extends SliceTestCase {
    private int POBJECT_COUNT = 25;
    private int VALUE_MIN = 100;
    private int VALUE_MAX = this.VALUE_MIN + this.POBJECT_COUNT - 1;

    @Override
    protected String getPersistenceUnitName() {
        return "ordering";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class, Person.class, Address.class, Country.class, Car.class, Manufacturer.class, CLEAR_TABLES);
        int count = this.count(PObject.class);
        if (count == 0) {
            this.create(this.POBJECT_COUNT);
        }
    }

    void create(int N) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < this.POBJECT_COUNT; ++i) {
            PObject pc = new PObject();
            pc.setValue(this.VALUE_MIN + i);
            em.persist((Object)pc);
            String slice = SlicePersistence.getSlice((Object)pc);
            String expected = pc.getValue() % 2 == 0 ? "Even" : "Odd";
            TestQuery.assertEquals((String)expected, (String)slice);
        }
        Person p1 = new Person();
        Person p2 = new Person();
        Address a1 = new Address();
        Address a2 = new Address();
        p1.setName("Even");
        p2.setName("Odd");
        a1.setCity("San Francisco");
        a2.setCity("Rome");
        p1.setAddress(a1);
        p2.setAddress(a2);
        em.persist((Object)p1);
        em.persist((Object)p2);
        TestQuery.assertEquals((String)"Even", (String)SlicePersistence.getSlice((Object)p1));
        TestQuery.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)p2));
        em.getTransaction().commit();
    }

    public void testOrderedQueryResultWhenOrderableItemSelected() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p.value,p FROM PObject p ORDER BY p.value ASC");
        List result = query.getResultList();
        this.assertValidResult(result);
        Integer old = Integer.MIN_VALUE;
        for (Object row : result) {
            Object[] line = (Object[])row;
            int value = (Integer)line[0];
            PObject pc = (PObject)line[1];
            TestQuery.assertTrue((value >= old ? 1 : 0) != 0);
            old = value;
            TestQuery.assertEquals((int)value, (int)pc.getValue());
        }
        em.getTransaction().rollback();
    }

    public void testOrderedQueryResultWhenOrderableItemNotSelected() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p FROM PObject p ORDER BY p.value ASC");
        List result = query.getResultList();
        this.assertValidResult(result);
        Integer old = Integer.MIN_VALUE;
        for (PObject pc : result) {
            int value = pc.getValue();
            TestQuery.assertTrue((value >= old ? 1 : 0) != 0);
            old = value;
        }
        em.getTransaction().rollback();
    }

    public void testOrderedQueryResultWhenNavigatedOrderableItemNotSelected() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p FROM Person p JOIN p.address a ORDER BY a.zip ASC, a.city DESC");
        List result = query.getResultList();
        this.assertValidResult(result);
        Integer oldZip = Integer.MIN_VALUE;
        String oldCity = null;
        for (Person pc : result) {
            int zip = pc.getAddress().getZip();
            String city = pc.getAddress().getCity();
            TestQuery.assertTrue((zip >= oldZip ? 1 : 0) != 0);
            TestQuery.assertTrue((oldCity == null || oldCity.compareTo(city) >= 0 ? 1 : 0) != 0);
            oldZip = zip;
            oldCity = city;
        }
        em.getTransaction().rollback();
    }

    public void testAggregateQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Object count = em.createQuery("SELECT COUNT(p) FROM PObject p").getSingleResult();
        Object max = em.createQuery("SELECT MAX(p.value) FROM PObject p").getSingleResult();
        Object min = em.createQuery("SELECT MIN(p.value) FROM PObject p").getSingleResult();
        Object sum = em.createQuery("SELECT SUM(p.value) FROM PObject p").getSingleResult();
        Object minmax = em.createQuery("SELECT MIN(p.value),MAX(p.value) FROM PObject p").getSingleResult();
        Object min1 = ((Object[])minmax)[0];
        Object max1 = ((Object[])minmax)[1];
        em.getTransaction().rollback();
        TestQuery.assertEquals((int)this.POBJECT_COUNT, (int)((Number)count).intValue());
        TestQuery.assertEquals((int)this.VALUE_MAX, (int)((Number)max).intValue());
        TestQuery.assertEquals((int)this.VALUE_MIN, (int)((Number)min).intValue());
        TestQuery.assertEquals((int)((this.VALUE_MIN + this.VALUE_MAX) * this.POBJECT_COUNT), (int)(2 * ((Number)sum).intValue()));
        TestQuery.assertEquals((Object)min, (Object)min1);
        TestQuery.assertEquals((Object)max, (Object)max1);
    }

    public void testAggregateQueryWithMissingValueFromSlice() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Object max = em.createQuery("SELECT MAX(p.value) FROM PObject p WHERE MOD(p.value,2)=0").getSingleResult();
        em.getTransaction().rollback();
        TestQuery.assertEquals((int)this.VALUE_MAX, (int)((Number)max).intValue());
    }

    public void testSetMaxResult() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int limit = 3;
        em.getTransaction().begin();
        List result = em.createQuery("SELECT p FROM PObject p ORDER BY p.value ASC").setMaxResults(limit).getResultList();
        this.assertValidResult(result);
        Integer old = Integer.MIN_VALUE;
        for (PObject pc : result) {
            int value = pc.getValue();
            TestQuery.assertTrue((value >= old ? 1 : 0) != 0);
            old = value;
        }
        TestQuery.assertEquals((int)limit, (int)result.size());
        em.getTransaction().rollback();
    }

    public void testHint() {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("Even");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p FROM PObject p");
        query.setHint("openjpa.hint.slice.Target", (Object)"Even");
        List result = query.getResultList();
        for (Object pc : result) {
            String slice = SlicePersistence.getSlice(pc);
            TestQuery.assertTrue((String)("Expected original slice " + slice + " in " + targets), (boolean)targets.contains(slice));
        }
        em.getTransaction().rollback();
    }

    public void testQueryTargetPolicy() {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("Even");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p FROM PObject p");
        query.setHint("openjpa.hint.slice.Target", (Object)"Even");
        List result = query.getResultList();
        for (Object pc : result) {
            String slice = SlicePersistence.getSlice(pc);
            TestQuery.assertTrue((boolean)targets.contains(slice));
        }
        em.getTransaction().rollback();
    }

    public void testInMemoryOrderBy() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p FROM PObject p ORDER BY p.value");
        List result = query.getResultList();
        em.getTransaction().rollback();
    }

    public void testQueryParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("SELECT p FROM PObject p WHERE p.value > :v").setParameter("v", (Object)200);
        List result = query.getResultList();
        em.getTransaction().rollback();
    }

    public void testQueryParameterEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Address a = (Address)em.createQuery("select a from Address a where a.city = :city").setParameter("city", (Object)"Rome").getSingleResult();
        TestQuery.assertNotNull((Object)a);
        TestQuery.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)a));
        Query query = em.createQuery("SELECT p FROM Person p WHERE p.address = :a").setParameter("a", (Object)a);
        List result = query.getResultList();
        TestQuery.assertEquals((int)1, (int)result.size());
        Person p = (Person)result.get(0);
        TestQuery.assertEquals((String)"Odd", (String)SlicePersistence.getSlice((Object)p));
        TestQuery.assertEquals((String)"Rome", (String)p.getAddress().getCity());
        em.getTransaction().rollback();
    }

    public void testCollocationConstraintViolation() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Manufacturer bmw = new Manufacturer();
        bmw.setName("BMW");
        em.persist((Object)bmw);
        em.getTransaction().commit();
        em.getTransaction().begin();
        Car z4 = new Car();
        z4.setVin("1234V56789");
        z4.setMaker(bmw);
        z4.setModel("Z4");
        em.persist((Object)z4);
        em.getTransaction().commit();
        em.clear();
        List cars = em.createQuery("select c from Car c").getResultList();
        TestQuery.assertFalse((boolean)cars.isEmpty());
        for (Object c : cars) {
            TestQuery.assertEquals((String)"Even", (String)SlicePersistence.getSlice(c));
        }
        List makers = em.createQuery("select m from Manufacturer m").getResultList();
        TestQuery.assertFalse((boolean)makers.isEmpty());
        for (Object m : makers) {
            TestQuery.assertEquals((String)"Odd", (String)SlicePersistence.getSlice(m));
        }
        em.clear();
        cars = em.createQuery("select c from Car c").getResultList();
        TestQuery.assertFalse((boolean)cars.isEmpty());
        for (Object c : cars) {
            TestQuery.assertNotNull((Object)((Car)c).getMaker());
        }
    }

    void assertValidResult(List result) {
        TestQuery.assertNotNull((Object)result);
        TestQuery.assertFalse((boolean)result.isEmpty());
        TestQuery.assertTrue((result.size() > 1 ? 1 : 0) != 0);
    }
}

