/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.HashMap;
import java.util.List;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.slice.DistributedBrokerFactory;
import org.apache.openjpa.slice.DistributedBrokerImpl;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.SliceTestCase;
import org.apache.openjpa.slice.jdbc.DistributedJDBCBrokerFactory;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;

public class TestConfiguration
extends SliceTestCase {
    @Override
    protected String getPersistenceUnitName() {
        return "per-slice";
    }

    public void testConfig() {
        TestConfiguration.assertTrue((boolean)(this.emf.getConfiguration() instanceof DistributedConfiguration));
        DistributedJDBCConfiguration conf = (DistributedJDBCConfiguration)this.emf.getConfiguration();
        List slices = conf.getAvailableSliceNames();
        TestConfiguration.assertTrue((slices.size() > 1 ? 1 : 0) != 0);
        TestConfiguration.assertTrue((boolean)slices.contains("One"));
        TestConfiguration.assertTrue((boolean)slices.contains("Two"));
        TestConfiguration.assertTrue((boolean)slices.contains("Three"));
        BrokerFactory bf = ((EntityManagerFactoryImpl)this.emf).getBrokerFactory();
        Broker broker = bf.newBroker();
        TestConfiguration.assertEquals(DistributedJDBCBrokerFactory.class, bf.getClass());
        TestConfiguration.assertEquals(DistributedBrokerImpl.class, broker.getClass());
        TestConfiguration.assertNotNull((Object)conf.getDistributionPolicyInstance());
        this.emf.createEntityManager();
        slices = conf.getActiveSliceNames();
        TestConfiguration.assertTrue((slices.size() > 1 ? 1 : 0) != 0);
        TestConfiguration.assertTrue((boolean)slices.contains("One"));
        TestConfiguration.assertTrue((boolean)slices.contains("Two"));
        TestConfiguration.assertFalse((boolean)slices.contains("Three"));
    }

    public void testDynamicConfiguration() {
        DistributedJDBCConfiguration conf = (DistributedJDBCConfiguration)this.emf.getConfiguration();
        List slices = conf.getAvailableSliceNames();
        TestConfiguration.assertTrue((boolean)slices.contains("One"));
        TestConfiguration.assertTrue((boolean)slices.contains("Two"));
        TestConfiguration.assertTrue((boolean)slices.contains("Three"));
        DistributedBrokerFactory bf = (DistributedBrokerFactory)((EntityManagerFactoryImpl)this.emf).getBrokerFactory();
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("openjpa.slice.newslice.ConnectionURL", "jdbc:derby:target/database/newslice;create=true");
        newProps.put("openjpa.slice.newslice.ConnectionDriverName", "org.apache.derby.jdbc.EmbeddedDriver");
        bf.addSlice("newslice", newProps);
        TestConfiguration.assertTrue((boolean)conf.getActiveSliceNames().contains("newslice"));
    }
}

