/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.SliceTestCase;
import org.apache.openjpa.slice.policy.UniformDistributionPolicy;

public class TestBulkDelete
extends SliceTestCase {
    private static int SLICES = 3;
    private static List<String> SLICE_NAMES;

    @Override
    protected String getPersistenceUnitName() {
        return "slice";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class, CLEAR_TABLES, "openjpa.slice.DistributionPolicy", UniformDistributionPolicy.class.getName());
    }

    @Override
    public void tearDown() throws Exception {
        System.err.println("Delete all instances from all slices");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String delete = "delete from PObject p";
        int m = em.createQuery(delete).executeUpdate();
        em.getTransaction().commit();
        super.tearDown();
    }

    public void testBulkDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        DistributedConfiguration conf = (DistributedConfiguration)this.emf.getConfiguration();
        SLICE_NAMES = conf.getActiveSliceNames();
        SLICES = SLICE_NAMES.size();
        TestBulkDelete.assertTrue((SLICES > 1 ? 1 : 0) != 0);
        int M = 4;
        int N = SLICES * M;
        for (int i = 0; i < N; ++i) {
            PObject pc = new PObject();
            em.persist((Object)pc);
        }
        em.getTransaction().commit();
        String jpql = "select count(p) from PObject p";
        long total = (Long)em.createQuery(jpql, Long.class).getSingleResult();
        TestBulkDelete.assertEquals((long)N, (long)total);
        for (int i = 0; i < SLICES; ++i) {
            System.err.println("Query only on slice [" + SLICE_NAMES.get(i) + "]");
            long count = (Long)em.createQuery(jpql, Long.class).setHint("openjpa.hint.slice.Target", (Object)SLICE_NAMES.get(i)).getSingleResult();
            TestBulkDelete.assertEquals((long)M, (long)count);
        }
        em.getTransaction().begin();
        System.err.println("Delete only from slice [" + SLICE_NAMES.get(0) + "]");
        String delete = "delete from PObject p";
        int m = em.createQuery(delete).setHint("openjpa.hint.slice.Target", (Object)SLICE_NAMES.get(0)).executeUpdate();
        TestBulkDelete.assertEquals((int)M, (int)m);
        em.getTransaction().commit();
    }
}

