/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.slice.Address;
import org.apache.openjpa.slice.Country;
import org.apache.openjpa.slice.DistributedBroker;
import org.apache.openjpa.slice.DistributedBrokerFactory;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.PObject;
import org.apache.openjpa.slice.Person;
import org.apache.openjpa.slice.SlicePersistence;
import org.apache.openjpa.slice.SliceTestCase;

public class TestBasic
extends SliceTestCase {
    @Override
    protected String getPersistenceUnitName() {
        return System.getProperty("unit", "slice");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class, Person.class, Address.class, Country.class, CLEAR_TABLES);
    }

    List<PObject> createIndependentObjects(int N) {
        ArrayList<PObject> pcs = new ArrayList<PObject>();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < N; ++i) {
            PObject pc = new PObject();
            pcs.add(pc);
            em.persist((Object)pc);
            pc.setValue(10 + i);
        }
        em.getTransaction().commit();
        em.clear();
        return pcs;
    }

    PObject createIndependentObject() {
        return this.createIndependentObjects(1).get(0);
    }

    public void testDelete() {
        int N = 10;
        this.createIndependentObjects(N);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        int before = this.count(PObject.class);
        List all = em.createQuery("SELECT p FROM PObject p").getResultList();
        TestBasic.assertFalse((boolean)all.isEmpty());
        em.remove(all.get(0));
        em.getTransaction().commit();
        int after = this.count(PObject.class);
        TestBasic.assertEquals((int)(before - 1), (int)after);
    }

    public void testBulkDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        int c = this.count(PObject.class);
        int d = em.createQuery("DELETE FROM PObject p").executeUpdate();
        TestBasic.assertEquals((int)c, (int)d);
        em.getTransaction().commit();
        c = this.count(PObject.class);
        TestBasic.assertEquals((int)0, (int)c);
    }

    public void testFind() {
        PObject pc = this.createIndependentObject();
        int value = pc.getValue();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc2 = (PObject)em.find(PObject.class, (Object)pc.getId());
        TestBasic.assertNotNull((Object)pc2);
        TestBasic.assertNotEquals(pc, pc2);
        TestBasic.assertEquals((long)pc.getId(), (long)pc2.getId());
        TestBasic.assertEquals((int)value, (int)pc2.getValue());
    }

    public void testReference() {
        PObject pc = this.createIndependentObject();
        int value = pc.getValue();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject ref = (PObject)em.getReference(PObject.class, (Object)pc.getId());
        TestBasic.assertNotNull((Object)ref);
        TestBasic.assertNotEquals(pc, ref);
        TestBasic.assertEquals((long)ref.getId(), (long)pc.getId());
        pc.setValue(value + 1);
        em.merge((Object)pc);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        PObject pc3 = (PObject)em.find(PObject.class, (Object)pc.getId());
        TestBasic.assertEquals((int)(value + 1), (int)pc3.getValue());
        em.getTransaction().commit();
    }

    public void testPersistIndependentObjects() {
        int before = this.count(PObject.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int N = 2;
        em.getTransaction().begin();
        for (int i = 0; i < N; ++i) {
            em.persist((Object)new PObject());
        }
        em.getTransaction().commit();
        em.clear();
        int after = this.count(PObject.class);
        TestBasic.assertEquals((int)(before + N), (int)after);
    }

    public void testPersistConnectedObjectGraph() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Person p1 = new Person("A");
        Person p2 = new Person("B");
        Person p3 = new Person("C");
        Address a1 = new Address("Rome", 12345);
        Address a2 = new Address("San Francisco", 23456);
        Address a3 = new Address("New York", 34567);
        Country c1 = (Country)em.find(Country.class, (Object)"Italy");
        if (c1 == null) {
            c1 = new Country();
            c1.setName("Italy");
            em.persist((Object)c1);
        }
        a1.setCountry(c1);
        p1.setAddress(a1);
        p2.setAddress(a2);
        p3.setAddress(a3);
        em.persist((Object)p1);
        em.persist((Object)p2);
        em.persist((Object)p3);
        em.getTransaction().commit();
        em.clear();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        List persons = em.createQuery("SELECT p FROM Person p WHERE p.name=?1").setParameter(1, (Object)"A").getResultList();
        List addresses = em.createQuery("SELECT a FROM Address a").getResultList();
        for (Object pc : addresses) {
            TestBasic.assertNotNull((Object)((Address)pc).getCity());
            TestBasic.assertNotNull((Object)((Address)pc).getOwner().getName());
        }
        for (Object pc : persons) {
            TestBasic.assertNotNull((Object)((Person)pc).getName());
            TestBasic.assertNotNull((Object)((Person)pc).getAddress().getCity());
        }
        em.getTransaction().rollback();
    }

    public void testMerge() {
        PObject pc = this.createIndependentObjects(1).get(0);
        int value = pc.getValue();
        pc.setValue(value + 1);
        TestBasic.assertNotNull((Object)pc);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc2 = (PObject)em.merge((Object)pc);
        em.getTransaction().commit();
        em.clear();
        TestBasic.assertNotNull((Object)pc2);
        TestBasic.assertNotEquals(pc, pc2);
        TestBasic.assertEquals((long)pc.getId(), (long)pc2.getId());
        TestBasic.assertEquals((int)(value + 1), (int)pc2.getValue());
    }

    public void testPersistReplicatedObjects() {
        String[] names;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (String name : names = new String[]{"USA", "India", "China"}) {
            Country country = new Country();
            country.setName(name);
            em.persist((Object)country);
        }
        em.getTransaction().commit();
        TestBasic.assertEquals((int)names.length, (int)this.count(Country.class));
        em.getTransaction().begin();
        Country india = (Country)em.find(Country.class, (Object)"India");
        TestBasic.assertNotNull((Object)india);
        TestBasic.assertEquals((String)"India", (String)india.getName());
        TestBasic.assertTrue((boolean)SlicePersistence.isReplicated((Object)india));
        TestBasic.assertTrue((SlicePersistence.getSlice((Object)india).indexOf("One") != -1 ? 1 : 0) != 0);
        TestBasic.assertTrue((SlicePersistence.getSlice((Object)india).indexOf("Two") != -1 ? 1 : 0) != 0);
    }

    public void testUpdateReplicatedObjects() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String[] names = new String[]{"USA", "India", "China"};
        long[] population = new long[]{300L, 1200L, 1400L};
        for (int i = 0; i < names.length; ++i) {
            Country country = new Country();
            country.setName(names[i]);
            country.setPopulation(population[i]);
            em.persist((Object)country);
        }
        em.getTransaction().commit();
        em.clear();
        TestBasic.assertEquals((int)names.length, (int)this.count(Country.class));
        Country india = (Country)em.find(Country.class, (Object)"India");
        TestBasic.assertNotNull((Object)india);
        TestBasic.assertEquals((String)"India", (String)india.getName());
        india.setPopulation(1201L);
        em.getTransaction().begin();
        em.merge((Object)india);
        em.getTransaction().commit();
        String[] hints = new String[]{"One", "Two"};
        String jpql = "select c from Country c where c.name=:name";
        em.getTransaction().begin();
        for (String hint : hints) {
            em.clear();
            Query query = em.createQuery(jpql).setParameter("name", (Object)"India");
            query.setHint("openjpa.hint.slice.Target", (Object)hint);
            india = (Country)query.getSingleResult();
            TestBasic.assertEquals((long)india.getPopulation(), (long)1201L);
            TestBasic.assertTrue((boolean)SlicePersistence.isReplicated((Object)india));
            TestBasic.assertTrue((SlicePersistence.getSlice((Object)india).indexOf("One") != -1 ? 1 : 0) != 0);
            TestBasic.assertTrue((SlicePersistence.getSlice((Object)india).indexOf("Two") != -1 ? 1 : 0) != 0);
        }
        em.getTransaction().rollback();
    }

    public void testQuerySingleObject() {
        PObject pc = this.createIndependentObject();
        long pid = pc.getId();
        int value = pc.getValue();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String jpql = "select p from PObject p where p.id=:id";
        PObject pc2 = (PObject)em.createQuery(jpql).setParameter("id", (Object)pid).getSingleResult();
        TestBasic.assertNotNull((Object)pc2);
        TestBasic.assertNotEquals(pc, pc2);
        TestBasic.assertEquals((long)pc.getId(), (long)pc2.getId());
        TestBasic.assertEquals((int)value, (int)pc2.getValue());
    }

    public void testGetConnection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Object con = em.getConnection();
        TestBasic.assertTrue((boolean)(con instanceof Connection));
    }

    public void testDynamicSlice() {
        DistributedConfiguration conf = (DistributedConfiguration)this.emf.getConfiguration();
        conf.setDistributionPolicyInstance(new DistributionPolicy(){

            public String distribute(Object pc, List<String> slices, Object context) {
                if (PObject.class.isInstance(pc)) {
                    PObject o = (PObject)pc;
                    if (o.getValue() > 50) {
                        DistributedBrokerFactory bf = (DistributedBrokerFactory)((DistributedBroker)context).getBrokerFactory();
                        HashMap<String, String> newProps = new HashMap<String, String>();
                        newProps.put("openjpa.slice.newslice.ConnectionURL", "jdbc:derby:target/database/newslice;create=true");
                        newProps.put("openjpa.slice.newslice.ConnectionDriverName", "org.apache.derby.jdbc.EmbeddedDriver");
                        bf.addSlice("newslice", newProps);
                        return "newslice";
                    }
                    return slices.get(o.getValue() % slices.size());
                }
                return null;
            }
        });
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc1 = new PObject();
        pc1.setValue(25);
        PObject pc2 = new PObject();
        pc2.setValue(55);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        Object newId = em.getObjectId((Object)pc2);
        em.clear();
        PObject newP = (PObject)em.find(PObject.class, newId);
        TestBasic.assertNotNull((Object)newP);
        TestBasic.assertEquals((String)"newslice", (String)SlicePersistence.getSlice((Object)newP));
    }
}

