/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;

public abstract class PersistenceTestCase
extends TestCase {
    protected static final Object CLEAR_TABLES = new Object();
    protected TestResult testResult;

    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        return this.createNamedEMF(this.getPersistenceUnitName(), props);
    }

    protected String getPersistenceUnitName() {
        return "test";
    }

    protected OpenJPAEntityManagerFactorySPI createNamedEMF(String pu, Object ... props) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(System.getProperties());
        ArrayList<Class> types = new ArrayList<Class>();
        boolean prop = false;
        for (int i = 0; i < props.length; ++i) {
            if (prop) {
                map.put(props[i - 1], props[i]);
                prop = false;
                continue;
            }
            if (props[i] == CLEAR_TABLES) {
                map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='add,deleteTableContents')");
                continue;
            }
            if (props[i] instanceof Class) {
                types.add((Class)props[i]);
                continue;
            }
            if (props[i] == null) continue;
            prop = true;
        }
        if (!types.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            for (Class c : types) {
                if (buf.length() > 0) {
                    buf.append(";");
                }
                buf.append(c.getName());
            }
            map.put("openjpa.MetaDataFactory", "jpa(Types=" + buf.toString() + ")");
        }
        if (!map.containsKey("openjpa.ConnectionFactoryProperties")) {
            map.put("openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        }
        return (OpenJPAEntityManagerFactorySPI)Persistence.createEntityManagerFactory((String)pu, map);
    }

    public void run(TestResult testResult) {
        this.testResult = testResult;
        super.run(testResult);
    }

    public void tearDown() throws Exception {
        block2: {
            try {
                super.tearDown();
            }
            catch (Exception e) {
                if (!this.testResult.wasSuccessful()) break block2;
                throw e;
            }
        }
    }

    protected boolean closeEMF(EntityManagerFactory emf) {
        if (emf == null || !emf.isOpen()) {
            return false;
        }
        this.closeAllOpenEMs(emf);
        emf.close();
        return !emf.isOpen();
    }

    protected void closeAllOpenEMs(EntityManagerFactory emf) {
        if (emf == null || !emf.isOpen()) {
            return;
        }
        for (Broker b : ((AbstractBrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf)).getOpenBrokers()) {
            if (b == null || b.isClosed()) continue;
            OpenJPAEntityManager em = JPAFacadeHelper.toEntityManager((Broker)b);
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    protected void clear(EntityManagerFactory emf, Class ... types) {
        if (emf == null || types.length == 0) {
            return;
        }
        ArrayList<ClassMetaData> metas = new ArrayList<ClassMetaData>(types.length);
        for (Class c : types) {
            ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)emf, (Class)c);
            if (meta == null) continue;
            metas.add(meta);
        }
        this.clear(emf, false, metas.toArray(new ClassMetaData[metas.size()]));
    }

    protected void clear(EntityManagerFactory emf) {
        if (emf == null) {
            return;
        }
        this.clear(emf, true, ((OpenJPAEntityManagerFactorySPI)emf).getConfiguration().getMetaDataRepositoryInstance().getMetaDatas());
    }

    private void clear(EntityManagerFactory emf, boolean closeEMs, ClassMetaData ... types) {
        if (emf == null || types.length == 0) {
            return;
        }
        if (closeEMs) {
            this.closeAllOpenEMs(emf);
        }
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        for (ClassMetaData meta : types) {
            if (meta.isMapped() && !meta.isEmbeddedOnly() && !Modifier.isAbstract(meta.getDescribedType().getModifiers())) continue;
        }
        em.getTransaction().commit();
        em.close();
    }

    protected String entityName(EntityManagerFactory emf, Class c) {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)emf, (Class)c);
        return meta == null ? null : meta.getTypeAlias();
    }

    public static void assertNotEquals(Object o1, Object o2) {
        if (o1 == o2) {
            PersistenceTestCase.fail((String)"expected args to be different; were the same instance.");
        } else {
            if (o1 == null || o2 == null) {
                return;
            }
            if (o1.equals(o2)) {
                PersistenceTestCase.fail((String)"expected args to be different; compared equal.");
            }
        }
    }
}

