/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.TransactionRequiredException;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNamedQueryLockMode
extends SQLListenerTestCase {
    String lockClause = "FOR UPDATE";

    @Override
    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, LockEmployee.class, "openjpa.LockManager", "pessimistic", "openjpa.Optimistic", "false");
    }

    public void testForUpdateClausePresentInNamedQueryWithLockMode() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.lockClause = this.getForUpdateClause();
        this.assertClausePresentInSQL(this.lockClause, em.createNamedQuery("findEmployeeByIdWithLock").setParameter("id", (Object)0));
        em.getTransaction().rollback();
        em.getTransaction().begin();
        this.assertClausePresentInSQL(this.lockClause, em.createNamedQuery("findEmployeeByIdWithLock").setParameter("id", (Object)0));
        em.getTransaction().rollback();
        em.getTransaction().begin();
        this.assertClausePresentInSQL(this.lockClause, em.createNamedQuery("findEmployeeByIdWithLock").setParameter("id", (Object)0));
        em.getTransaction().rollback();
    }

    @AllowFailure
    public void testNamedQueryWithLockModeMustExecuteInTransaction() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.createNamedQuery("findEmployeeByIdWithLock").setParameter("id", (Object)0).getResultList();
            TestNamedQueryLockMode.fail((String)("Expected " + TransactionRequiredException.class.getName()));
        }
        catch (TransactionRequiredException transactionRequiredException) {
            // empty catch block
        }
    }

    public void testForUpdateClausePresentInQueryWithDefault() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.lockClause = this.getForUpdateClause();
        if (!DB2Dictionary.class.isAssignableFrom(this.getDBDictionary().getClass())) {
            this.assertClausePresentInSQL(this.lockClause, em.createNamedQuery("findEmployeeById").setParameter("id", (Object)0));
            this.assertClausePresentInSQL(this.lockClause, em.createNamedQuery("findEmployeeById").setParameter("id", (Object)0));
        }
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em;
        OpenJPAQuery q = oem.createNamedQuery("findEmployeeById").setParameter("id", (Object)0);
        FetchPlan fp = q.getFetchPlan();
        fp.setReadLockMode(LockModeType.NONE);
        em.getTransaction().commit();
    }

    public void testForUpdateClauseAbsentInQueryWithFetchPlanNoneLockMode() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.lockClause = this.getForUpdateClause();
        OpenJPAQuery q = em.createNamedQuery("findEmployeeById").setParameter("id", (Object)0);
        FetchPlan fp = q.getFetchPlan();
        fp.setReadLockMode(LockModeType.NONE);
        this.assertClauseAbsentInSQL(this.lockClause, (Query)q);
        q = em.createNamedQuery("findEmployeeByIdWithNoLock").setParameter("id", (Object)0);
        fp = q.getFetchPlan();
        fp.setReadLockMode(LockModeType.NONE);
        this.assertClauseAbsentInSQL(this.lockClause, (Query)q);
        em.getTransaction().commit();
    }

    @AllowFailure
    public void testForUpdateClauseAbsentInQueryWithExplictNoLock() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.lockClause = this.getForUpdateClause();
        this.assertClauseAbsentInSQL(this.lockClause, em.createNamedQuery("findEmployeeByIdWithNoLock").setParameter("id", (Object)0));
        this.assertClauseAbsentInSQL(this.lockClause, em.createNamedQuery("findEmployeeByIdWithNoLock").setParameter("id", (Object)0));
        em.getTransaction().commit();
    }

    String getLastSQL() {
        String last = (String)this.sql.get(this.getSQLCount() - 1);
        TestNamedQueryLockMode.assertNotNull((String)"No last sql found", (Object)last);
        return last;
    }

    void assertClausePresentInSQL(String clause, Query q) {
        q.getResultList();
        String last = this.getLastSQL();
        TestNamedQueryLockMode.assertTrue((String)(clause + " is not present in " + last), (last.toUpperCase().indexOf(clause) != -1 ? 1 : 0) != 0);
    }

    void assertClauseAbsentInSQL(String clause, Query q) {
        q.getResultList();
        String last = this.getLastSQL();
        TestNamedQueryLockMode.assertTrue((String)(clause + " is not absent in " + last), (last.toUpperCase().indexOf(clause) == -1 ? 1 : 0) != 0);
    }
}

