/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.Arrays;
import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestMixedLockManagerRefreshPermutation
extends SequencedActionsTest {
    @Override
    public void setUp() {
        this.setUp(LockEmployee.class, "openjpa.LockManager", "mixed");
        this.commonSetUp();
    }

    public void testRefreshReadRead() {
        this.commonRefreshTest("testRefresh(Read,Commit/Read,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(Read,Commit/Read,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshReadWrite() {
        this.commonRefreshTest("testRefresh(Read,Commit/Write,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(Read,Commit/Write,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshReadPessimisticRead() {
        this.commonRefreshTest("testRefresh(Read,Commit/PessimisticRead,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(Read,Commit/PessimisticRead,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshReadPessimisticWrite() {
        this.commonRefreshTest("testRefresh(Read,Commit/PessimisticWrite,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(Read,Commit/PessimisticWrite,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshReadPessimisticForceInc() {
        this.commonRefreshTest("testRefresh(Read,Commit/PessimisticForceInc,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(Read,Commit/PessimisticForceInc,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshWriteRead() {
        this.commonRefreshTest("testRefresh(Write,Commit/Read,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(Write,Commit/Read,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshWriteWrite() {
        this.commonRefreshTest("testRefresh(Write,Commit/Write,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(Write,Commit/Write,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshWritePessimisticRead() {
        this.commonRefreshTest("testRefresh(Write,Commit/PessimisticRead,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(Write,Commit/PessimisticRead,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshWritePessimisticWrite() {
        this.commonRefreshTest("testRefresh(Write,Commit/PessimisticWrite,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(Write,Commit/PessimisticWrite,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshWritePessimisticForceInc() {
        this.commonRefreshTest("testRefresh(Write,Commit/PessimisticForceInc,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(Write,Commit/PessimisticForceInc,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimisticReadRead() {
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/Read,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimisticReadWrite() {
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/Write,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimisticReadPessimisticRead() {
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimisticReadPessimisticWrite() {
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimisticReadPessimisticForceInc() {
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 3, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 3, null);
        this.commonRefreshTest("testRefresh(PessimisticRead,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticWriteRead() {
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/Read,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticWriteWrite() {
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/Write,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticWritePessimisticRead() {
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticWritePessimisticWrite() {
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticWritePessimisticForceInc() {
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 3, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 3, null);
        this.commonRefreshTest("testRefresh(PessimsiticWrite,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticForceIncRead() {
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/Read,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticForceIncWrite() {
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/Write,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 2, ExpectingOptimisticLockExClass);
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticForceIncPessimisticRead() {
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticForceIncPessimisticWrite() {
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    public void testRefreshPessimsiticForceIncPessimisticForceInc() {
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 3, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null);
        this.commonRefreshTest("testRefresh(PessimsiticForceInc,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 2, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 2, null);
    }

    private void commonRefreshTest(String testName, LockModeType t1Lock, SequencedActionsTest.Act t1IsCommit, int t1VersionInc, Class<?>[] t1Exceptions, LockModeType t2Lock, SequencedActionsTest.Act t2IsCommit, int t2VersionInc, Class<?>[] t2Exceptions) {
        String[] parameters = new String[]{"Thread 1: lock= " + t1Lock + ", isCommit= " + (Object)((Object)t1IsCommit) + ", versionInc= +" + t1VersionInc + ", expectedEx= " + Arrays.toString(t1Exceptions), "Thread 2: lock= " + t2Lock + ", isCommit= " + (Object)((Object)t2IsCommit) + ", versionInc= +" + t2VersionInc + ", expectedEx= " + Arrays.toString(t2Exceptions)};
        String t1Message1 = "Refresh in Thread 0";
        String t1Message2 = "Refresh in Thread 0 Again";
        String t2Message1 = "Refresh in Thread 1";
        Object[][] threadMain = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.NewThread, 1}, {SequencedActionsTest.Act.StartThread, 1}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.UpdateEmployee, 1, t1Message1}, {SequencedActionsTest.Act.TestEmployee, 1, t1Message1}, {SequencedActionsTest.Act.CommitTx}, {SequencedActionsTest.Act.TestException}, {SequencedActionsTest.Act.Notify, 1}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.RefreshWithLock, 1, t1Lock}, {SequencedActionsTest.Act.TestLockMode, 1, t1Lock}, {SequencedActionsTest.Act.TestEmployee, 1, t1Message1}, {SequencedActionsTest.Act.UpdateEmployee, 1, t1Message2}, {SequencedActionsTest.Act.TestEmployee, 1, t1Message2}, {t1IsCommit}, {SequencedActionsTest.Act.Notify, 1}, {SequencedActionsTest.Act.WaitAllChildren}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.TestEmployee, 1, null, t1VersionInc}, {SequencedActionsTest.Act.TestException, 0, t1Exceptions}, {SequencedActionsTest.Act.TestException, 1, t2Exceptions}, {SequencedActionsTest.Act.CloseEm}};
        Object[][] thread1 = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.TestException}, {SequencedActionsTest.Act.Notify, 0}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.UpdateEmployee, 1, t2Message1}, {SequencedActionsTest.Act.TestEmployee, 1, t2Message1}, {SequencedActionsTest.Act.RefreshWithLock, 1, t2Lock}, {SequencedActionsTest.Act.TestLockMode, 1, t2Lock}, {SequencedActionsTest.Act.TestEmployee, 1, t1Message1}, {SequencedActionsTest.Act.Notify, 0}, {SequencedActionsTest.Act.Wait}, {t2IsCommit}, {SequencedActionsTest.Act.CloseEm}};
        this.launchActionSequence(testName, parameters, threadMain, thread1);
    }
}

