/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestMixedLockManagerRefreshBasic
extends SequencedActionsTest {
    @Override
    public void setUp() {
        this.setUp(LockEmployee.class, "openjpa.LockManager", "mixed");
        this.commonSetUp();
    }

    public void testRefreshRead() {
        this.testCommon("testRefreshRead", LockModeType.READ, 0, 1);
    }

    public void testRefreshWrite() {
        this.testCommon("testRefreshWrite", LockModeType.WRITE, 1, 1);
    }

    public void testRefreshOptimistic() {
        this.testCommon("testRefreshOptimistic", LockModeType.OPTIMISTIC, 0, 1);
    }

    public void testRefreshOptimisticForceInc() {
        this.testCommon("testRefreshOptimisticForceInc", LockModeType.OPTIMISTIC_FORCE_INCREMENT, 1, 1);
    }

    public void testRefreshPessimisticRead() {
        this.testCommon("testRefreshPessimisticRead", LockModeType.PESSIMISTIC_READ, 0, 1);
    }

    public void testRefreshPessimisticWrite() {
        this.testCommon("testRefreshPessimisticWrite", LockModeType.PESSIMISTIC_WRITE, 0, 1);
    }

    public void testRefreshPessimisticForceInc() {
        this.testCommon("testRefreshPessimisticForceInc", LockModeType.PESSIMISTIC_FORCE_INCREMENT, 1, 1);
    }

    public void testCommon(String testName, LockModeType lockMode, int commitVersionIncrement, int updateCommitVersionIncrement) {
        Object[][] threadMain = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.Clear}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.RefreshWithLock, 1, lockMode}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.CommitTx}, {SequencedActionsTest.Act.Clear}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName", commitVersionIncrement}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.Clear}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.UpdateEmployee, 1, "New Name 2"}, {SequencedActionsTest.Act.TestEmployee, 1, "New Name 2"}, {SequencedActionsTest.Act.RefreshWithLock, 1, lockMode}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName", 0}, {SequencedActionsTest.Act.UpdateEmployee, 1, lockMode.toString()}, {SequencedActionsTest.Act.CommitTx}, {SequencedActionsTest.Act.Clear}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.TestEmployee, 1, lockMode.toString(), updateCommitVersionIncrement}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.Clear}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.TestEmployee, 1, lockMode.toString()}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.UpdateEmployee, 1, "New Name 3"}, {SequencedActionsTest.Act.TestEmployee, 1, "New Name 3", 0}, {SequencedActionsTest.Act.RefreshWithLock, 1, lockMode}, {SequencedActionsTest.Act.TestEmployee, 1, lockMode.toString(), 0}, {SequencedActionsTest.Act.UpdateEmployee, 1, lockMode.toString() + " Again"}, {SequencedActionsTest.Act.RollbackTx}, {SequencedActionsTest.Act.Clear}, {SequencedActionsTest.Act.Find, 1}, {SequencedActionsTest.Act.TestEmployee, 1, lockMode.toString(), 0}, {SequencedActionsTest.Act.CloseEm}};
        this.launchActionSequence(testName, "LockMode=" + lockMode, new Object[][][]{threadMain});
    }
}

