/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.Arrays;
import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestMixedLockManagerLockPermutation
extends SequencedActionsTest {
    @Override
    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    @Override
    public void setUp() {
        this.setUp(LockEmployee.class, "openjpa.LockManager", "mixed");
        this.commonSetUp();
    }

    public void testLockReadRead() {
        this.commonLockTest("testLock(Read,Commit/Read,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(Read,Commit/Read,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockReadWrite() {
        this.commonLockTest("testLock(Read,Commit/Write,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(Read,Commit/Write,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockReadPessimisticRead() {
        this.commonLockTest("testLock(Read,Commit/PessimisticRead,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, null);
        this.commonLockTest("testLock(Read,Commit/PessimisticRead,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockReadPessimisticWrite() {
        this.commonLockTest("testLock(Read,Commit/PessimisticWrite,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, null);
        this.commonLockTest("testLock(Read,Commit/PessimisticWrite,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockReadPessimisticForceInc() {
        this.commonLockTest("testLock(Read,Commit/PessimisticForceInc,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, null);
        this.commonLockTest("testLock(Read,Commit/PessimisticForceInc,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockWriteRead() {
        this.commonLockTest("testLock(Write,Commit/Read,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(Write,Commit/Read,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockWriteWrite() {
        this.commonLockTest("testLock(Write,Commit/Write,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(Write,Commit/Write,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockWritePessimisticRead() {
        this.commonLockTest("testLock(Write,Commit/PessimisticRead,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, null);
        this.commonLockTest("testLock(Write,Commit/PessimisticRead,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockWritePessimisticWrite() {
        this.commonLockTest("testLock(Write,Commit/PessimisticWrite,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, null);
        this.commonLockTest("testLock(Write,Commit/PessimisticWrite,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockWritePessimisticForceInc() {
        this.commonLockTest("testLock(Write,Commit/PessimisticForceInc,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, null);
        this.commonLockTest("testLock(Write,Commit/PessimisticForceInc,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimisticReadRead() {
        this.commonLockTest("testLock(PessimisticRead,Commit/Read,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimisticRead,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimisticReadWrite() {
        this.commonLockTest("testLock(PessimisticRead,Commit/Write,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimisticRead,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimisticReadPessimisticRead() {
        this.commonLockTest("testLock(PessimisticRead,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimisticRead,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimisticReadPessimisticWrite() {
        this.commonLockTest("testLock(PessimisticRead,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimisticRead,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimisticReadPessimisticForceInc() {
        this.commonLockTest("testLock(PessimisticRead,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimisticRead,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimsiticWriteRead() {
        this.commonLockTest("testLock(PessimsiticWrite,Commit/Read,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticWrite,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimsiticWriteWrite() {
        this.commonLockTest("testLock(PessimsiticWrite,Commit/Write,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticWrite,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimsiticWritePessimisticRead() {
        this.commonLockTest("testLock(PessimsiticWrite,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticWrite,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimsiticWritePessimisticWrite() {
        this.commonLockTest("testLock(PessimsiticWrite,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticWrite,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimsiticWritePessimisticForceInc() {
        this.commonLockTest("testLock(PessimsiticWrite,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticWrite,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimsiticForceIncRead() {
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/Read,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimsiticForceIncWrite() {
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/Write,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null, null);
    }

    public void testLockPessimsiticForceIncPessimisticRead() {
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimsiticForceIncPessimisticWrite() {
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    public void testLockPessimsiticForceIncPessimisticForceInc() {
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, ExpectingOptimisticLockExClass);
        this.commonLockTest("testLock(PessimsiticForceInc,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, ExpectingOptimisticLockExClass, null);
    }

    private void commonLockTest(String testName, LockModeType t1Lock, SequencedActionsTest.Act t1IsCommit, int t1VersionInc, Class<?>[] t1Exceptions, LockModeType t2Lock, SequencedActionsTest.Act t2IsCommit, int t2VersionInc, Class<?>[] t2Exceptions, Class<?>[] t3Exceptions) {
        String[] parameters = new String[]{"Thread 1: lock= " + t1Lock + ", isCommit= " + (Object)((Object)t1IsCommit) + ", versionInc= +" + t1VersionInc + ", expectedEx= " + Arrays.toString(t1Exceptions), "Thread 2: lock= " + t2Lock + ", isCommit= " + (Object)((Object)t2IsCommit) + ", versionInc= +" + t2VersionInc + ", expectedEx= " + Arrays.toString(t2Exceptions)};
        Object[][] threadMain = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.CloseEm}, {SequencedActionsTest.Act.Sleep, 100}, {SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.Lock, 1, t1Lock}, {SequencedActionsTest.Act.TestException}, {SequencedActionsTest.Act.NewThread, 1}, {SequencedActionsTest.Act.StartThread, 1}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.UpdateEmployee}, {t1IsCommit}, {SequencedActionsTest.Act.Notify, 1}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.WaitAllChildren}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.TestEmployee, 1, null, t1VersionInc}, {SequencedActionsTest.Act.TestException, 0, t1Exceptions}, {SequencedActionsTest.Act.TestException, 1, t3Exceptions}, {SequencedActionsTest.Act.CloseEm}};
        Object[][] thread1 = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.Lock, 1, t2Lock}, {SequencedActionsTest.Act.TestException, 1, t2Exceptions}, {SequencedActionsTest.Act.Notify, 0}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.Sleep, 2000}, {SequencedActionsTest.Act.UpdateEmployee}, {t2IsCommit}, {SequencedActionsTest.Act.Sleep, 1000}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.TestEmployee, 1, null, t2VersionInc}, {SequencedActionsTest.Act.CloseEm}};
        this.launchActionSequence(testName, parameters, threadMain, thread1);
    }
}

