/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.Arrays;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestMixedLockManagerDeadlock
extends SequencedActionsTest {
    private SequencedActionsTest.DBType dbType;
    private HashMap<SequencedActionsTest.DBType, Class<?>[]> expWriteLockExClasses;

    @Override
    public void setUp() {
        DB2Dictionary db2dict;
        this.setSupportedDatabases(DB2Dictionary.class, DerbyDictionary.class, OracleDictionary.class, SQLServerDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        this.setUp(LockEmployee.class, "openjpa.LockManager", "mixed");
        this.commonSetUp();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.dbType = this.getDBType((EntityManager)em);
        DBDictionary dict = this.getDBDictionary();
        Class[] expDB2ExClass = ExpectingOptimisticLockExClass;
        if (DB2Dictionary.class.isAssignableFrom(dict.getClass()) && (db2dict = (DB2Dictionary)dict).getDB2MajorVersion() * 100 + db2dict.getDB2MinorVersion() > 905) {
            expDB2ExClass = null;
        }
        this.expWriteLockExClasses = new HashMap();
        this.expWriteLockExClasses.put(SequencedActionsTest.DBType.db2, expDB2ExClass);
        this.expWriteLockExClasses.put(SequencedActionsTest.DBType.derby, ExpectingOptimisticLockExClass);
        this.expWriteLockExClasses.put(SequencedActionsTest.DBType.oracle, null);
        this.expWriteLockExClasses.put(SequencedActionsTest.DBType.sqlserver, ExpectingOptimisticLockExClass);
    }

    public void testFindDeadLockException() {
        this.commonFindTest("testFindDeadLockException", LockModeType.READ, null);
        this.commonFindTest("testFindDeadLockException", LockModeType.WRITE, this.expWriteLockExClasses.get((Object)this.dbType));
        this.commonFindTest("testFindDeadLockException", LockModeType.PESSIMISTIC_WRITE, ExpectingAnyLockExClass);
    }

    private void commonFindTest(String testName, LockModeType t1Lock, Class<?>[] t1Exceptions) {
        String[] parameters = new String[]{"Thread 1: lock= " + t1Lock + ", expectedEx= " + Arrays.toString(t1Exceptions)};
        Object[][] threadMain = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.FindWithLock, 1, t1Lock}, {SequencedActionsTest.Act.Flush}, {SequencedActionsTest.Act.NewThread, 1}, {SequencedActionsTest.Act.StartThread, 1}, {SequencedActionsTest.Act.Wait, 0}, {SequencedActionsTest.Act.FindWithLock, 2, t1Lock}, {SequencedActionsTest.Act.WaitAllChildren}, {SequencedActionsTest.Act.TestException, -1, t1Exceptions}, {SequencedActionsTest.Act.RollbackTx}};
        Object[][] thread1 = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.FindWithLock, 2, t1Lock}, {SequencedActionsTest.Act.Flush}, {SequencedActionsTest.Act.Notify, 0}, {SequencedActionsTest.Act.Sleep, 1000}, {SequencedActionsTest.Act.FindWithLock, 1, t1Lock}, {SequencedActionsTest.Act.RollbackTx}};
        this.launchActionSequence(testName, parameters, threadMain, thread1);
    }

    public void testNamedQueryDeadLockException() {
        this.commonNamedQueryTest("testNamedQueryDeadLockException", LockModeType.READ, null);
        this.commonNamedQueryTest("testNamedQueryDeadLockException", LockModeType.WRITE, this.expWriteLockExClasses.get((Object)this.dbType));
        this.commonNamedQueryTest("testNamedQueryDeadLockException", LockModeType.PESSIMISTIC_FORCE_INCREMENT, ExpectingAnyLockExClass);
    }

    private void commonNamedQueryTest(String testName, LockModeType t1Lock, Class<?>[] t1Exceptions) {
        String[] parameters = new String[]{"Thread 1: lock= " + t1Lock + ", expectedEx= " + Arrays.toString(t1Exceptions)};
        Object[][] threadMain = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.NamedQueryWithLock, "findEmployeeById", 1, t1Lock, "openjpa.hint.IgnorePreparedQuery", true}, {SequencedActionsTest.Act.Flush}, {SequencedActionsTest.Act.NewThread, 1}, {SequencedActionsTest.Act.StartThread, 1}, {SequencedActionsTest.Act.Wait, 0}, {SequencedActionsTest.Act.NamedQueryWithLock, "findEmployeeById", 2, t1Lock, "openjpa.hint.IgnorePreparedQuery", true}, {SequencedActionsTest.Act.WaitAllChildren}, {SequencedActionsTest.Act.TestException, -1, t1Exceptions}, {SequencedActionsTest.Act.RollbackTx}, {SequencedActionsTest.Act.CloseEm}};
        Object[][] thread1 = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.NamedQueryWithLock, "findEmployeeById", 2, t1Lock, "openjpa.hint.IgnorePreparedQuery", true}, {SequencedActionsTest.Act.Flush}, {SequencedActionsTest.Act.Notify, 0}, {SequencedActionsTest.Act.Sleep, 1000}, {SequencedActionsTest.Act.NamedQueryWithLock, "findEmployeeById", 1, t1Lock, "openjpa.hint.IgnorePreparedQuery", true}, {SequencedActionsTest.Act.RollbackTx}, {SequencedActionsTest.Act.CloseEm}};
        this.launchActionSequence(testName, parameters, threadMain, thread1);
    }
}

