/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TransactionRequiredException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfigurationImpl;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestEmLockMode
extends SequencedActionsTest {
    private static String NON_SUPPORTED_OPTIMISTIC_SQL = "SELECT .* FROM LockEmployee .*";
    private static String NON_SUPPORTED_FOR_UPDATE_SQL = "";
    private static String VERSION_UPDATE_SQL = "UPDATE LockEmployee SET version .* WHERE .*";
    private static String DB2_OPTIMISTIC_SQL = "SELECT .* FROM LockEmployee .* WHERE .*";
    private static String DB2_PESSIMISTIC_RS_SQL = "SELECT .* FROM LockEmployee .* WITH RS USE .*";
    private static String DB2_PESSIMISTIC_RR_SQL = "SELECT .* FROM LockEmployee .* WITH RR USE .*";

    @Override
    public void setUp() {
        this.setUp(LockEmployee.class, "openjpa.LockManager", "mixed");
        this.commonSetUp();
        NON_SUPPORTED_FOR_UPDATE_SQL = NON_SUPPORTED_OPTIMISTIC_SQL + " " + this.escapeRegex(this.getForUpdateClause()) + ".*";
    }

    private String escapeRegex(String clause) {
        String rval = clause.replace("(", "\\(");
        rval = rval.replace(")", "\\)");
        return rval;
    }

    public void testFindLockModeIsolations() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.NONE, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 0, null);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.READ, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.WRITE, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, VERSION_UPDATE_SQL);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.OPTIMISTIC, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, VERSION_UPDATE_SQL);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_READ, 2, DB2_PESSIMISTIC_RS_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_WRITE, 2, DB2_PESSIMISTIC_RR_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestFindLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 2, DB2_PESSIMISTIC_RR_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, VERSION_UPDATE_SQL);
        em.getTransaction().rollback();
        em.close();
    }

    private void commonTestFindLockModeIsolations(EntityManager em, LockModeType lockMode, int expectedSupportSQLCount, String expectedSupportSQL, int expectedNonSupportSQLCount, String expectedNonSupportSQL, int expectedVersionUpdateCount, String expectedVersionUpdateSQL) {
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        DBDictionary dict = ((JDBCConfiguration)((OpenJPAEntityManagerSPI)oem).getConfiguration()).getDBDictionaryInstance();
        em.clear();
        this.resetSQL();
        int beforeIsolation = fConfig.getIsolation();
        em.find(LockEmployee.class, (Object)1, lockMode);
        if (dict.supportsIsolationForUpdate() && dict instanceof DB2Dictionary) {
            TestEmLockMode.assertEquals((int)expectedSupportSQLCount, (int)this.getSQLCount());
            this.assertAllSQLInOrder(expectedSupportSQL);
        } else {
            TestEmLockMode.assertEquals((int)expectedNonSupportSQLCount, (int)this.getSQLCount());
            this.assertAllSQLInOrder(expectedNonSupportSQL);
        }
        this.resetSQL();
        em.flush();
        TestEmLockMode.assertEquals((int)expectedVersionUpdateCount, (int)this.getSQLCount());
        if (expectedVersionUpdateSQL != null) {
            this.assertAllSQLInOrder(expectedVersionUpdateSQL);
        }
        TestEmLockMode.assertEquals((int)beforeIsolation, (int)fConfig.getIsolation());
    }

    public void testRefreshLockModeIsolations() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.NONE, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 0, null);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.READ, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.WRITE, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, VERSION_UPDATE_SQL);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.OPTIMISTIC, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 1, DB2_OPTIMISTIC_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL, 1, VERSION_UPDATE_SQL);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_READ, 2, DB2_PESSIMISTIC_RS_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_WRITE, 2, DB2_PESSIMISTIC_RR_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestRefreshLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 2, DB2_PESSIMISTIC_RR_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, VERSION_UPDATE_SQL);
        em.getTransaction().rollback();
        em.close();
    }

    private void commonTestRefreshLockModeIsolations(EntityManager em, LockModeType lockMode, int expectedSupportSQLCount, String expectedSupportSQL, int expectedNonSupportSQLCount, String expectedNonSupportSQL, int expectedVersionUpdateCount, String expectedVersionUpdateSQL) {
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        DBDictionary dict = ((JDBCConfiguration)((OpenJPAEntityManagerSPI)oem).getConfiguration()).getDBDictionaryInstance();
        em.clear();
        LockEmployee employee = (LockEmployee)em.find(LockEmployee.class, (Object)1);
        this.resetSQL();
        int beforeIsolation = fConfig.getIsolation();
        em.refresh((Object)employee, lockMode);
        if (dict.supportsIsolationForUpdate() && dict instanceof DB2Dictionary) {
            TestEmLockMode.assertEquals((int)expectedSupportSQLCount, (int)this.getSQLCount());
            this.assertAllSQLInOrder(expectedSupportSQL);
        } else {
            TestEmLockMode.assertEquals((int)expectedNonSupportSQLCount, (int)this.getSQLCount());
            this.assertAllSQLInOrder(expectedNonSupportSQL);
        }
        this.resetSQL();
        em.flush();
        TestEmLockMode.assertEquals((int)expectedVersionUpdateCount, (int)this.getSQLCount());
        if (expectedVersionUpdateSQL != null) {
            this.assertAllSQLInOrder(expectedVersionUpdateSQL);
        }
        TestEmLockMode.assertEquals((int)beforeIsolation, (int)fConfig.getIsolation());
    }

    public void testLockLockModeIsolations() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.NONE, 0, null, 0, null, 0, null);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.READ, 0, null, 0, null, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.WRITE, 0, null, 0, null, 1, VERSION_UPDATE_SQL);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.OPTIMISTIC, 0, null, 0, null, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 0, null, 0, null, 1, VERSION_UPDATE_SQL);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_READ, 2, DB2_PESSIMISTIC_RS_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_WRITE, 2, DB2_PESSIMISTIC_RR_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, NON_SUPPORTED_OPTIMISTIC_SQL);
        this.commonTestLockLockModeIsolations((EntityManager)em, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 2, DB2_PESSIMISTIC_RR_SQL, 2, NON_SUPPORTED_FOR_UPDATE_SQL, 1, VERSION_UPDATE_SQL);
        em.getTransaction().rollback();
        em.close();
    }

    private void commonTestLockLockModeIsolations(EntityManager em, LockModeType lockMode, int expectedSupportSQLCount, String expectedSupportSQL, int expectedNonSupportSQLCount, String expectedNonSupportSQL, int expectedVersionUpdateCount, String expectedVersionUpdateSQL) {
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        DBDictionary dict = ((JDBCConfiguration)((OpenJPAEntityManagerSPI)oem).getConfiguration()).getDBDictionaryInstance();
        em.clear();
        LockEmployee employee = (LockEmployee)em.find(LockEmployee.class, (Object)1);
        this.resetSQL();
        int beforeIsolation = fConfig.getIsolation();
        em.lock((Object)employee, lockMode);
        if (dict.supportsIsolationForUpdate() && dict instanceof DB2Dictionary) {
            TestEmLockMode.assertEquals((int)expectedSupportSQLCount, (int)this.getSQLCount());
            if (expectedSupportSQL != null) {
                this.assertAllSQLInOrder(expectedSupportSQL);
            }
        } else {
            TestEmLockMode.assertEquals((int)expectedNonSupportSQLCount, (int)this.getSQLCount());
            if (expectedNonSupportSQL != null) {
                this.assertAllSQLInOrder(expectedNonSupportSQL);
            }
        }
        this.resetSQL();
        em.flush();
        TestEmLockMode.assertEquals((int)expectedVersionUpdateCount, (int)this.getSQLCount());
        if (expectedVersionUpdateSQL != null) {
            this.assertAllSQLInOrder(expectedVersionUpdateSQL);
        }
        TestEmLockMode.assertEquals((int)beforeIsolation, (int)fConfig.getIsolation());
    }

    public void testGetLockMode() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LockEmployee employee = (LockEmployee)em.find(LockEmployee.class, (Object)1);
        try {
            em.getLockMode((Object)employee);
            TestEmLockMode.fail((String)"Expecting TransactionRequiredException.");
        }
        catch (TransactionRequiredException tre) {
        }
        catch (Exception e) {
            TestEmLockMode.fail((String)"Expecting TransactionRequiredException.");
        }
        em.getTransaction().begin();
        try {
            TestEmLockMode.assertEquals((String)"getLockMode only allows in transaction.", (Object)LockModeType.NONE, (Object)em.getLockMode((Object)employee));
        }
        catch (Exception e) {
            TestEmLockMode.fail((String)"Do not expecting any exception.");
        }
        em.getTransaction().rollback();
        em.clear();
        em.getTransaction().begin();
        try {
            em.getLockMode((Object)employee);
            TestEmLockMode.fail((String)"Expecting IllegalArgumentException for getLockMode on a detached entity in an active transaction.");
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            TestEmLockMode.fail((String)"Expecting IllegalArgumentException for getLockMode on a detached entity in an active transaction.");
        }
        em.getTransaction().rollback();
        em.getTransaction().begin();
        try {
            employee = (LockEmployee)em.find(LockEmployee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
            TestEmLockMode.assertEquals((String)"Test getLockMode on non-NONE lock mode type.", (Object)LockModeType.PESSIMISTIC_WRITE, (Object)em.getLockMode((Object)employee));
        }
        catch (Exception e) {
            TestEmLockMode.fail((String)"Do not expecting any exception.");
        }
        em.getTransaction().rollback();
        em.close();
    }
}

