/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PessimisticLockException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public abstract class SequencedActionsTest
extends SQLListenerTestCase {
    protected static final String Default_FirstName = "Def FirstName";
    protected static final Class<?>[] ExpectingOptimisticLockExClass = new Class[]{OptimisticLockException.class};
    protected static final Class<?>[] ExpectingPessimisticLockExClass = new Class[]{PessimisticLockException.class};
    protected static final Class<?>[] ExpectingLockTimeoutExClass = new Class[]{LockTimeoutException.class};
    protected static final Class<?>[] ExpectingAnyLockExClass = new Class[]{PessimisticLockException.class, LockTimeoutException.class};
    protected static final int MinThreadWaitInMs = 10000;
    private static long waitInMsec = -1L;
    private String empTableName;
    private List<TestThread> threads = null;

    @Override
    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commonSetUp() {
        this.empTableName = this.getMapping(LockEmployee.class).getTable().getFullName();
        this.cleanupDB();
        LockEmployee e1 = this.newEmployee(1);
        LockEmployee e2 = this.newEmployee(2);
        LockEmployee e3 = this.newEmployee(3);
        this.resetSQL();
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e1);
            em.persist((Object)e2);
            em.persist((Object)e3);
            em.getTransaction().commit();
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.assertAllSQLInOrder("INSERT INTO " + this.empTableName + " .*");
        long speedCnt = -1L;
        if (waitInMsec == -1L) {
            speedCnt = this.platformSpeedTest();
            try {
                waitInMsec = 10000L + 250000L / (speedCnt / 1000000L);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (waitInMsec <= 0L) {
            waitInMsec = 10000L;
        }
        this.getLog().trace((Object)("**** Speed Cont=" + speedCnt + ", waitTime(ms)=" + waitInMsec));
    }

    private long platformSpeedTest() {
        PlatformSpeedTestThread speedThread = new PlatformSpeedTestThread();
        speedThread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.logStack(e);
        }
        speedThread.interrupt();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            this.logStack(e);
        }
        return speedThread.getLoopCnt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDB() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.createQuery("delete from " + this.empTableName).executeUpdate();
            em.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private LockEmployee newEmployee(int id) {
        LockEmployee e = new LockEmployee();
        e.setId(id);
        return e;
    }

    @Override
    protected Log getLog() {
        return this.emf.getConfiguration().getLog("Tests");
    }

    protected Log getDumpStackLog() {
        return this.emf.getConfiguration().getLog("DumpStack");
    }

    protected void logStack(Throwable t) {
        StringWriter str = new StringWriter();
        PrintWriter print = new PrintWriter(str);
        t.printStackTrace(print);
        this.getDumpStackLog().trace((Object)str.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyParent() {
        this.getLog().trace((Object)"notifyParent:");
        SequencedActionsTest sequencedActionsTest = this;
        synchronized (sequencedActionsTest) {
            ((Object)((Object)this)).notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchActionSequence(String testName, Object parameters, Object[][] ... actions) {
        Log log = this.getLog();
        log.trace((Object)("============/// " + testName + " ///============"));
        if (parameters != null) {
            if (parameters instanceof String[]) {
                for (String parameter : (String[])parameters) {
                    log.trace((Object)("---> " + parameter));
                }
            } else if (parameters instanceof String) {
                log.trace((Object)("---> " + (String)parameters));
            }
        }
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            LockEmployee ei = (LockEmployee)em.find(LockEmployee.class, (Object)1);
            SequencedActionsTest.assertNotNull((Object)ei);
            ei.setFirstName(Default_FirstName);
            em.getTransaction().commit();
        }
        catch (Exception ex) {
            this.logStack(ex);
            Throwable rootCause = ex.getCause();
            String failStr = "Unable to pre-initialize FirstName to known value:" + ex.getClass().getName() + ":" + ex;
            if (rootCause != null) {
                failStr = failStr + "\n        -- Cause --> " + rootCause.getClass().getName() + ":" + rootCause;
            }
            SequencedActionsTest.fail((String)failStr);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    if (em.getTransaction().getRollbackOnly()) {
                        log.trace((Object)"finally: rolledback");
                        em.getTransaction().rollback();
                        log.trace((Object)"finally: rolledback completed");
                    } else {
                        log.trace((Object)"finally: commit");
                        em.getTransaction().commit();
                        log.trace((Object)"finally: commit completed");
                    }
                }
                em.close();
            }
        }
        int numThreads = actions.length;
        this.threads = new ArrayList<TestThread>(numThreads);
        TestThread mainThread = new TestThread(0, actions);
        this.threads.add(mainThread);
        this.launchCommonSequence(mainThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void launchCommonSequence(TestThread thisThread) {
        threadToRun = TestThread.access$000(thisThread);
        actions = TestThread.access$100(thisThread);
        employees = TestThread.access$200(thisThread);
        SequencedActionsTest.assertNotNull((String)"Test sequence table must be defined", (Object)actions);
        if (!SequencedActionsTest.$assertionsDisabled && actions.length < 1) {
            throw new AssertionError();
        }
        numThreads = actions.length;
        saveVersion = -1;
        log = this.getLog();
        log.trace((Object)(">>>> Sequenced Test: Threads=" + threadToRun + '/' + numThreads));
        endTime = System.currentTimeMillis() + SequencedActionsTest.waitInMsec;
        em = null;
        id = 1;
        employee = null;
        lockMode = null;
        curAction = null;
        actIndex = 0;
        block61: for (Object[] args : threadSequence = actions[threadToRun]) {
            curAction = (Act)args[0];
            curAct = "Act[t" + threadToRun + ":" + ++actIndex + "]=" + Arrays.toString(args);
            log.trace((Object)("** " + curAct));
            try {
                block6 : switch (1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[curAction.ordinal()]) {
                    case 1: {
                        em = this.emf.createEntityManager();
                        break;
                    }
                    case 2: {
                        if (em == null || !em.isOpen()) break;
                        em.close();
                        em = null;
                        break;
                    }
                    case 3: {
                        em.clear();
                        break;
                    }
                    case 4: {
                        em.flush();
                        break;
                    }
                    case 5: {
                        id = 1;
                        if (args.length > 1) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)em.find(LockEmployee.class, (Object)id);
                        log.trace((Object)("Employee=" + employee));
                        if (employee != null) {
                            employees.put(id, employee);
                            break;
                        }
                        employees.remove(id);
                        break;
                    }
                    case 6: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        lockMode = LockModeType.NONE;
                        if (args[2] != null) {
                            lockMode = (LockModeType)args[2];
                        }
                        employee = (findProps = this.buildPropsMap(args, 3)) != null ? (LockEmployee)em.find(LockEmployee.class, (Object)id, lockMode, findProps) : (LockEmployee)em.find(LockEmployee.class, (Object)id, lockMode);
                        log.trace((Object)("Employee=" + employee));
                        if (employee != null) {
                            employees.put(id, employee);
                            break;
                        }
                        employees.remove(id);
                        break;
                    }
                    case 7: {
                        em.find((Class)args[1], args[2], (LockModeType)args[3]);
                        break;
                    }
                    case 8: {
                        namedQuery = "????";
                        if (args.length > 1) {
                            namedQuery = (String)args[1];
                        }
                        id = 1;
                        if (args.length > 2) {
                            id = (Integer)args[2];
                        }
                        lockMode = null;
                        if (args.length > 3) {
                            lockMode = (LockModeType)args[3];
                        }
                        queryProps = this.buildPropsMap(args, 4);
                        q = em.createNamedQuery(namedQuery);
                        if (lockMode != null) {
                            q.setLockMode(lockMode);
                        }
                        if (queryProps != null) {
                            for (String name : queryProps.keySet()) {
                                q.setHint(name, queryProps.get(name));
                            }
                        }
                        q.setParameter("id", (Object)id);
                        employee = (LockEmployee)q.getSingleResult();
                        log.trace((Object)("Employee=" + employee));
                        if (employee != null) {
                            employees.put(id, employee);
                            break;
                        }
                        employees.remove(id);
                        break;
                    }
                    case 9: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        firstName = (String)args[2];
                        employee = new LockEmployee();
                        employee.setId(id);
                        employee.setFirstName(firstName);
                        log.trace((Object)("Employee=" + employee));
                        em.persist((Object)employee);
                        break;
                    }
                    case 10: {
                        id = 1;
                        if (args.length > 1) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee=" + employee));
                        em.remove((Object)employee);
                        break;
                    }
                    case 11: {
                        id = 1;
                        if (args.length > 1) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee(before)=" + employee));
                        em.refresh((Object)employee);
                        log.trace((Object)("Employee(after) =" + employee));
                        break;
                    }
                    case 12: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        lockMode = LockModeType.NONE;
                        if (args[2] != null) {
                            lockMode = (LockModeType)args[2];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee(before)=" + employee));
                        refreshProps = this.buildPropsMap(args, 3);
                        if (refreshProps != null) {
                            em.refresh((Object)employee, lockMode, refreshProps);
                        } else {
                            em.refresh((Object)employee, lockMode);
                        }
                        log.trace((Object)("Employee(after) =" + employee));
                        break;
                    }
                    case 13: {
                        em.refresh(args[1], (LockModeType)args[2]);
                        break;
                    }
                    case 14: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        lockMode = LockModeType.NONE;
                        if (args[2] != null) {
                            lockMode = (LockModeType)args[2];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee=" + employee));
                        lockProps = this.buildPropsMap(args, 3);
                        if (lockProps != null) {
                            em.lock((Object)employee, lockMode, lockProps);
                            break;
                        }
                        em.lock((Object)employee, lockMode);
                        break;
                    }
                    case 15: {
                        em.lock(args[1], (LockModeType)args[2]);
                        break;
                    }
                    case 16: {
                        id = 1;
                        if (args.length > 1) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee (before):" + employee));
                        newFirstName = "Unknown";
                        newFirstName = args.length > 2 ? (String)args[2] : new Date().toString();
                        employee.setFirstName(newFirstName);
                        log.trace((Object)("Employee (after) :" + employee));
                        break;
                    }
                    case 17: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee (before) :" + employee));
                        detEmployee = (LockEmployee)((OpenJPAEntityManager)em.getDelegate()).detachCopy((Object)employee);
                        employees.put((Integer)args[2], detEmployee);
                        log.trace((Object)("Employee (after)  :" + detEmployee));
                        break;
                    }
                    case 18: {
                        em.getTransaction().begin();
                        break;
                    }
                    case 19: {
                        em.getTransaction().commit();
                        break;
                    }
                    case 20: {
                        em.getTransaction().rollback();
                        break;
                    }
                    case 21: {
                        childToRun = (Integer)args[1];
                        t1 = new TestThread(childToRun, actions);
                        this.threads.add(t1);
                        break;
                    }
                    case 22: {
                        this.threads.get((Integer)args[1]).start();
                        break;
                    }
                    case 23: {
                        Thread.sleep(500L);
                        notifyThreadid = 0;
                        if (args.length > 1 && args[1] != null) {
                            notifyThreadid = (Integer)args[1];
                        }
                        if (args.length > 2) {
                            Thread.sleep(((Integer)args[2]).intValue());
                        }
                        if (notifyThreadid == 0) {
                            this.notifyParent();
                            break;
                        }
                        this.threads.get(notifyThreadid).notifyThread();
                        break;
                    }
                    case 24: {
                        waitThreadid = threadToRun;
                        if (args.length > 1 && args[1] != null) {
                            waitThreadid = (Integer)args[1];
                        }
                        waitTime = (int)(SequencedActionsTest.waitInMsec / 5L);
                        if (args.length > 2 && args[2] != null) {
                            waitTime = (Integer)args[2];
                        }
                        if (waitTime < 5000) {
                            waitTime = 5000;
                        }
                        log.trace((Object)(">> Started wait for " + waitTime + " ms"));
                        if (waitThreadid != 0) {
                            thisThread.wait(waitTime);
                        } else {
                            var36_39 = this;
                            synchronized (var36_39) {
                                this.wait(waitTime);
                            }
                        }
                        log.trace((Object)"<< Ended wait");
                        break;
                    }
                    case 25: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        SequencedActionsTest.assertNotNull((String)curAct, (Object)employee);
                        break;
                    }
                    case 26: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        switch (args.length) {
                            case 4: {
                                if (args[3] != null) {
                                    SequencedActionsTest.assertEquals((String)curAct, (int)(saveVersion + (Integer)args[3]), (int)employee.getVersion());
                                }
                            }
                            case 3: {
                                if (args[2] != null) {
                                    SequencedActionsTest.assertEquals((String)curAct, (String)((String)args[2]), (String)employee.getFirstName());
                                }
                            }
                            case 2: {
                                if (args[1] == null) break;
                                SequencedActionsTest.assertEquals((String)curAct, (int)id, (int)employee.getId());
                                break block6;
                            }
                            case 1: {
                                SequencedActionsTest.assertNull((String)curAct, (Object)employee);
                            }
                        }
                        break;
                    }
                    case 27: {
                        id = 1;
                        if (args.length > 1) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        saveVersion = employee.getVersion();
                        log.trace((Object)("save version= " + saveVersion));
                        break;
                    }
                    case 28: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        increment = (Integer)args[2];
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("test version: expected=" + (saveVersion + increment) + ", testing=" + employee.getVersion()));
                        SequencedActionsTest.assertEquals((String)curAct, (int)(saveVersion + increment), (int)employee.getVersion());
                        break;
                    }
                    case 29: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        expectedlockMode = (LockModeType)args[2];
                        testinglockMode = em.getLockMode((Object)employee);
                        log.trace((Object)("test version: expected=" + expectedlockMode + ", testing=" + testinglockMode));
                        SequencedActionsTest.assertEquals((String)curAct, (Object)this.getCanonical(expectedlockMode), (Object)this.getCanonical(testinglockMode));
                        break;
                    }
                    case 30: {
                        thisThread.throwable = null;
                        break;
                    }
                    case 31: {
                        expectedExceptions = null;
                        if (args.length > 2) {
                            expectedExceptions = new ArrayList<Class>();
                            for (i = 2; i < args.length; ++i) {
                                if (args[i] instanceof Object[]) {
                                    for (Object o : (Object[])args[i]) {
                                        if (o == null || !(o instanceof Class)) continue;
                                        expectedExceptions.add((Class)o);
                                    }
                                    continue;
                                }
                                if (args[i] == null || !(args[i] instanceof Class)) continue;
                                expectedExceptions.add((Class)args[i]);
                            }
                        }
                        threadId = threadToRun;
                        if (args.length > 1) {
                            threadId = (Integer)args[1];
                        }
                        if (threadId == -1) ** GOTO lbl338
                        testExClass = null;
                        curThrowable = null;
                        exMatched = false;
                        exThread = this.threads.get(threadId);
                        curThrowable = exThread.throwable;
                        testExClass = this.processException(exThread, curAction, curThrowable);
                        if (expectedExceptions == null || expectedExceptions.size() <= 0) ** GOTO lbl329
                        for (Class expectedException : expectedExceptions) {
                            if (!this.matchExpectedException(curAct, expectedException, curThrowable)) continue;
                            exMatched = true;
                            ** GOTO lbl331
                        }
                        ** GOTO lbl331
lbl329:
                        // 1 sources

                        if (curThrowable == null) {
                            exMatched = true;
                        }
lbl331:
                        // 5 sources

                        if (!exMatched) {
                            log.trace((Object)testExClass);
                            if (curThrowable != null) {
                                this.logStack(curThrowable);
                            }
                        }
                        SequencedActionsTest.assertTrue((String)(curAct + ":Expecting=" + expectedExceptions + ", Testing=" + testExClass), (boolean)exMatched);
                        exThread.throwable = null;
                        break;
lbl338:
                        // 1 sources

                        if (expectedExceptions == null || expectedExceptions.size() == 0) {
                            noExMatched = true;
                            aTestExClass = "[";
                            for (TestThread aThread : this.threads) {
                                aThrowable = aThread.throwable;
                                aTestExClass = aTestExClass + this.processException(aThread, curAction, aThrowable) + ", ";
                                if (aThrowable == null) continue;
                                noExMatched = false;
                                log.trace((Object)aTestExClass);
                                this.logStack(aThrowable);
                                aThread.throwable = null;
                            }
                            SequencedActionsTest.assertTrue((String)(curAct + ":Expecting=[no exception]" + ", Testing=" + aTestExClass + ']'), (boolean)noExMatched);
                            break;
                        }
                        aMatched = false;
                        aTestExClass = "[";
                        for (TestThread aThread : this.threads) {
                            aThrowable = aThread.throwable;
                            aTestExClass = aTestExClass + this.processException(aThread, curAction, aThrowable) + ", ";
                            for (Class anExpectedException : expectedExceptions) {
                                if (!this.matchExpectedException(curAct, anExpectedException, aThrowable)) continue;
                                aMatched = true;
                                break;
                            }
                            if (aMatched) break;
                            if (aThrowable == null) continue;
                            this.logStack(aThrowable);
                            aThread.throwable = null;
                        }
                        if (!aMatched) {
                            log.trace((Object)aTestExClass);
                        }
                        SequencedActionsTest.assertTrue((String)(curAct + ":Expecting=" + expectedExceptions + ", Testing=" + aTestExClass + "]"), (boolean)aMatched);
                        break;
                    }
                    case 32: {
                        log.trace((Object)("checking if thread is alive for " + (endTime - System.currentTimeMillis()) + "ms."));
                        deadThreads = 0;
                        proceedThread = new ArrayList<TestThread>(this.threads);
                        block69: while (proceedThread.size() > 0 && System.currentTimeMillis() < endTime) {
                            for (TestThread thread : proceedThread) {
                                if (thread.isAlive()) {
                                    log.trace((Object)(thread + " is still alive, wait" + " for 500ms and try again."));
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                    log.trace((Object)("waiting children thread (" + (endTime - System.currentTimeMillis()) + " ms left)"));
                                    continue;
                                }
                                ++deadThreads;
                                if (thread.assertError != null) {
                                    throw thread.assertError;
                                }
                                proceedThread.remove(thread);
                                continue block69;
                            }
                        }
                        if (proceedThread.size() <= 0) break;
                        log.trace((Object)(proceedThread.size() + " threads still alive."));
                        for (TestThread thread : proceedThread) {
                            log.trace((Object)("Send interrupt to thread " + TestThread.access$000(thread)));
                            thread.interrupt();
                        }
                        continue block61;
                    }
                    case 33: {
                        for (TestThread thread : this.threads) {
                            alive = thread.isAlive();
                            if (!alive) continue;
                            log.trace((Object)(thread.getName() + " is still alive"));
                            try {
                                thread.interrupt();
                                thread.join();
                            }
                            catch (Exception e) {
                                this.logStack(e);
                            }
                        }
                        continue block61;
                    }
                    case 34: {
                        Thread.yield();
                        break;
                    }
                    case 35: {
                        Thread.sleep(((Integer)args[1]).intValue());
                        break;
                    }
                    case 36: {
                        id = 1;
                        if (args[1] != null) {
                            id = (Integer)args[1];
                        }
                        employee = (LockEmployee)employees.get(id);
                        log.trace((Object)("Employee (before)=" + employee));
                        baos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(baos);
                        employee.writeExternal(oos);
                        oos.flush();
                        baos.flush();
                        bais = new ByteArrayInputStream(baos.toByteArray());
                        ois = new ObjectInputStream(bais);
                        transformedEmployee = new LockEmployee();
                        transformedEmployee.readExternal(ois);
                        log.trace((Object)("Employee (after) =" + transformedEmployee));
                        employees.put((Integer)args[2], transformedEmployee);
                        break;
                    }
                    case 37: {
                        log.info(args[1]);
                        break;
                    }
                    case 38: {
                        log.warn(args[1]);
                        break;
                    }
                    case 39: {
                        log.error(args[1]);
                        break;
                    }
                    case 40: {
                        log.trace(args[1]);
                        break;
                    }
                    case 41: {
                        em.lock((Object)"xxx", LockModeType.WRITE);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (thisThread.throwable == null) {
                    thisThread.throwable = ex;
                }
                log.trace((Object)("Caught exception and continue: " + ex));
                this.logStack(ex);
            }
            catch (Error err) {
                if (thisThread.assertError == null) {
                    thisThread.assertError = err;
                }
                log.trace((Object)("Caught exception and continue: " + err));
                this.logStack(err);
            }
        }
        if (em != null && em.isOpen()) {
            if (em.getTransaction().isActive()) {
                if (thisThread != null) {
                    thisThread.systemRolledback = em.getTransaction().getRollbackOnly();
                }
                try {
                    if (em.getTransaction().getRollbackOnly()) {
                        log.trace((Object)"finally: rolledback");
                        em.getTransaction().rollback();
                        log.trace((Object)"finally: rolledback completed");
                    } else {
                        log.trace((Object)"finally: commit");
                        em.getTransaction().commit();
                        log.trace((Object)"finally: commit completed");
                    }
                }
                catch (Exception finalEx) {
                    failStr = this.processException(thisThread, curAction, finalEx);
                    log.trace((Object)("Fincally:" + failStr));
                }
            }
            em.close();
            if (thisThread.assertError != null) {
                throw thisThread.assertError;
            }
            log.trace((Object)("<<<< Sequenced Test: Threads=" + threadToRun + '/' + numThreads));
        }
    }

    private LockModeType getCanonical(LockModeType lockMode) {
        if (lockMode == LockModeType.READ) {
            return LockModeType.OPTIMISTIC;
        }
        if (lockMode == LockModeType.WRITE) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        return lockMode;
    }

    private String processException(TestThread thread, Act curAction, Throwable t) {
        String failStr = "[" + thread.threadToRun + "] Caught exception: none";
        if (t != null) {
            this.getLog().trace((Object)("[" + thread.threadToRun + "] Caught exception: " + t.getClass().getName() + ":" + t));
            this.logStack(t);
            Throwable rootCause = t.getCause();
            failStr = "Failed on action '" + (Object)((Object)curAction) + "' with exception " + t;
            if (rootCause != null) {
                failStr = failStr + "\n        -- Cause --> " + rootCause.getClass().getName() + ":" + rootCause;
            }
        }
        return failStr;
    }

    private Map<String, Object> buildPropsMap(Object[] args, int startIdx) {
        HashMap<String, Object> props = null;
        if (args.length > startIdx) {
            props = new HashMap<String, Object>();
            while (startIdx < args.length - 1) {
                props.put((String)args[startIdx], args[startIdx + 1]);
                startIdx += 2;
            }
        }
        this.getLog().trace((Object)("Properties Map= " + props));
        return props;
    }

    private boolean matchExpectedException(String curAct, Class<?> expected, Throwable tested) {
        SequencedActionsTest.assertNotNull((String)curAct, expected);
        Class<?> testExClass = null;
        boolean exMatched = true;
        if (tested != null) {
            Throwable testEx;
            testExClass = tested.getClass();
            exMatched = expected.isAssignableFrom(testExClass);
            if (!exMatched && (testEx = tested.getCause()) != null) {
                testExClass = testEx.getClass();
                exMatched = expected.isAssignableFrom(testExClass);
            }
        } else {
            exMatched = false;
        }
        return exMatched;
    }

    protected DBType getDBType(EntityManager em) {
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)this.getConfiguration(em);
        String dictClassName = this.getConfiguration(em).getDBDictionaryInstance().getClass().getName();
        String db = conf.dbdictionaryPlugin.alias(dictClassName);
        return DBType.valueOf(db);
    }

    protected JDBCConfiguration getConfiguration(EntityManager em) {
        return (JDBCConfiguration)((OpenJPAEntityManager)em).getConfiguration();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act;

        static {
            $SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act = new int[Act.values().length];
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.CreateEm.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.CloseEm.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Clear.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Flush.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Find.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.FindWithLock.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.FindObject.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.NamedQueryWithLock.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Persist.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Remove.ordinal()] = 10;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Refresh.ordinal()] = 11;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.RefreshWithLock.ordinal()] = 12;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.RefreshObject.ordinal()] = 13;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Lock.ordinal()] = 14;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.LockObject.ordinal()] = 15;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.UpdateEmployee.ordinal()] = 16;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Detach.ordinal()] = 17;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.StartTx.ordinal()] = 18;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.CommitTx.ordinal()] = 19;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.RollbackTx.ordinal()] = 20;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.NewThread.ordinal()] = 21;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.StartThread.ordinal()] = 22;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Notify.ordinal()] = 23;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Wait.ordinal()] = 24;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.EmployeeNotNull.ordinal()] = 25;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.TestEmployee.ordinal()] = 26;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.SaveVersion.ordinal()] = 27;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.TestVersion.ordinal()] = 28;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.TestLockMode.ordinal()] = 29;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.ResetException.ordinal()] = 30;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.TestException.ordinal()] = 31;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.WaitAllChildren.ordinal()] = 32;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.JoinParent.ordinal()] = 33;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.YieldThread.ordinal()] = 34;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Sleep.ordinal()] = 35;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.DetachSerialize.ordinal()] = 36;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Info.ordinal()] = 37;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Warn.ordinal()] = 38;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Error.ordinal()] = 39;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Trace.ordinal()] = 40;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$openjpa$persistence$lockmgr$SequencedActionsTest$Act[Act.Test.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected static enum DBType {
        access,
        db2,
        derby,
        empress,
        foxpro,
        h2,
        hsql,
        informix,
        ingres,
        jdatastore,
        mariadb,
        mysql,
        oracle,
        pointbase,
        postgres,
        sqlserver,
        sybase;

    }

    class PlatformSpeedTestThread
    extends Thread {
        long loopCnt = 0L;

        PlatformSpeedTestThread() {
        }

        public long getLoopCnt() {
            return this.loopCnt;
        }

        @Override
        public synchronized void run() {
            do {
                ++this.loopCnt;
            } while (!this.isInterrupted());
        }
    }

    private class TestThread
    extends Thread {
        private int threadToRun;
        private Object[][][] actions;
        private Map<Integer, LockEmployee> employees = null;
        public Throwable throwable = null;
        public Error assertError = null;
        public boolean systemRolledback = false;

        public TestThread(int threadToRun, Object[][] ... actions) {
            SequencedActionsTest.this.getLog().trace((Object)("create thread " + threadToRun));
            this.threadToRun = threadToRun;
            this.actions = actions;
            this.employees = new HashMap<Integer, LockEmployee>();
        }

        public synchronized void notifyThread() {
            this.notify();
        }

        @Override
        public synchronized void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SequencedActionsTest.this.getLog().trace((Object)("Thread " + this.threadToRun + ": run()"));
            SequencedActionsTest.this.launchCommonSequence(this);
        }

        static /* synthetic */ Object[][][] access$100(TestThread x0) {
            return x0.actions;
        }

        static /* synthetic */ Map access$200(TestThread x0) {
            return x0.employees;
        }
    }

    protected static enum Act {
        CreateEm,
        CloseEm,
        Find,
        FindWithLock,
        FindObject,
        NamedQueryWithLock,
        Refresh,
        RefreshWithLock,
        RefreshObject,
        Lock,
        LockObject,
        Persist,
        Clear,
        Flush,
        Remove,
        UpdateEmployee,
        Detach,
        StartTx,
        CommitTx,
        RollbackTx,
        NewThread,
        StartThread,
        Notify,
        Wait,
        WaitAllChildren,
        JoinParent,
        YieldThread,
        Sleep,
        Info,
        Trace,
        Error,
        Warn,
        DetachSerialize,
        TestException,
        ResetException,
        TestEmployee,
        EmployeeNotNull,
        SaveVersion,
        TestVersion,
        TestLockMode,
        Test;

    }
}

