/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lock.extended;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lock.extended.LSEBase;
import org.apache.openjpa.persistence.lock.extended.LSEEleCol;
import org.apache.openjpa.persistence.lock.extended.LSEEleColEgr;
import org.apache.openjpa.persistence.lock.extended.LSEJoinAbs;
import org.apache.openjpa.persistence.lock.extended.LSEJoinCon;
import org.apache.openjpa.persistence.lock.extended.LSESecTbl;
import org.apache.openjpa.persistence.lock.extended.LSESngTblAbs;
import org.apache.openjpa.persistence.lock.extended.LSESngTblCon;
import org.apache.openjpa.persistence.lock.extended.LockScopeTestCase;

public class TestBasicLockScope
extends LockScopeTestCase {
    @Override
    public void setUp() {
        this.setSupportedDatabases(DerbyDictionary.class, OracleDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        this.setUp(LSEBase.class, LSESecTbl.class, LSESngTblCon.class, LSESngTblAbs.class, LSEJoinCon.class, LSEJoinAbs.class, LSEEleCol.class, LSEEleColEgr.class, "openjpa.LockManager", "mixed", "openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        this.commonSetUp(LSEBase.class, LSESecTbl.class, LSESngTblCon.class, LSESngTblAbs.class, LSEJoinCon.class, LSEJoinAbs.class, LSEEleCol.class, LSEEleColEgr.class);
    }

    public void testNormalBasicLock() {
        this.commonBasicLock("testNormalBasicLock", 0, false);
    }

    public void testExtendedBasicLock() {
        this.commonBasicLock("testExtendedBasicLock", 8, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonBasicLock(String testName, int id0, boolean extended) {
        String tableName = "LSEBase";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int id1 = id0 + 1;
        LSEBase e0 = new LSEBase();
        e0.setId(id0);
        e0.setFirstName("firstName " + id0);
        e0.setLastName("lastName " + id0);
        LSEBase e1 = new LSEBase();
        e1.setId(id1);
        e1.setFirstName("firstName " + id1);
        e1.setLastName("lastName " + id1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e0);
            em.persist((Object)e1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSEBase.class, id0, extended, "SELECT c FROM LSEBase c WHERE c.firstName LIKE :firstName", "findLSEBase" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEBase.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalSecTableLock() {
        this.commonSecTableLock("testNormalSecTableLock", 100, false);
    }

    public void testExtendedSecTableLock() {
        this.commonSecTableLock("testExtendedSecTableLock", 110, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonSecTableLock(String testName, int id0, boolean extended) {
        String table1Name = "LSESecTbl";
        String table2Name = "LSESecTblDtl";
        String joinTables = "LSESecTbl.*JOIN.*LSESecTblDtl";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int id1 = id0 + 1;
        LSESecTbl e0 = new LSESecTbl();
        e0.setId(id0);
        e0.setFirstName("firstName " + id0);
        e0.setLastName("lastName " + id0);
        LSESecTbl e1 = new LSESecTbl();
        e1.setId(id1);
        e1.setFirstName("firstName " + id1);
        e1.setLastName("lastName " + id1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e0);
            em.persist((Object)e1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSESecTbl.class, id0, extended, "SELECT c FROM LSESecTbl c WHERE c.firstName LIKE :firstName", "findLSESecTbl" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSESecTbl.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSESecTblDtl.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSESecTbl.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSESecTblDtl.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSESecTbl.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSESecTblDtl.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESecTbl.*JOIN.*LSESecTblDtl.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalSingleTableLock() {
        this.commonSingleTableLock("testNormalSingleTableLock", 200, false);
    }

    public void testExtendedlSingleTableLock() {
        this.commonSingleTableLock("testExtendedlSingleTableLock", 210, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonSingleTableLock(String testName, int id0, boolean extended) {
        String tableName = "LSESngTblAbs";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int id1 = id0 + 1;
        LSESngTblCon e0 = new LSESngTblCon();
        e0.setId(id0);
        e0.setFirstName("firstName " + id0);
        e0.setLastName("lastName " + id0);
        LSESngTblCon e1 = new LSESngTblCon();
        e1.setId(id1);
        e1.setFirstName("firstName " + id1);
        e1.setLastName("lastName " + id1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e0);
            em.persist((Object)e1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSESngTblCon.class, id0, extended, "SELECT c FROM LSESngTblAbs c WHERE c.firstName LIKE :firstName", "findLSESngTblCon" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSESngTblAbs.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalJoinedLock() {
        this.commonJoinedLock("testNormalJoinedLock", 400, false);
    }

    public void testExtendedJoinedLock() {
        this.commonJoinedLock("testExtendedJoinedLock", 410, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonJoinedLock(String testName, int id0, boolean extended) {
        String table1Name = "LSEJoinCon";
        String table2Name = "LSEJoinAbs";
        String joinTables = "LSEJoinCon.*JOIN.*LSEJoinAbs";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int id1 = id0 + 1;
        LSEJoinCon e0 = new LSEJoinCon();
        e0.setId(id0);
        e0.setFirstName("firstName " + id0);
        e0.setLastName("lastName " + id0);
        LSEJoinCon e1 = new LSEJoinCon();
        e1.setId(id1);
        e1.setFirstName("firstName " + id1);
        e1.setLastName("lastName " + id1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e0);
            em.persist((Object)e1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSEJoinCon.class, id0, extended, "SELECT c FROM LSEJoinCon c WHERE c.firstName LIKE :firstName", "findLSEJoinCon" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSEJoinAbs.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSEJoinAbs.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSEJoinAbs.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEJoinCon.*JOIN.*LSEJoinAbs.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalElementCollectionLock() {
        this.commonElementCollectionLock("testNormalElementCollectionLock", 500, false);
    }

    public void testExtendedElementCollectionLock() {
        this.commonElementCollectionLock("testExtendedElementCollectionLock", 510, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonElementCollectionLock(String testName, int id0, boolean extended) {
        String tableName = "LSEEleCol";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int id1 = id0 + 1;
        LSEEleCol e0 = new LSEEleCol();
        e0.setId(id0);
        e0.setFirstName("firstName lazy " + id0);
        e0.addCollection(id0 + "String1");
        e0.addCollection(id0 + "String2");
        LSEEleCol e1 = new LSEEleCol();
        e1.setId(id1);
        e1.setFirstName("lazy " + id1);
        e1.addCollection(id1 + "String1");
        e1.addCollection(id1 + "String2");
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e0);
            em.persist((Object)e1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSEEleCol.class, id0, extended, "SELECT c FROM LSEEleCol c WHERE c.firstName LIKE :firstName", "findLSEEleCol" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleCol.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalElementCollectionEagerLock() {
        this.commonElementCollectionEagerLock("testNormalElementCollectionEagerLock", 600, false);
    }

    public void testExtendedElementCollectionEagerLock() {
        this.commonElementCollectionEagerLock("testExtendedElementCollectionEagerLock", 610, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonElementCollectionEagerLock(String testName, int id0, boolean extended) {
        String table1Name = "LSEEleColEgr";
        String table2Name = "LSEEleColEgr_collection";
        String joinTables = "LSEEleColEgr.*JOIN.*LSEEleColEgr_collection";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int id1 = id0 + 1;
        LSEEleColEgr e0 = new LSEEleColEgr();
        e0.setId(id0);
        e0.setFirstName("firstName eager " + id0);
        e0.addCollection(id0 + "String1");
        e0.addCollection(id0 + "String2");
        LSEEleColEgr e1 = new LSEEleColEgr();
        e1.setId(id1);
        e1.setFirstName("firstName eager " + id1);
        e1.addCollection(id1 + "String1");
        e1.addCollection(id1 + "String2");
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e0);
            em.persist((Object)e1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSEEleColEgr.class, id0, extended, "SELECT c FROM LSEEleColEgr c WHERE c.firstName LIKE :firstName", "findLSEEleColEgr" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*LSEEleColEgr_collection.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*LSEEleColEgr_collection.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*LSEEleColEgr.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*LSEEleColEgr.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*LSEEleColEgr_collection.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*LSEEleColEgr.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (TestBasicLockScope.this.getDBType(em)) {
                    case db2: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*LSEEleColEgr_collection.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        TestBasicLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSEEleColEgr.*JOIN.*LSEEleColEgr_collection.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }
}

