/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lock.extended;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lock.extended.LSE1xmLf;
import org.apache.openjpa.persistence.lock.extended.LSE1xmLfEgr;
import org.apache.openjpa.persistence.lock.extended.LSE1xmLfJT;
import org.apache.openjpa.persistence.lock.extended.LSE1xmLfJTEgr;
import org.apache.openjpa.persistence.lock.extended.LSE1xmRt;
import org.apache.openjpa.persistence.lock.extended.LockScopeTestCase;

public class Test1xmLockScope
extends LockScopeTestCase {
    @Override
    public void setUp() {
        this.setSupportedDatabases(DerbyDictionary.class, OracleDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        this.setUp(LSE1xmLf.class, LSE1xmLfEgr.class, LSE1xmLfJT.class, LSE1xmLfJTEgr.class, LSE1xmRt.class, "openjpa.LockManager", "mixed", "openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        this.commonSetUp(LSE1xmLf.class, LSE1xmLfEgr.class, LSE1xmLfJT.class, LSE1xmLfJTEgr.class, LSE1xmRt.class);
    }

    public void testNormalUni1xmLock() {
        this.common1xmLock("testNormalUni1xmLock", 2111101, false);
    }

    public void testExtendedUni1xmLock() {
        this.common1xmLock("testExtendedUni1xmLock", 2111111, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1xmLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1xmLf";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt00 = idLf0 + 10000;
        int idRt01 = idRt00 + 1;
        int idLf1 = idLf0 + 1;
        int idRt10 = idLf1 + 10000 + 1;
        int idRt11 = idRt10 + 1;
        LSE1xmLf eLf0 = new LSE1xmLf();
        LSE1xmRt eRt00 = new LSE1xmRt();
        LSE1xmRt eRt01 = new LSE1xmRt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.addUnitRight(eRt00);
        eLf0.addUnitRight(eRt01);
        eRt00.setId(idRt00);
        eRt00.setLastName("lastName " + idRt00);
        eRt01.setId(idRt01);
        eRt01.setLastName("lastName " + idRt01);
        LSE1xmLf eLf1 = new LSE1xmLf();
        LSE1xmRt eRt10 = new LSE1xmRt();
        LSE1xmRt eRt11 = new LSE1xmRt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.addUnitRight(eRt10);
        eLf1.addUnitRight(eRt11);
        eRt10.setId(idRt10);
        eRt10.setLastName("lastName " + idRt10);
        eRt11.setId(idRt11);
        eRt11.setLastName("lastName " + idRt11);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eRt00);
            em.persist((Object)eRt01);
            em.persist((Object)eLf0);
            em.persist((Object)eRt10);
            em.persist((Object)eRt11);
            em.persist((Object)eLf1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt11 = null;
            eRt10 = null;
            eRt01 = null;
            eRt00 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1xmLf.class, idLf0, extended, "SELECT c FROM LSE1xmLf c WHERE c.firstName LIKE :firstName", "findLSE1xmLf" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLf.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalUni1xmEagerLock() {
        this.common1xmEagerLock("testNormalUni1xmEagerLock", 2111201, false);
    }

    public void testExtendedUni1xmEagerLock() {
        this.common1xmEagerLock("testExtendedUni1xmEagerLock", 2111211, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1xmEagerLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1xmLfEgr";
        String tableJTName = "LSE1xmLfEgr_LSE1xmRt";
        String tableRtName = "LSE1xmRt";
        String joinTables = "LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt00 = idLf0 + 10000;
        int idRt01 = idRt00 + 1;
        int idLf1 = idLf0 + 1;
        int idRt10 = idLf1 + 10000 + 1;
        int idRt11 = idRt10 + 1;
        LSE1xmLfEgr eLf0 = new LSE1xmLfEgr();
        LSE1xmRt eRt00 = new LSE1xmRt();
        LSE1xmRt eRt01 = new LSE1xmRt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.addUnitRight(eRt00);
        eLf0.addUnitRight(eRt01);
        eRt00.setId(idRt00);
        eRt00.setLastName("lastName " + idRt00);
        eRt01.setId(idRt01);
        eRt01.setLastName("lastName " + idRt01);
        LSE1xmLfEgr eLf1 = new LSE1xmLfEgr();
        LSE1xmRt eRt10 = new LSE1xmRt();
        LSE1xmRt eRt11 = new LSE1xmRt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.addUnitRight(eRt10);
        eLf1.addUnitRight(eRt11);
        eRt10.setId(idRt10);
        eRt10.setLastName("lastName " + idRt10);
        eRt11.setId(idRt11);
        eRt11.setLastName("lastName " + idRt11);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eRt00);
            em.persist((Object)eRt01);
            em.persist((Object)eLf0);
            em.persist((Object)eRt10);
            em.persist((Object)eRt11);
            em.persist((Object)eLf1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt11 = null;
            eRt10 = null;
            eRt01 = null;
            eRt00 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1xmLfEgr.class, idLf0, extended, "SELECT c FROM LSE1xmLfEgr c WHERE c.firstName LIKE :firstName", "findLSE1xmLfEgr" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*LSE1xmLfEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*LSE1xmLfEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmLfEgr.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1xmLfEgr.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}LSE1xmLfEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*LSE1xmLfEgr.*LSE1xmLfEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}LSE1xmLfEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*LSE1xmLfEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1xmLfEgr.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}LSE1xmLfEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*LSE1xmLfEgr.*LSE1xmLfEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}LSE1xmLfEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*LSE1xmLfEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfEgr.*JOIN.*LSE1xmLfEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalUni1xmJTLock() {
        this.common1xmJTLock("testNormalUni1xmJTLock", 2112101, false);
    }

    public void testExtendedUni1xmJTLock() {
        this.common1xmJTLock("testExtendedUni1xmJTLock", 2112111, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1xmJTLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1xmLfJT";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt00 = idLf0 + 10000;
        int idRt01 = idRt00 + 1;
        int idLf1 = idLf0 + 1;
        int idRt10 = idLf1 + 10000 + 1;
        int idRt11 = idRt10 + 1;
        LSE1xmLfJT eLf0 = new LSE1xmLfJT();
        LSE1xmRt eRt00 = new LSE1xmRt();
        LSE1xmRt eRt01 = new LSE1xmRt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.addUnitRight(eRt00);
        eLf0.addUnitRight(eRt01);
        eRt00.setId(idRt00);
        eRt00.setLastName("lastName " + idRt00);
        eRt01.setId(idRt01);
        eRt01.setLastName("lastName " + idRt01);
        LSE1xmLfJT eLf1 = new LSE1xmLfJT();
        LSE1xmRt eRt10 = new LSE1xmRt();
        LSE1xmRt eRt11 = new LSE1xmRt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.addUnitRight(eRt10);
        eLf1.addUnitRight(eRt11);
        eRt10.setId(idRt10);
        eRt10.setLastName("lastName " + idRt10);
        eRt11.setId(idRt11);
        eRt11.setLastName("lastName " + idRt11);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eRt00);
            em.persist((Object)eRt01);
            em.persist((Object)eLf0);
            em.persist((Object)eRt10);
            em.persist((Object)eRt11);
            em.persist((Object)eLf1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt11 = null;
            eRt10 = null;
            eRt01 = null;
            eRt00 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1xmLfJT.class, idLf0, extended, "SELECT c FROM LSE1xmLfJT c WHERE c.firstName LIKE :firstName", "findLSE1xmLfJT" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJT.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalUni1xmJTEagerLock() {
        this.common1xmJTEagerLock("testNormalUni1xmJTEagerLock", 2112201, false);
    }

    public void testExtendedUni1xmJTEagerLock() {
        this.common1xmJTEagerLock("testExtendedUni1xmJTEagerLock", 2112211, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1xmJTEagerLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1xmLfJTEgr";
        String tableJTName = "LSE1xmLfJTEgr_LSE1xmRt";
        String tableRtName = "LSE1xmRt";
        String joinTables = "LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt00 = idLf0 + 10000;
        int idRt01 = idRt00 + 1;
        int idLf1 = idLf0 + 1;
        int idRt10 = idLf1 + 10000 + 1;
        int idRt11 = idRt10 + 1;
        LSE1xmLfJTEgr eLf0 = new LSE1xmLfJTEgr();
        LSE1xmRt eRt00 = new LSE1xmRt();
        LSE1xmRt eRt01 = new LSE1xmRt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.addUnitRight(eRt00);
        eLf0.addUnitRight(eRt01);
        eRt00.setId(idRt00);
        eRt00.setLastName("lastName " + idRt00);
        eRt01.setId(idRt01);
        eRt01.setLastName("lastName " + idRt01);
        LSE1xmLfJTEgr eLf1 = new LSE1xmLfJTEgr();
        LSE1xmRt eRt10 = new LSE1xmRt();
        LSE1xmRt eRt11 = new LSE1xmRt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.addUnitRight(eRt10);
        eLf1.addUnitRight(eRt11);
        eRt10.setId(idRt10);
        eRt10.setLastName("lastName " + idRt10);
        eRt11.setId(idRt11);
        eRt11.setLastName("lastName " + idRt11);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eRt00);
            em.persist((Object)eRt01);
            em.persist((Object)eLf0);
            em.persist((Object)eRt10);
            em.persist((Object)eRt11);
            em.persist((Object)eLf1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt11 = null;
            eRt10 = null;
            eRt01 = null;
            eRt00 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1xmLfJTEgr.class, idLf0, extended, "SELECT c FROM LSE1xmLfJTEgr c WHERE c.firstName LIKE :firstName", "findLSE1xmLfJTEgr" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*LSE1xmLfJTEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*LSE1xmLfJTEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmLfJTEgr.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1xmLfJTEgr.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}LSE1xmLfJTEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*LSE1xmLfJTEgr.*LSE1xmLfJTEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}LSE1xmLfJTEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*LSE1xmLfJTEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1xmLfJTEgr.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*FROM.*(JOIN){0}.*LSE1xmRt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*(JOIN){0}LSE1xmLfJTEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*LSE1xmLfJTEgr.*LSE1xmLfJTEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*LSE1xmLfJTEgr(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*FROM.*(JOIN){0}LSE1xmRt(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1xmLockScope.this.getDBType(em)) {
                    case db2: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*LSE1xmLfJTEgr_LSE1xmRt.*LSE1xmRt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1xmLockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1xmLfJTEgr.*JOIN.*LSE1xmLfJTEgr_LSE1xmRt.*JOIN.*LSE1xmRt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }
}

