/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lock.extended;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PessimisticLockScope;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.MixedLockLevelsHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public abstract class LockScopeTestCase
extends SQLListenerTestCase {
    protected final String Any = ".*";
    protected final String Select = "SELECT.*FROM.*";
    protected final String SelectVersion = "SELECT.*version.*FROM.*";
    protected final String Where = ".*WHERE.*";
    protected final String NoJoin = "(JOIN){0}";
    protected final String ForUpdateRex = "FOR UPDATE.*";
    protected final String ForUpdateClause = "(FOR UPDATE.*)";
    protected final String ForUpdate = "(FOR UPDATE.*){1}";
    protected final String NoForUpdate = "(FOR UPDATE.*){0}";
    protected final String DB2LockClause = "(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS)";
    protected final String DB2Lock = "(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}";
    protected final String NoDB2Lock = "(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}";
    protected List<String> empTableName = new ArrayList<String>();
    protected Map<String, Object> normalProps;
    protected Map<String, Object> extendedProps;

    @Override
    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    protected void commonSetUp(Class<?> ... eClasses) {
        this.normalProps = new HashMap<String, Object>();
        this.extendedProps = new HashMap<String, Object>();
        this.extendedProps.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED);
        for (Class<?> eClazz : eClasses) {
            this.empTableName.add(this.getMapping(eClazz).getTable().getFullName());
        }
        this.cleanupDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDB() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            for (String tableName : this.empTableName.toArray(new String[this.empTableName.size()])) {
                em.createQuery("delete from " + tableName).executeUpdate();
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    protected DBType getDBType(EntityManager em) {
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)this.getConfiguration(em);
        String dictClassName = this.getConfiguration(em).getDBDictionaryInstance().getClass().getName();
        String db = conf.dbdictionaryPlugin.alias(dictClassName);
        return DBType.valueOf(db);
    }

    protected JDBCConfiguration getConfiguration(EntityManager em) {
        return (JDBCConfiguration)((OpenJPAEntityManager)em).getConfiguration();
    }

    @Override
    protected Log getLog() {
        return this.emf.getConfiguration().getLog("Tests");
    }

    protected Log getDumpStackLog() {
        return this.emf.getConfiguration().getLog("DumpStack");
    }

    protected Log getDumpSQLLog() {
        return this.emf.getConfiguration().getLog("LockTestSQL");
    }

    public void assertLockTestSQLs(String ... expected) {
        Log log = this.getDumpSQLLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)("\r\n" + this.toString(this.sql)));
            return;
        }
        this.assertAllSQLAnyOrder(expected);
    }

    public void assertLockTestNoSQLs(String ... expected) {
        Log log = this.getDumpSQLLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)("\r\n" + this.toString(this.sql)));
            return;
        }
        this.assertNoneSQLAnyOrder(expected);
    }

    protected void logStack(Throwable t) {
        StringWriter str = new StringWriter();
        PrintWriter print = new PrintWriter(str);
        t.printStackTrace(print);
        this.getDumpStackLog().trace((Object)str.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void commonLockTest(String testName, Class<T> type, int id0, boolean extended, String queryString, String namedQueryString, AssertCallback verify) {
        List es;
        Query q;
        LockModeType beforeReadMode;
        int beforeReadLevel;
        this.getLog().info((Object)("** " + testName + "()"));
        String entityName = type.getName();
        String scope = extended ? "Extended" : "Normal";
        Map<String, Object> props = extended ? this.extendedProps : this.normalProps;
        int id1 = id0 + 1;
        OpenJPAEntityManagerSPI em = null;
        Object e0 = null;
        Object e1 = null;
        try {
            this.getLog().info((Object)("-- Test find with no lock in " + scope + " scope"));
            em = this.emf.createEntityManager();
            this.getLog().info((Object)" *Begin a transaction.");
            em.getTransaction().begin();
            this.resetSQL();
            this.getLog().info((Object)(" *Find " + entityName + "(" + id0 + ") with no lock"));
            e0 = em.find(type, (Object)id0, props);
            this.getLog().info((Object)(" *" + (e0 != null ? "F" : "Can not f") + "ind entity"));
            verify.findNoLockDbSQL((EntityManager)em);
            this.getLog().info((Object)(" *Found entity:" + e0));
            LockScopeTestCase.assertNotNull((String)(" *Found " + entityName + "(" + id0 + ")"), (Object)e0);
            LockScopeTestCase.assertEquals((String)" *Assert no lock applied", (Object)LockModeType.NONE, (Object)em.getLockMode(e0));
            this.getLog().info((Object)(" *Find " + entityName + "(" + id1 + ") with pessimistic force increment lock"));
            this.resetSQL();
            e1 = em.find(type, (Object)id1, LockModeType.PESSIMISTIC_FORCE_INCREMENT, props);
            this.getLog().info((Object)(" *" + (e1 != null ? "F" : "Can not f") + "ind entity"));
            verify.findPessimisticForcIncDbSQL((EntityManager)em);
            this.getLog().info((Object)(" *Found entity:" + e1));
            LockScopeTestCase.assertNotNull((String)(" *Found " + entityName + "(" + id1 + ")"), (Object)e1);
            LockScopeTestCase.assertEquals((String)" *Assert pessimistic force increment lock applied", (Object)LockModeType.PESSIMISTIC_FORCE_INCREMENT, (Object)em.getLockMode(e1));
            this.getLog().info((Object)"Committing transaction.");
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        try {
            this.getLog().info((Object)("-- Test query with pessimistic read lock in " + scope + " scope"));
            em = this.emf.createEntityManager();
            this.getLog().info((Object)" *Begin a transaction.");
            em.getTransaction().begin();
            this.resetSQL();
            beforeReadLevel = this.getConfiguration((EntityManager)em).getReadLockLevelConstant();
            beforeReadMode = MixedLockLevelsHelper.fromLockLevel((int)beforeReadLevel);
            this.getLog().info((Object)(" *Save ReadLockLevel before Query:" + beforeReadMode));
            this.getLog().info((Object)(" *Query " + entityName + "(" + id0 + ") with PESSIMISTIC_READ lock"));
            q = em.createQuery(queryString);
            if (extended) {
                q = q.setHint("javax.persistence.lock.scope", (Object)PessimisticLockScope.EXTENDED);
            }
            q = q.setLockMode(LockModeType.PESSIMISTIC_READ);
            q = q.setParameter("firstName", (Object)("firstName%" + id0));
            es = q.getResultList();
            this.getLog().info((Object)(" *Found " + es.size() + " entity"));
            LockScopeTestCase.assertEquals((String)" *Should find 1 entity", (int)es.size(), (int)1);
            verify.queryPessimisticReadDbSQL((EntityManager)em);
            e0 = es.get(0);
            this.getLog().info((Object)(" *Found entity:" + e0));
            LockScopeTestCase.assertNotNull((String)(" *Found " + entityName + "(" + id0 + ")"), (Object)e0);
            LockScopeTestCase.assertEquals((String)"Assert pessimistic read lock applied", (Object)LockModeType.PESSIMISTIC_READ, (Object)em.getLockMode(e0));
            LockScopeTestCase.assertEquals((String)(" *Read lock should still be " + beforeReadMode + "after query set lock mode"), (int)beforeReadLevel, (int)this.getConfiguration((EntityManager)em).getReadLockLevelConstant());
            this.getLog().info((Object)(" *Find " + entityName + "(" + id1 + ") with no lock to verify query lock set does not affect em lock mode."));
            this.resetSQL();
            e1 = em.find(type, (Object)id1);
            this.getLog().info((Object)(" *" + (e1 != null ? "F" : "Can not f") + "ind entity"));
            verify.findNoLockAfterQueryPessimisticReadDbSQL((EntityManager)em);
            this.getLog().info((Object)(" *Found entity:" + e1));
            LockScopeTestCase.assertNotNull((String)(" *Found " + entityName + "(" + id1 + ")"), (Object)e1);
            LockScopeTestCase.assertEquals((String)" *Assert default lock applied", (Object)LockModeType.NONE, (Object)em.getLockMode(e1));
            this.getLog().info((Object)"Committing transaction.");
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        try {
            this.getLog().info((Object)("-- Test name query with pessimistic write lock in " + scope + " scope"));
            em = this.emf.createEntityManager();
            this.getLog().info((Object)" *Begin a transaction.");
            em.getTransaction().begin();
            this.resetSQL();
            beforeReadLevel = this.getConfiguration((EntityManager)em).getReadLockLevelConstant();
            beforeReadMode = MixedLockLevelsHelper.fromLockLevel((int)beforeReadLevel);
            this.getLog().info((Object)(" *Save ReadLockLevel before Query:" + beforeReadMode));
            this.getLog().info((Object)(" *Query " + entityName + "(" + id0 + ") with PESSIMISTIC_WRITE lock"));
            q = em.createNamedQuery(namedQueryString);
            if (extended) {
                q = q.setHint("javax.persistence.lock.scope", (Object)PessimisticLockScope.EXTENDED);
            }
            q = q.setParameter("firstName", (Object)("firstName%" + id0));
            es = q.getResultList();
            this.getLog().info((Object)(" *Found " + es.size() + " entity"));
            LockScopeTestCase.assertEquals((String)" *Found 1 entity", (int)es.size(), (int)1);
            verify.namedQueryPessimisticWriteDbSql((EntityManager)em);
            e0 = es.get(0);
            this.getLog().info((Object)(" *Found entity:" + e0));
            LockScopeTestCase.assertNotNull((String)(" *Found " + entityName + "(" + id0 + ")"), (Object)e0);
            LockScopeTestCase.assertEquals((String)"Assert pessimistic write lock applied", (Object)LockModeType.PESSIMISTIC_WRITE, (Object)em.getLockMode(e0));
            this.getLog().info((Object)(" *Ensure ReadLockLevel remains at level " + beforeReadMode));
            LockScopeTestCase.assertEquals((String)(" *Read lock should still be " + beforeReadMode + "after query set lock mode"), (int)beforeReadLevel, (int)this.getConfiguration((EntityManager)em).getReadLockLevelConstant());
            this.getLog().info((Object)(" *Find " + entityName + "(" + id1 + ") with no lock to verify query lock set does not affect em lock mode."));
            this.resetSQL();
            e1 = em.find(type, (Object)id1);
            this.getLog().info((Object)(" *" + (e1 != null ? "F" : "Can not f") + "ind an entity"));
            verify.findNoLockAfterNamedQueryPessimisticWriteDbSql((EntityManager)em);
            this.getLog().info((Object)(" *Found entity:" + e1));
            LockScopeTestCase.assertNotNull((String)(" *Found " + entityName + "(" + id1 + ")"), (Object)e1);
            LockScopeTestCase.assertEquals((String)" *Assert default lock applied", (Object)LockModeType.NONE, (Object)em.getLockMode(e1));
            this.getLog().info((Object)"Committing transaction.");
            em.getTransaction().commit();
        }
        finally {
            em = null;
            e1 = null;
            e0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    protected static interface AssertCallback {
        public void findNoLockDbSQL(EntityManager var1);

        public void findPessimisticForcIncDbSQL(EntityManager var1);

        public void queryPessimisticReadDbSQL(EntityManager var1);

        public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager var1);

        public void namedQueryPessimisticWriteDbSql(EntityManager var1);

        public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager var1);
    }

    protected static enum DBType {
        access,
        db2,
        derby,
        empress,
        foxpro,
        h2,
        hsql,
        informix,
        ingres,
        jdatastore,
        mariadb,
        mysql,
        oracle,
        pointbase,
        postgres,
        sqlserver,
        sybase;

    }
}

