/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.persistence.OpenJPAEnum;

public enum IsolationLevel implements OpenJPAEnum<IsolationLevel>
{
    DEFAULT(-1, "default"),
    NONE(0, "none"),
    READ_UNCOMMITTED(1, "read-uncommitted", "READ_UNCOMMITTED"),
    READ_COMMITTED(2, "read-committed", "READ_COMMITTED"),
    REPEATABLE_READ(4, "repeatable-read", "REPEATABLE_READ"),
    SERIALIZABLE(8, "serializable");

    private final int _connectionConstant;
    private final String[] _names;

    private IsolationLevel(int connectionConstant, String ... names) {
        this._connectionConstant = connectionConstant;
        this._names = names;
    }

    public int getConnectionConstant() {
        return this._connectionConstant;
    }

    public static IsolationLevel fromConnectionConstant(int constant) {
        switch (constant) {
            case -99: 
            case -1: {
                return DEFAULT;
            }
            case 0: {
                return NONE;
            }
            case 1: {
                return READ_UNCOMMITTED;
            }
            case 2: {
                return READ_COMMITTED;
            }
            case 4: {
                return REPEATABLE_READ;
            }
            case 8: {
                return SERIALIZABLE;
            }
        }
        throw new IllegalArgumentException(Integer.valueOf(constant).toString());
    }

    public IsolationLevel fromKernelConstant(int i) {
        return IsolationLevel.fromConnectionConstant(i);
    }

    public int toKernelConstant() {
        return this.getConnectionConstant();
    }

    public static int toKernelConstantFromString(String s) {
        for (IsolationLevel level : IsolationLevel.values()) {
            for (String name : level._names) {
                if (!name.equalsIgnoreCase(s) && !String.valueOf(level.toKernelConstant()).equals(s)) continue;
                return level.toKernelConstant();
            }
        }
        throw new IllegalArgumentException(s + " is not a valid name for " + IsolationLevel.class.getName());
    }

    public int convertToKernelConstant(String s) {
        return IsolationLevel.toKernelConstantFromString(s);
    }

    public int convertToKernelConstant(int i) {
        return IsolationLevel.fromConnectionConstant(i).toKernelConstant();
    }
}

