/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance.stats;

import java.util.Locale;
import org.apache.commons.lang.WordUtils;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.stats.FetchStatsCollector;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;

public class FetchStatisticsAuxEnhancer
implements PCEnhancer.AuxiliaryEnhancer {
    private final String IGNORE_METHODS_REGEX = "(pc(.)*GenericContext)?(pc(.)*StateManager)?(pc(.)*DetachedState)?(pc(.)*EnhancementContractVersion)?(pc(.)*ManagedFieldCount)?(pc(.)*GetVersion)?";

    public void run(BCClass bcc, ClassMetaData cmd) {
        this.addEnhancement(bcc, cmd);
    }

    public boolean skipEnhance(BCMethod arg0) {
        return false;
    }

    private void addEnhancement(BCClass bcc, ClassMetaData cmd) {
        Log log = cmd.getRepository().getConfiguration().getLog("openjpa.Runtime");
        FetchStatsCollector.setlogger(log);
        for (BCMethod meth : bcc.getMethods()) {
            String methodName = meth.getName();
            FieldMetaData fmd = this.getFieldName(methodName, cmd);
            if (fmd == null || !this.needsTracking(fmd, methodName, cmd)) continue;
            String fqn = bcc.getName() + "." + fmd.getName();
            FetchStatsCollector.registerField(fqn);
            FetchStatsCollector.registerEntity(cmd);
            Code code = meth.getCode(false);
            code.constant().setValue(fqn);
            code.invokestatic().setMethod(FetchStatsCollector.class, "hit", Void.TYPE, new Class[]{String.class});
        }
    }

    private boolean needsTracking(FieldMetaData fmd, String methName, ClassMetaData cmd) {
        if (fmd.isPrimaryKey() || fmd.isVersion() || !fmd.isInDefaultFetchGroup()) {
            return false;
        }
        if (AccessCode.isField((FieldMetaData)fmd) && methName.toLowerCase(Locale.ENGLISH).startsWith("pcget")) {
            return true;
        }
        return AccessCode.isProperty((FieldMetaData)fmd) && methName.toLowerCase(Locale.ENGLISH).startsWith("get") || methName.toLowerCase(Locale.ENGLISH).startsWith("pcis");
    }

    private FieldMetaData getFieldName(String methName, ClassMetaData cmd) {
        FieldMetaData res = null;
        String fieldName = null;
        if (methName.matches("(pc(.)*GenericContext)?(pc(.)*StateManager)?(pc(.)*DetachedState)?(pc(.)*EnhancementContractVersion)?(pc(.)*ManagedFieldCount)?(pc(.)*GetVersion)?")) {
            return res;
        }
        if (methName.startsWith("pcGet")) {
            fieldName = methName.substring(5);
        } else if (methName.toLowerCase(Locale.ENGLISH).startsWith("get")) {
            fieldName = WordUtils.uncapitalize((String)methName.substring(3));
        } else if (methName.startsWith("pcis")) {
            fieldName = methName.substring(4).toLowerCase(Locale.ENGLISH);
        }
        for (FieldMetaData fmd : cmd.getDeclaredFields()) {
            String fmdName = fmd.getName();
            if (!fmdName.equals(fieldName)) continue;
            return fmd;
        }
        return null;
    }
}

