/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance.stats;

import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.openjpa.enhance.stats.AEntity;
import org.apache.openjpa.enhance.stats.BEntity;
import org.apache.openjpa.enhance.stats.ChildEntity;
import org.apache.openjpa.enhance.stats.FetchStatsCollector;

public class TestFetchStatistics
extends TestCase {
    public TestFetchStatistics(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(TestFetchStatistics.class);
    }

    public void setUp() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"fetchStatisticPU");
        emf.createEntityManager().close();
        FetchStatsCollector.clear();
    }

    public void tearDown() {
    }

    public void testFieldAccess() {
        FetchStatsCollector.clear();
        AEntity aEntity = new AEntity(1, "t", "d", null);
        Set res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.AEntity.name"));
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.AEntity.desc"));
        TestFetchStatistics.assertEquals((String)"td", (String)aEntity.getFullInfo());
        res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.AEntity.name"));
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.AEntity.desc"));
    }

    public void testEmbeddedEntityFieldAccess() {
        AEntity aEntity = new AEntity(1, "t1", "d1", null);
        TestFetchStatistics.assertEquals((String)"extra d1", (String)aEntity.getExtraInfo());
        Set res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.AEntity.extraInfo"));
    }

    public void testPropertyFieldMixedAccess() {
        FetchStatsCollector.clear();
        BEntity b = new BEntity(2, "t2", "d2");
        Set res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertTrue((String)res.toString(), (boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.name"));
        TestFetchStatistics.assertTrue((String)res.toString(), (boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.bool"));
        b.getName();
        b.isBool();
        res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.name"));
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.bool"));
    }

    public void testMixedAccess() {
        BEntity e = new BEntity(1, "t1", "d1");
        Set res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.name"));
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.desc"));
        e.getName();
        e.getCustomDesc();
        res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.name"));
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.desc"));
    }

    public void testFieldAccessThroughRelationship() {
        BEntity bf1 = new BEntity(1, "t1", "d1");
        AEntity af3 = new AEntity(3, "t3", "d3", bf1);
        TestFetchStatistics.assertEquals((String)"t1", (String)af3.getReferredBEntityName());
        af3.isChecked();
        Set res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.AEntity.checked"));
    }

    public void testPropertyAccessThroughInheritance() {
        FetchStatsCollector.clear();
        ChildEntity cEntity = new ChildEntity(1, "t1", "d1", "cn1");
        Set res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.ChildEntity.childName"));
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.name"));
        TestFetchStatistics.assertTrue((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.desc"));
        cEntity.getChildName();
        cEntity.getName();
        cEntity.getCustomDesc();
        res = FetchStatsCollector.getStatistics();
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.ChildEntity.childName"));
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.name"));
        TestFetchStatistics.assertFalse((boolean)res.contains("org.apache.openjpa.enhance.stats.BEntity.desc"));
    }

    public void _testOutputInterval() throws InterruptedException {
        Thread.currentThread();
        Thread.sleep(3600000L);
    }
}

