/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.telnet;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.openejb.server.telnet.Exit;
import org.apache.openejb.server.telnet.GroovySh;
import org.apache.openejb.server.telnet.Help;
import org.apache.openejb.server.telnet.Lookup;
import org.apache.openejb.server.telnet.Ls;
import org.apache.openejb.server.telnet.Stop;
import org.apache.openejb.server.telnet.Version;

public class Command {
    protected static final HashMap<String, Object> commands = new HashMap();
    protected static final Command unknownCommand;

    protected static void register(String name, Command cmd) {
        commands.put(name, cmd);
    }

    protected static void register(String name, Class cmd) {
        commands.put(name, cmd);
    }

    public static Command getCommand(String name) {
        Object cmd = commands.get(name);
        if (cmd instanceof Class) {
            cmd = Command.loadCommand((Class)cmd);
            Command.register(name, (Command)cmd);
        }
        return (Command)cmd;
    }

    public void exec(Arguments args, DataInputStream in, PrintStream out) throws IOException {
        out.println("not implemented");
    }

    protected static Command loadCommand(Class commandClass) {
        Command cmd = null;
        try {
            cmd = (Command)commandClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    protected static void loadCommandList() {
        Exit.register();
        Help.register();
        Lookup.register();
        Ls.register();
        Stop.register();
        Version.register();
        GroovySh.register();
    }

    static {
        Command.loadCommandList();
        unknownCommand = new Command();
    }

    public static class Arguments {
        private String args;
        private String[] argsArray = new String[0];
        private boolean alreadyParsed = false;

        Arguments(String args) {
            this.args = args;
        }

        String get() {
            return this.args;
        }

        String get(int i) {
            this.parseArgs();
            return this.argsArray != null ? this.argsArray[i] : null;
        }

        int count() {
            this.parseArgs();
            return this.argsArray != null ? this.argsArray.length : 0;
        }

        Iterator iterator() {
            return new Iterator(){
                StringTokenizer st;
                {
                    this.st = new StringTokenizer(Arguments.this.args);
                }

                public boolean hasNext() {
                    return this.st.hasMoreTokens();
                }

                public Object next() {
                    return this.st.nextToken();
                }

                public void remove() {
                }
            };
        }

        private void parseArgs() {
            if (!this.alreadyParsed) {
                ArrayList arrayList = new ArrayList();
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    arrayList.add(it.next());
                }
                this.argsArray = arrayList.toArray(this.argsArray);
                this.alreadyParsed = true;
            }
        }
    }
}

