/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.telnet;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.ejb.EJBHome;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.telnet.Command;
import org.apache.openejb.spi.ContainerSystem;

public class Lookup
extends Command {
    Context ctx;
    static String PWD = "";

    public Lookup() {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.ctx = containerSystem.getJNDIContext();
    }

    public static void register() {
        Lookup cmd = new Lookup();
        Command.register("lookup", cmd);
    }

    public void exec(Command.Arguments args, DataInputStream in, PrintStream out) throws IOException {
        try {
            String name = "";
            name = args == null || args.count() == 0 ? PWD : args.get();
            Object obj = null;
            try {
                obj = this.ctx.lookup(name);
            }
            catch (NameNotFoundException e) {
                out.print("lookup: ");
                out.print(name);
                out.println(": No such object or subcontext");
                return;
            }
            catch (Throwable e) {
                out.print("lookup: error: ");
                e.printStackTrace(new PrintStream(out));
                return;
            }
            if (obj instanceof Context) {
                this.list(name, in, out);
                return;
            }
            out.println("" + obj);
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream(out));
        }
    }

    public void list(String name, DataInputStream in, PrintStream out) throws IOException {
        try {
            NamingEnumeration<NameClassPair> enumeration = null;
            try {
                enumeration = this.ctx.list(name);
            }
            catch (NameNotFoundException e) {
                out.print("lookup: ");
                out.print(name);
                out.println(": No such object or subcontext");
                return;
            }
            catch (Throwable e) {
                out.print("lookup: error: ");
                e.printStackTrace(new PrintStream(out));
                return;
            }
            if (enumeration == null) {
                return;
            }
            while (enumeration.hasMore()) {
                NameClassPair entry = enumeration.next();
                String eName = entry.getName();
                Class eClass = null;
                if (IvmContext.class.getName().equals(entry.getClassName())) {
                    eClass = IvmContext.class;
                } else {
                    try {
                        ClassLoader cl = ClassLoaderUtil.getContextClassLoader();
                        eClass = Class.forName(entry.getClassName(), true, cl);
                    }
                    catch (Throwable t) {
                        eClass = Object.class;
                    }
                }
                if (Context.class.isAssignableFrom(eClass)) {
                    out.print("\u001b[1m");
                    out.print("\u001b[34m");
                    out.print(entry.getName());
                    out.print("\u001b[0m");
                } else if (EJBHome.class.isAssignableFrom(eClass)) {
                    out.print("\u001b[1m");
                    out.print("\u001b[32m");
                    out.print(entry.getName());
                    out.print("\u001b[0m");
                } else {
                    out.print(entry.getName());
                }
                out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream(out));
        }
    }
}

