/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.naming.Context;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.HandlerResolverImpl;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;

public abstract class CxfEndpoint {
    public static final String CXF_JAXWS_PREFIX = "cxf.jaxws.";
    protected Bus bus;
    protected PortData port;
    protected Context context;
    protected Object implementor;
    protected Server server;
    protected Service service;
    protected JaxWsImplementorInfo implInfo;
    protected JaxWsServiceFactoryBean serviceFactory;
    protected HandlerResolverImpl handlerResolver;
    protected HTTPTransportFactory httpTransportFactory;
    protected ServiceConfiguration serviceConfiguration;

    public CxfEndpoint(Bus bus, PortData port, Context context, Object implementor, HTTPTransportFactory httpTransportFactory, ServiceConfiguration configuration) {
        this.bus = bus;
        this.port = port;
        this.context = context;
        this.implementor = implementor;
        this.httpTransportFactory = httpTransportFactory;
        this.serviceConfiguration = configuration;
        this.bus.setExtension((Object)this, CxfEndpoint.class);
    }

    protected Class getImplementorClass() {
        return this.implementor.getClass();
    }

    protected Endpoint getEndpoint() {
        return this.getServer().getEndpoint();
    }

    public boolean isSOAP11() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(this.implInfo.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.implInfo.getBindingType());
    }

    public boolean isHTTP() {
        return "http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType());
    }

    public ServerImpl getServer() {
        return (ServerImpl)this.server;
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.service.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.service.getExecutor();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public List<Source> getMetadata() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(Object arg0) {
    }

    public void publish(String address) {
        this.doPublish(address);
    }

    public void setMetadata(List<Source> arg0) {
    }

    public void setProperties(Map<String, Object> arg0) {
    }

    protected void doPublish(String address) {
        NoInitJaxWsServerFactoryBean svrFactory = new NoInitJaxWsServerFactoryBean();
        svrFactory.setBus(this.bus);
        svrFactory.setAddress(address);
        svrFactory.setServiceFactory((ReflectionServiceFactoryBean)this.serviceFactory);
        svrFactory.setStart(false);
        svrFactory.setServiceBean(this.implementor);
        svrFactory.setDestinationFactory((DestinationFactory)this.httpTransportFactory);
        svrFactory.setServiceClass(this.serviceFactory.getServiceClass());
        CxfUtil.configureEndpoint((AbstractEndpointFactory)svrFactory, (ServiceConfiguration)this.serviceConfiguration, (String)CXF_JAXWS_PREFIX);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType())) {
            svrFactory.setTransportId("http://cxf.apache.org/bindings/xformat");
        }
        this.server = svrFactory.create();
        this.init();
        this.getEndpoint();
        if (this.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)this.getBinding()).setMTOMEnabled(this.port.isMtomEnabled());
        }
        this.server.start();
    }

    protected void init() {
    }

    protected void initHandlers() throws Exception {
        PortInfoImpl portInfo = new PortInfoImpl(this.implInfo.getBindingType(), this.serviceFactory.getEndpointName(), this.service.getName());
        this.handlerResolver = new HandlerResolverImpl(this.port.getHandlerChains(), (Collection)this.port.getInjections(), this.context);
        List chain = this.handlerResolver.getHandlerChain((PortInfo)portInfo);
        this.getBinding().setHandlerChain(chain);
    }

    protected void destroyHandlers() {
        if (this.handlerResolver != null) {
            this.handlerResolver.destroyHandlers();
            this.handlerResolver = null;
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private class NoInitJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        public NoInitJaxWsServerFactoryBean() {
            this.doInit = false;
        }
    }
}

