/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Description;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ManagedAttribute;
import javax.management.ManagedOperation;
import javax.management.NotificationInfo;
import javax.management.NotificationInfos;
import javax.management.ReflectionException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class DynamicMBeanWrapper
implements DynamicMBean {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_DEPLOY, DynamicMBeanWrapper.class);
    private final MBeanInfo info;
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final Map<String, Method> operations = new HashMap<String, Method>();
    private final Object instance;

    public DynamicMBeanWrapper(Class<?> annotatedMBean) {
        NotificationInfos notifications;
        ArrayList<MBeanAttributeInfo> attributeInfos = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operationInfos = new ArrayList<MBeanOperationInfo>();
        ArrayList<MBeanNotificationInfo> notificationInfos = new ArrayList<MBeanNotificationInfo>();
        try {
            this.instance = annotatedMBean.newInstance();
        }
        catch (InstantiationException ie) {
            logger.error("can't instantiate " + annotatedMBean.getName(), ie);
            throw new IllegalArgumentException(annotatedMBean.getName());
        }
        catch (IllegalAccessException iae) {
            logger.error("can't instantiate " + annotatedMBean.getName(), iae);
            throw new IllegalArgumentException(annotatedMBean.getName());
        }
        Description classDescription = annotatedMBean.getAnnotation(Description.class);
        String description = this.getDescription(classDescription, "a MBean built by OpenEJB");
        NotificationInfo notification = annotatedMBean.getAnnotation(NotificationInfo.class);
        if (notification != null) {
            MBeanNotificationInfo notificationInfo = this.getNotificationInfo(notification);
            notificationInfos.add(notificationInfo);
        }
        if ((notifications = annotatedMBean.getAnnotation(NotificationInfos.class)) != null && notifications.value() != null) {
            for (Method method : notifications.value()) {
                MBeanNotificationInfo notificationInfo = this.getNotificationInfo((NotificationInfo)method);
                notificationInfos.add(notificationInfo);
            }
        }
        for (Method method : annotatedMBean.getMethods()) {
            int modifiers = method.getModifiers();
            if (method.getDeclaringClass().equals(Object.class) || !Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers)) continue;
            if (method.getAnnotation(ManagedAttribute.class) != null) {
                String methodName = method.getName();
                String attrName = methodName;
                if ((attrName.startsWith("get") && method.getParameterTypes().length == 0 || attrName.startsWith("set") && method.getParameterTypes().length == 1) && attrName.length() > 3) {
                    attrName = (attrName = attrName.substring(3)).length() > 1 ? Character.toLowerCase(attrName.charAt(0)) + attrName.substring(1) : attrName.toLowerCase();
                } else {
                    logger.warning("ignoring attribute " + method.getName() + " for " + annotatedMBean.getName());
                }
                if (methodName.startsWith("get")) {
                    this.getters.put(attrName, method);
                    continue;
                }
                if (!methodName.startsWith("set")) continue;
                this.setters.put(attrName, method);
                continue;
            }
            if (method.getAnnotation(ManagedOperation.class) == null) continue;
            this.operations.put(method.getName(), method);
            String operationDescr = "";
            Description descr = method.getAnnotation(Description.class);
            if (descr != null) {
                operationDescr = this.getDescription(descr, "-");
            }
            operationInfos.add(new MBeanOperationInfo(operationDescr, method));
        }
        for (Map.Entry<String, Method> e : this.getters.entrySet()) {
            String key = e.getKey();
            Method method = e.getValue();
            String attrDescr = "";
            Description descr = method.getAnnotation(Description.class);
            if (descr != null) {
                attrDescr = this.getDescription(descr, "-");
            }
            try {
                attributeInfos.add(new MBeanAttributeInfo(key, attrDescr, method, this.setters.get(key)));
            }
            catch (IntrospectionException ex) {
                logger.warning("can't manage " + key + " for " + method.getName(), ex);
            }
        }
        this.info = new MBeanInfo(annotatedMBean.getName(), description, attributeInfos.toArray(new MBeanAttributeInfo[attributeInfos.size()]), null, operationInfos.toArray(new MBeanOperationInfo[operationInfos.size()]), notificationInfos.toArray(new MBeanNotificationInfo[notificationInfos.size()]));
    }

    private MBeanNotificationInfo getNotificationInfo(NotificationInfo n) {
        String description = this.getDescription(n.description(), "-");
        MBeanNotificationInfo ni = new MBeanNotificationInfo(n.types(), n.notificationClass().getName(), description, new ImmutableDescriptor(n.descriptorFields()));
        return ni;
    }

    private String getDescription(Description d, String defaultValue) {
        if (d != null) {
            if (d.bundleBaseName() != null && d.key() != null) {
                try {
                    return ResourceBundle.getBundle(d.bundleBaseName()).getString(d.key());
                }
                catch (RuntimeException re) {
                    return d.value();
                }
            }
            return d.value();
        }
        return defaultValue;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.getters.containsKey(attribute)) {
            try {
                return this.getters.get(attribute).invoke(this.instance, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                logger.error("can't get " + attribute + " value", e);
            }
            catch (IllegalAccessException e) {
                logger.error("can't get " + attribute + " value", e);
            }
            catch (InvocationTargetException e) {
                logger.error("can't get " + attribute + " value", e);
            }
        }
        throw new AttributeNotFoundException();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.setters.containsKey(attribute.getName())) {
            try {
                this.setters.get(attribute.getName()).invoke(this.instance, attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                logger.error("can't set " + attribute + " value", e);
            }
            catch (IllegalAccessException e) {
                logger.error("can't set " + attribute + " value", e);
            }
            catch (InvocationTargetException e) {
                logger.error("can't set " + attribute + " value", e);
            }
        } else {
            throw new AttributeNotFoundException();
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String n : attributes) {
            try {
                list.add(new Attribute(n, this.getAttribute(n)));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                list.add(attr);
            }
            catch (Exception ignore) {}
        }
        return list;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.operations.containsKey(actionName)) {
            try {
                return this.operations.get(actionName).invoke(this.instance, params);
            }
            catch (IllegalArgumentException e) {
                logger.error(actionName + "can't be invoked", e);
            }
            catch (IllegalAccessException e) {
                logger.error(actionName + "can't be invoked", e);
            }
            catch (InvocationTargetException e) {
                logger.error(actionName + "can't be invoked", e);
            }
        }
        throw new MBeanException(new IllegalArgumentException(), actionName + " doesn't exist");
    }
}

