/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.singleton;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.LockType;
import javax.interceptor.AroundInvoke;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.singleton.Instance;
import org.apache.openejb.core.singleton.SingletonInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.apache.openejb.core.webservices.NoAddressingSupport;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.xbean.finder.ClassFinder;

public class SingletonContainer
implements RpcContainer {
    private SingletonInstanceManager instanceManager;
    private HashMap<String, BeanContext> deploymentRegistry = new HashMap();
    private Object containerID = null;
    private SecurityService securityService;
    private Duration accessTimeout;

    public SingletonContainer(Object id, SecurityService securityService) throws OpenEJBException {
        this.containerID = id;
        this.securityService = securityService;
        this.instanceManager = new SingletonInstanceManager(securityService);
        for (BeanContext beanContext : this.deploymentRegistry.values()) {
            beanContext.setContainer(this);
        }
    }

    public void setAccessTimeout(Duration duration) {
        this.accessTimeout = duration;
    }

    @Override
    public synchronized BeanContext[] getBeanContexts() {
        return this.deploymentRegistry.values().toArray(new BeanContext[this.deploymentRegistry.size()]);
    }

    @Override
    public synchronized BeanContext getBeanContext(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.SINGLETON;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        this.instanceManager.deploy(beanContext);
        String id = (String)beanContext.getDeploymentID();
        SingletonContainer singletonContainer = this;
        synchronized (singletonContainer) {
            this.deploymentRegistry.put(id, beanContext);
            beanContext.setContainer(this);
        }
        EjbTimerService timerService = beanContext.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    @Override
    public void start(BeanContext info) throws OpenEJBException {
        this.instanceManager.start(info);
    }

    @Override
    public void stop(BeanContext info) throws OpenEJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BeanContext beanContext) {
        ThreadContext threadContext = new ThreadContext(beanContext, null);
        ThreadContext old = ThreadContext.enter(threadContext);
        try {
            this.instanceManager.freeInstance(threadContext);
        }
        finally {
            ThreadContext.exit(old);
        }
        EjbTimerService timerService = beanContext.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        this.instanceManager.undeploy(beanContext);
        SingletonContainer singletonContainer = this;
        synchronized (singletonContainer) {
            String id = (String)beanContext.getDeploymentID();
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deploymentRegistry.remove(id);
        }
    }

    @Override
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    @Override
    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        BeanContext beanContext = this.getBeanContext(deployID);
        if (beanContext == null) {
            throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
        }
        if (type == null) {
            type = beanContext.getInterfaceType(callInterface);
        }
        Method runMethod = beanContext.getMatchingBeanMethod(callMethod);
        ThreadContext callContext = new ThreadContext(beanContext, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Object retValue;
            boolean authorized;
            boolean bl = authorized = type == InterfaceType.TIMEOUT || this.getSecurityService().isCallerAuthorized(callMethod, type);
            if (!authorized) {
                throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
            }
            Class<?> declaringClass = callMethod.getDeclaringClass();
            if (EJBHome.class.isAssignableFrom(declaringClass) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (callMethod.getName().startsWith("create")) {
                    ProxyInfo proxyInfo = this.createEJBObject(beanContext, callMethod);
                    return proxyInfo;
                }
                Object var13_14 = null;
                return var13_14;
            }
            if (EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) {
                Object var13_15 = null;
                return var13_15;
            }
            Instance instance = this.instanceManager.getInstance(callContext);
            callContext.setCurrentOperation(type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS);
            callContext.setCurrentAllowedStates(null);
            callContext.set(Method.class, runMethod);
            callContext.setInvokedInterface(callInterface);
            Object object = retValue = this._invoke(callMethod, runMethod, args, instance, callContext, type);
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _invoke(Method callMethod, Method runMethod, Object[] args, Instance instance, ThreadContext callContext, InterfaceType callType) throws OpenEJBException {
        Object returnValue;
        block12: {
            BeanContext beanContext = callContext.getBeanContext();
            Duration accessTimeout = this.getAccessTimeout(beanContext, runMethod);
            boolean read = beanContext.getConcurrencyAttribute(runMethod) == LockType.READ;
            Lock lock = this.aquireLock(read, accessTimeout, instance);
            try {
                TransactionPolicy txPolicy;
                block11: {
                    txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, callType), callContext);
                    returnValue = null;
                    try {
                        if (callType == InterfaceType.SERVICE_ENDPOINT) {
                            callContext.setCurrentOperation(Operation.BUSINESS_WS);
                            returnValue = this.invokeWebService(args, beanContext, runMethod, instance);
                            break block11;
                        }
                        List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, callType == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS, interceptors, instance.interceptors);
                        returnValue = interceptorStack.invoke(args);
                    }
                    catch (Throwable e) {
                        try {
                            ExceptionType type = beanContext.getExceptionType(e);
                            if (type == ExceptionType.SYSTEM) {
                                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                            } else {
                                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                        }
                    }
                }
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            }
            finally {
                lock.unlock();
            }
        }
        return returnValue;
    }

    private Duration getAccessTimeout(BeanContext beanContext, Method callMethod) {
        Duration accessTimeout = beanContext.getAccessTimeout(callMethod);
        if (accessTimeout == null && (accessTimeout = beanContext.getAccessTimeout()) == null) {
            accessTimeout = this.accessTimeout;
        }
        return accessTimeout;
    }

    private Lock aquireLock(boolean read, Duration accessTimeout, Instance instance) {
        boolean lockAcquired;
        Lock lock = read ? instance.lock.readLock() : instance.lock.writeLock();
        if (accessTimeout == null || accessTimeout.getTime() < 0L) {
            lock.lock();
            lockAcquired = true;
        } else if (accessTimeout.getTime() == 0L) {
            lockAcquired = lock.tryLock();
        } else {
            try {
                lockAcquired = lock.tryLock(accessTimeout.getTime(), accessTimeout.getUnit());
            }
            catch (InterruptedException e) {
                throw (ConcurrentAccessTimeoutException)new ConcurrentAccessTimeoutException("Unable to get lock within specified time on: " + instance).initCause((Throwable)e);
            }
        }
        if (!lockAcquired) {
            throw new ConcurrentAccessTimeoutException("Unable to get lock on: " + instance);
        }
        return lock;
    }

    private Object invokeWebService(Object[] args, BeanContext beanContext, Method runMethod, Instance instance) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("WebService calls must follow format {messageContext, interceptor, [arg...]}.");
        }
        Object messageContext = args[0];
        if (messageContext == null) {
            throw new IllegalArgumentException("MessageContext is null.");
        }
        Object interceptor = args[1];
        if (interceptor == null) {
            throw new IllegalArgumentException("Interceptor instance is null.");
        }
        HashMap<String, Object> interceptors = new HashMap<String, Object>(instance.interceptors);
        interceptors.put(interceptor.getClass().getName(), interceptor);
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>(beanContext.getMethodInterceptors(runMethod));
        InterceptorData providerData = new InterceptorData(interceptor.getClass());
        ClassFinder finder = new ClassFinder(new Class[]{interceptor.getClass()});
        providerData.getAroundInvoke().addAll(finder.findAnnotatedMethods(AroundInvoke.class));
        interceptorDatas.add(providerData);
        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS_WS, interceptorDatas, interceptors);
        Object[] params = new Object[runMethod.getParameterTypes().length];
        if (messageContext instanceof MessageContext) {
            ThreadContext.getThreadContext().set(MessageContext.class, (MessageContext)messageContext);
            return interceptorStack.invoke((MessageContext)messageContext, params);
        }
        if (messageContext instanceof javax.xml.ws.handler.MessageContext) {
            AddressingSupport wsaSupport = NoAddressingSupport.INSTANCE;
            for (int i = 2; i < args.length; ++i) {
                if (!(args[i] instanceof AddressingSupport)) continue;
                wsaSupport = (AddressingSupport)args[i];
            }
            ThreadContext.getThreadContext().set(AddressingSupport.class, wsaSupport);
            ThreadContext.getThreadContext().set(javax.xml.ws.handler.MessageContext.class, (javax.xml.ws.handler.MessageContext)messageContext);
            return interceptorStack.invoke((javax.xml.ws.handler.MessageContext)messageContext, params);
        }
        throw new IllegalArgumentException("Uknown MessageContext type: " + messageContext.getClass().getName());
    }

    protected ProxyInfo createEJBObject(BeanContext beanContext, Method callMethod) {
        return new ProxyInfo(beanContext, null);
    }
}

