/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.validation.ValidationException;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.OWBInjector;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.xbean.naming.context.ContextFlyweight;

public class OpenEjbContainer
extends EJBContainer {
    public static final String OPENEJB_EMBEDDED_REMOTABLE = "openejb.embedded.remotable";
    static Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, OpenEjbContainer.class);
    private static OpenEjbContainer instance;
    private final AppContext appContext;
    private ServiceManagerProxy serviceManager;
    private Options options;
    private GlobalContext globalJndiContext;

    private OpenEjbContainer(Map<?, ?> map, AppContext appContext) {
        this.appContext = appContext;
        this.globalJndiContext = new GlobalContext(appContext.getGlobalJndiContext());
        Properties properties = new Properties();
        properties.putAll(map);
        this.options = new Options(properties);
        this.startNetworkServices();
    }

    public void close() {
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
        try {
            this.globalJndiContext.close();
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
        OpenEJB.destroy();
        instance = null;
    }

    public Context getContext() {
        return this.globalJndiContext;
    }

    public <T> T inject(T object) {
        assert (object != null);
        Class<?> clazz = object.getClass();
        BeanContext context = this.resolve(clazz);
        if (context == null) {
            throw new NoInjectionMetaDataException(clazz.getName());
        }
        InjectionProcessor<T> processor = new InjectionProcessor<T>(object, context.getInjections(), context.getJndiContext());
        try {
            OWBInjector beanInjector = new OWBInjector(this.appContext.getWebBeansContext());
            beanInjector.inject(object);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            return processor.createInstance();
        }
        catch (OpenEJBException e) {
            throw new InjectionException(clazz.getName(), e);
        }
    }

    private <T> BeanContext resolve(Class<?> clazz) {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        while (clazz != null && clazz != Object.class) {
            BeanContext context = containerSystem.getBeanContext(clazz.getName());
            if (context != null) {
                return context;
            }
            for (BeanContext context2 : containerSystem.deployments()) {
                if (clazz != context2.getBeanClass()) continue;
                return context2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private void startNetworkServices() {
        if (!this.options.get(OPENEJB_EMBEDDED_REMOTABLE, false)) {
            return;
        }
        try {
            this.serviceManager = new ServiceManagerProxy();
            this.serviceManager.start();
        }
        catch (ServiceManagerProxy.AlreadyStartedException e) {
            logger.debug("Network services already started.  Ignoring option openejb.embedded.remotable");
        }
    }

    public static class InvalidApplicationException
    extends InitializationException {
        public InvalidApplicationException(Exception cause) {
            super(cause);
        }
    }

    public static class AssembleApplicationException
    extends InitializationException {
        public AssembleApplicationException(Exception cause) {
            super(cause);
        }
    }

    public static class ConfigureApplicationException
    extends InitializationException {
        public ConfigureApplicationException(Exception cause) {
            super(cause);
        }
    }

    public static class NoModulesFoundException
    extends InitializationException {
        public NoModulesFoundException(String s) {
            super(s);
        }
    }

    public static class NoSuchModuleException
    extends InitializationException {
        public NoSuchModuleException(String s) {
            super(s);
        }
    }

    public static class InvalidModulesPropertyException
    extends InitializationException {
        public InvalidModulesPropertyException(String s) {
            super(s);
        }
    }

    public static class InitializationException
    extends EJBException {
        public InitializationException(String s) {
            super(s);
        }

        public InitializationException(Exception cause) {
            super(cause);
        }
    }

    private class GlobalContext
    extends ContextFlyweight {
        private final Context globalJndiContext;

        public GlobalContext(Context globalJndiContext) {
            this.globalJndiContext = globalJndiContext;
        }

        protected Context getContext() throws NamingException {
            return this.globalJndiContext;
        }

        protected Name getName(Name name) throws NamingException {
            String first = name.get(0);
            if (!first.startsWith("java:")) {
                throw new NameNotFoundException("Name must be in java: namespace");
            }
            first = first.substring("java:".length());
            name = name.getSuffix(1);
            return name.add(0, first);
        }

        protected String getName(String name) throws NamingException {
            if ("inject".equals(name)) {
                return name;
            }
            if (!name.startsWith("java:")) {
                throw new NameNotFoundException("Name must be in java: namespace");
            }
            return name.substring("java:".length());
        }

        public void bind(Name name, Object obj) throws NamingException {
            if (name.size() == 1 && "inject".equals(name.get(0))) {
                OpenEjbContainer.this.inject(obj);
            } else {
                super.bind(name, obj);
            }
        }

        public void bind(String name, Object obj) throws NamingException {
            if (name != null && "inject".equals(name)) {
                OpenEjbContainer.this.inject(obj);
            } else {
                super.bind(name, obj);
            }
        }
    }

    public static class Provider
    implements EJBContainerProvider {
        public EJBContainer createEJBContainer(Map<?, ?> map) {
            if (Provider.isOtherProvider(map)) {
                return null;
            }
            if (instance != null || OpenEJB.isInitialized()) {
                logger.info("EJBContainer already initialized.  Call ejbContainer.close() to allow reinitialization");
                return instance;
            }
            try {
                AppContext appContext;
                AppInfo appInfo;
                Properties properties = new Properties();
                properties.putAll(map);
                SystemInstance.reset();
                SystemInstance.init((Properties)properties);
                SystemInstance.get().setProperty("openejb.embedded", "true");
                SystemInstance.get().setProperty(EJBContainer.class.getName(), "true");
                OptionsLog.install();
                OpenEJB.init(properties);
                ConfigurationFactory configurationFactory = new ConfigurationFactory();
                AppModule appModule = this.load(map, configurationFactory);
                Set<String> callers = NewLoaderLogic.callers();
                EjbJar ejbJar = new EjbJar();
                OpenejbJar openejbJar = new OpenejbJar();
                for (String caller : callers) {
                    if (!this.isValid(caller)) continue;
                    ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(caller, caller));
                    bean.setTransactionType(TransactionType.BEAN);
                    EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
                    ejbDeployment.setDeploymentId(caller);
                }
                appModule.getEjbModules().add(new EjbModule(ejbJar, openejbJar));
                try {
                    appInfo = configurationFactory.configureApplication(appModule);
                }
                catch (ValidationFailedException e) {
                    logger.warning("configureApplication.loadFailed", appModule.getModuleId(), e.getMessage());
                    throw new InvalidApplicationException(e);
                }
                catch (OpenEJBException e) {
                    logger.warning("configureApplication.loadFailed", e, appModule.getModuleId(), e.getMessage());
                    throw new ConfigureApplicationException(e);
                }
                Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
                try {
                    appContext = assembler.createApplication(appInfo, appModule.getClassLoader());
                }
                catch (ValidationException ve) {
                    throw ve;
                }
                catch (Exception e) {
                    throw new AssembleApplicationException(e);
                }
                OpenEjbContainer openEjbContainer = instance = new OpenEjbContainer(map, appContext);
                return openEjbContainer;
            }
            catch (OpenEJBException e) {
                throw new EJBException((Exception)e);
            }
            catch (MalformedURLException e) {
                throw new EJBException((Exception)e);
            }
            catch (ValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                throw new InitializationException(e);
            }
            finally {
                if (instance == null && OpenEJB.isInitialized()) {
                    try {
                        OpenEJB.destroy();
                    }
                    catch (Exception e) {}
                }
            }
        }

        private boolean isValid(String caller) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass(caller);
                if (clazz.isEnum()) {
                    return false;
                }
                if (clazz.isInterface()) {
                    return false;
                }
                return !Modifier.isAbstract(clazz.getModifiers());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private AppModule load(Map<?, ?> map, ConfigurationFactory configurationFactory) throws MalformedURLException, OpenEJBException {
            List<File> moduleLocations;
            String appId = (String)map.get("javax.ejb.embeddable.appName");
            Object modules = map.get("javax.ejb.embeddable.modules");
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (modules instanceof String) {
                moduleLocations = configurationFactory.getModulesFromClassPath(null, classLoader);
                Iterator i = moduleLocations.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    if (this.match((String)modules, file)) continue;
                    i.remove();
                }
            } else if (modules instanceof String[]) {
                moduleLocations = configurationFactory.getModulesFromClassPath(null, classLoader);
                int matched = 0;
                Iterator i = moduleLocations.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    boolean remove = true;
                    for (String s : (String[])modules) {
                        if (!this.match(s, file)) continue;
                        remove = false;
                        ++matched;
                        break;
                    }
                    if (!remove) continue;
                    i.remove();
                }
                if (matched != ((String[])modules).length) {
                    throw this.specifiedModulesNotFound();
                }
            } else if (modules instanceof File) {
                URL url = ((File)modules).toURI().toURL();
                classLoader = new URLClassLoader(new URL[]{url}, classLoader);
                moduleLocations = Collections.singletonList((File)modules);
            } else if (modules instanceof File[]) {
                File[] files = (File[])modules;
                URL[] urls = new URL[files.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = files[i].toURI().toURL();
                }
                classLoader = new URLClassLoader(urls, classLoader);
                moduleLocations = Arrays.asList((File[])modules);
            } else if (modules == null) {
                moduleLocations = configurationFactory.getModulesFromClassPath(null, classLoader);
            } else {
                AppModule appModule = this.load(map);
                if (appModule != null) {
                    return appModule;
                }
                throw this.invalidModulesValue(modules);
            }
            if (moduleLocations.isEmpty()) {
                throw Exceptions.newNoModulesFoundException();
            }
            return configurationFactory.loadApplication(classLoader, appId, moduleLocations);
        }

        private AppModule load(Map<?, ?> map) {
            String appId = (String)map.get("javax.ejb.embeddable.appName");
            Object modules = map.get("javax.ejb.embeddable.modules");
            map.size();
            Object obj = modules;
            Application application = null;
            AppModule appModule = new AppModule(this.getClass().getClassLoader(), appId);
            if (obj instanceof EjbJar) {
                EjbJar ejbJar = (EjbJar)obj;
                appModule.getEjbModules().add(new EjbModule(ejbJar));
            } else if (obj instanceof EnterpriseBean) {
                EnterpriseBean bean = (EnterpriseBean)obj;
                EjbJar ejbJar = new EjbJar();
                ejbJar.addEnterpriseBean(bean);
                appModule.getEjbModules().add(new EjbModule(ejbJar));
            } else if (obj instanceof Application) {
                application = (Application)obj;
            } else if (obj instanceof Connector) {
                Connector connector = (Connector)obj;
                appModule.getConnectorModules().add(new ConnectorModule(connector));
            } else if (obj instanceof Persistence) {
                Persistence persistence = (Persistence)obj;
                appModule.getPersistenceModules().add(new PersistenceModule("", persistence));
            } else if (obj instanceof PersistenceUnit) {
                PersistenceUnit unit = (PersistenceUnit)obj;
                appModule.getPersistenceModules().add(new PersistenceModule("", new Persistence(new PersistenceUnit[]{unit})));
            } else if (obj instanceof Beans) {
                Beans beans = (Beans)obj;
                EjbModule ejbModule = new EjbModule(new EjbJar());
                ejbModule.setBeans(beans);
                appModule.getEjbModules().add(ejbModule);
            }
            if (application != null) {
                AppModule newModule = new AppModule(appModule.getClassLoader(), appModule.getModuleId(), application, false);
                newModule.getClientModules().addAll(appModule.getClientModules());
                newModule.getPersistenceModules().addAll(appModule.getPersistenceModules());
                newModule.getEjbModules().addAll(appModule.getEjbModules());
                newModule.getConnectorModules().addAll(appModule.getConnectorModules());
                appModule = newModule;
            }
            AppModule m = appModule;
            return m;
        }

        private EJBException specifiedModulesNotFound() {
            return new NoSuchModuleException("some modules not matched on classpath");
        }

        private InvalidModulesPropertyException invalidModulesValue(Object value) {
            Object[] spec = new String[]{"java.lang.String", "java.lang.String[]", "java.io.File", "java.io.File[]"};
            String type = value == null ? null : value.getClass().getName();
            return new InvalidModulesPropertyException(String.format("Invalid '%s' value '%s'. Valid values are: %s", "javax.ejb.embeddable.modules", type, Join.join(", ", spec)));
        }

        private static boolean isOtherProvider(Map<?, ?> properties) {
            Object provider = properties.get("javax.ejb.embeddable.provider");
            return provider != null && !provider.equals(OpenEjbContainer.class) && !provider.equals(OpenEjbContainer.class.getName());
        }

        private boolean match(String s, File file) {
            String s2 = file.getName();
            boolean matches = file.isDirectory() ? s2.equals(s) || s2.equals(s + ".jar") : s2.equals(s + ".jar");
            if (!matches) {
                // empty if block
            }
            return matches;
        }
    }

    public static class InjectionException
    extends IllegalStateException {
        public InjectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class NoInjectionMetaDataException
    extends IllegalStateException {
        public NoInjectionMetaDataException(String s) {
            super(s);
        }
    }
}

