/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugins;

import java.io.File;
import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class TomEEEmbeddedMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.packaging}")
    protected String packaging;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    protected File warFile;
    @Parameter(property="tomee-embedded-plugin.http", defaultValue="8080")
    private int httpPort;
    @Parameter(property="tomee-embedded-plugin.ajp", defaultValue="8009")
    private int ajpPort = 8009;
    @Parameter(property="tomee-embedded-plugin.stop", defaultValue="8005")
    private int stopPort;
    @Parameter(property="tomee-embedded-plugin.host", defaultValue="localhost")
    private String host;
    @Parameter(property="tomee-embedded-plugin.lib", defaultValue="${project.build.directory}/apache-tomee-embedded")
    protected String dir;
    @Parameter
    private File serverXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.packaging)) {
            this.getLog().warn((CharSequence)"this project is a pom, it is not deployable");
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        System.setProperty("openejb.log.factory", "org.apache.openejb.maven.util.MavenLogStreamFactory");
        final Container container = new Container();
        Configuration config = this.getConfig();
        container.setup(config);
        try {
            container.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        container.undeploy(TomEEEmbeddedMojo.this.warFile.getAbsolutePath());
                        container.stop();
                    }
                    catch (Exception e) {
                        TomEEEmbeddedMojo.this.getLog().error((CharSequence)"can't stop TomEE", (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            container.deploy(this.warFile.getName(), this.warFile);
            this.getLog().info((CharSequence)("TomEE embedded started on " + config.getHost() + ":" + config.getHttpPort()));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"can't start TomEE", (Throwable)e);
        }
        try {
            latch.await();
        }
        catch (Exception e) {
            Thread.interrupted();
        }
        finally {
            System.clearProperty("openejb.log.factory");
        }
    }

    private Configuration getConfig() {
        Configuration config = new Configuration();
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field configField = Configuration.class.getDeclaredField(field.getName());
                field.setAccessible(true);
                configField.setAccessible(true);
                Object value = field.get((Object)this);
                if (value == null) continue;
                configField.set(config, value);
                this.getLog().info((CharSequence)("using " + field.getName() + " = " + value));
            }
            catch (NoSuchFieldException configField) {
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("can't initialize attribute " + field.getName()));
            }
        }
        return config;
    }
}

