/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.embedded;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import org.apache.openejb.AppContext;
import org.apache.openejb.arquillian.common.FileUtils;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class EmbeddedTomEEContainer
extends TomEEContainer {
    public static final String TOMEE_ARQUILLIAN_HTTP_PORT = "tomee.arquillian.http";
    public static final String TOMEE_ARQUILLIAN_STOP_PORT = "tomee.arquillian.stop";
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> contextInstance;
    @Inject
    @DeploymentScoped
    private InstanceProducer<BeanManager> beanManagerInstance;
    private static final Map<Archive<?>, File> ARCHIVES = new ConcurrentHashMap();
    private Container container;
    private Properties savedProperties;

    public Class<TomEEConfiguration> getConfigurationClass() {
        return TomEEConfiguration.class;
    }

    public void setup(TomEEConfiguration configuration) {
        this.configuration = configuration;
        this.setSystemProperties();
        this.container = new Container();
        this.container.setup(this.convertConfiguration(configuration));
    }

    private Configuration convertConfiguration(TomEEConfiguration tomeeConfiguration) {
        Configuration configuration = new Configuration();
        configuration.setDir(tomeeConfiguration.getDir());
        configuration.setHttpPort(this.getPortAndShare(TOMEE_ARQUILLIAN_HTTP_PORT, tomeeConfiguration.getHttpPort()));
        configuration.setStopPort(this.getPortAndShare(TOMEE_ARQUILLIAN_STOP_PORT, tomeeConfiguration.getStopPort()));
        return configuration;
    }

    private int getPortAndShare(String systemPropName, int value) {
        int port = value;
        if (port <= 0) {
            port = NetworkUtil.getNextAvailablePort();
        }
        System.setProperty(systemPropName, Integer.toString(port));
        return port;
    }

    public void start() throws LifecycleException {
        try {
            this.container.start();
            this.contextInstance.set((Object)this.container.getJndiContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifecycleException("Something went wrong", (Throwable)e);
        }
    }

    private void setSystemProperties() {
        this.savedProperties = new Properties();
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> entry : this.configuration.systemProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (props.contains(key)) {
                this.savedProperties.put(key, System.getProperty(key));
            }
            props.setProperty(key, (String)entry.getValue());
        }
    }

    private void clearSystemProperties() {
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> entry : this.configuration.systemProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (this.savedProperties.contains(key)) {
                System.setProperty(key, this.savedProperties.getProperty(key));
                continue;
            }
            props.remove(key);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.container.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to stop server", (Throwable)e);
        }
        this.clearSystemProperties();
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            File tempDir = FileUtils.createTempDir();
            String name = archive.getName();
            File file = new File(tempDir, name);
            ARCHIVES.put(archive, file);
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(file, true);
            AppContext appContext = this.container.deploy(name, file);
            HTTPContext httpContext = new HTTPContext("0.0.0.0", this.configuration.getHttpPort());
            httpContext.add(new Servlet("ArquillianServletRunner", "/" + this.getArchiveNameWithoutExtension(archive)));
            this.beanManagerInstance.set((Object)appContext.getBeanManager());
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("Unable to deploy", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            String name = archive.getName();
            this.container.undeploy(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("Unable to undeploy", (Throwable)e);
        }
        File file = ARCHIVES.remove(archive);
        File folder = new File(file.getParentFile(), file.getName().substring(0, file.getName().length() - 5));
        if (folder.exists()) {
            FileUtils.delete((File)folder);
        }
        FileUtils.delete((File)file);
    }
}

