/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common.enrichment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.mockito.MockitoEnricher;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.AppFinder;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.jboss.arquillian.test.spi.TestClass;

public final class OpenEJBEnricher {
    private static final Logger LOGGER = Logger.getLogger(OpenEJBEnricher.class.getName());

    private OpenEJBEnricher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enrich(Object testInstance, AppContext appCtx) {
        BeanContext context;
        block12: {
            new MockitoEnricher().enrich(testInstance);
            AppContext ctx = appCtx;
            if (ctx == null && (ctx = (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE)) == null) {
                return;
            }
            context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getBeanContext((Object)(ctx.getId() + "_" + testInstance.getClass().getName()));
            BeanManagerImpl bm = OpenEJBEnricher.findBeanManager(ctx);
            if (bm != null && bm.isInUse()) {
                try {
                    Set beans = bm.getBeans(testInstance.getClass(), new Annotation[0]);
                    Bean bean = bm.resolve(beans);
                    CreationalContextImpl cc = bm.createCreationalContext((Contextual)bean);
                    if (context != null) {
                        context.set(CreationalContext.class, (Object)cc);
                    }
                    OWBInjector.inject((BeanManager)bm, (Object)testInstance, (CreationalContext)cc);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Failed injection on: " + testInstance.getClass(), t);
                    if (RuntimeException.class.isInstance(t)) {
                        throw (RuntimeException)RuntimeException.class.cast(t);
                    }
                    if (!Exception.class.isInstance(t)) break block12;
                    throw new OpenEJBRuntimeException((Exception)Exception.class.cast(t));
                }
            }
        }
        if (context != null) {
            ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
            ThreadContext oldContext = ThreadContext.enter((ThreadContext)callContext);
            try {
                InjectionProcessor processor = new InjectionProcessor(testInstance, (Collection)context.getInjections(), context.getJndiContext());
                processor.createInstance();
            }
            catch (OpenEJBException e) {
            }
            finally {
                ThreadContext.exit((ThreadContext)oldContext);
            }
        }
    }

    private static BeanManagerImpl findBeanManager(AppContext ctx) {
        if (ctx != null) {
            return ctx.getWebBeansContext().getBeanManagerImpl();
        }
        try {
            return WebBeansContext.currentInstance().getBeanManagerImpl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[] resolve(AppContext appContext, TestClass testClass, Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        if (appContext == null) {
            return values;
        }
        BeanManagerImpl beanManager = OpenEJBEnricher.findBeanManager(appContext);
        if (beanManager == null) {
            return values;
        }
        Class<?> clazz = testClass != null ? testClass.getJavaClass() : method.getDeclaringClass();
        AnnotatedElementFactory factory = beanManager.getWebBeansContext().getAnnotatedElementFactory();
        AnnotatedMethod am = factory.newAnnotatedMethod(method, factory.newAnnotatedType(clazz));
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                values[i] = OpenEJBEnricher.getParamInstance(beanManager, i, am);
                continue;
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
            }
        }
        return values;
    }

    private static <T> T getParamInstance(BeanManagerImpl manager, int position, AnnotatedMethod<?> am) {
        AnnotationManager annotationManager = manager.getWebBeansContext().getAnnotationManager();
        AnnotatedParameter ap = (AnnotatedParameter)am.getParameters().get(position);
        Type baseType = ap.getBaseType();
        Set beans = manager.getBeans(baseType, annotationManager.getInterceptorBindingMetaAnnotations(ap.getAnnotations()));
        if (beans == null) {
            return null;
        }
        Bean bean = manager.resolve(beans);
        if (bean == null) {
            return null;
        }
        CreationalContextImpl creational = manager.createCreationalContext(null);
        return (T)manager.getReference(bean, baseType, (CreationalContext)creational);
    }
}

